@extends('admin.layouts.app')
@section('panel')

        <div class="row">
            <div class="col-lg-12 col-md-12 mb-30">
                <div class="card">
                    <div class="card-body">
                        <form action="#" method="POST" enctype="multipart/form-data">
                            @csrf
                            <input type="hidden" name="type" value="content">
                            <div class="row">
                                <div class="col-md-12">
                                    <div class="form-group">
                                        <label>Update Your Prospectus PDF File</label>
                                        <input type="file" class="form-control" name="prospectus_file" accept=".pdf"  required />
                                    </div>
                                </div>
                            </div>
                            <div class="form-group">
                                <button type="submit" class="btn btn--primary w-100 h-45">@lang('Submit')</button>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
        
        
        
         @if ($general->prospectus_file)
        <div class="row">
            <div class="col-lg-12 col-md-12 mb-30">
                   <div class="card">
                       <div class="card-body">
                           <embed src="{{ getImage(getFilePath('prospectus').  '/'. @$general->prospectus_file) }}" type="application/pdf" width="100%" height="600px" />
                       </div>
                   </div>
            </div>
        </div>
         @endif
        
 
@endsection





@push('style-lib')
    <link href="{{ asset('assets/admin/css/fontawesome-iconpicker.min.css') }}" rel="stylesheet">
@endpush

@push('script-lib')
    <script src="{{ asset('assets/admin/js/fontawesome-iconpicker.js') }}"></script>
@endpush

@push('script')
    <script>
        (function($) {
            "use strict";
           
        })(jQuery);
    </script>
@endpush
