@extends('admin.layouts.app')
@section('panel')
    <div class="row mb-none-30">
        <div class="col-lg-12 col-md-12 mb-30">
            <div class="card">
                <div class="card-body">
                    <form action="" method="POST">
                        @csrf
                        <div class="row">
                            <div class="col-md-3 col-sm-6">
                                <div class="form-group ">
                                    <label> @lang('Site Title')</label>
                                    <input class="form-control" type="text" name="site_name" required value="{{ $general->site_name }}">
                                </div>
                            </div>
                            <div class="col-md-3 col-sm-6">
                                <div class="form-group ">
                                    <label>@lang('Currency')</label>
                                    <input class="form-control" type="text" name="cur_text" required value="{{ $general->cur_text }}">
                                </div>
                            </div>
                            <div class="col-md-3 col-sm-6">
                                <div class="form-group ">
                                    <label>@lang('Currency Symbol')</label>
                                    <input class="form-control" type="text" name="cur_sym" required value="{{ $general->cur_sym }}">
                                </div>
                            </div>
                            <div class="form-group col-md-3 col-sm-6">
                              <label>@lang('Timezone')</label>
                              <select class="select2-basic form-control" name="timezone">
                                @foreach ($timezones as $tz)
                                  <option value="{{ $tz }}" {{ config('app.timezone') === $tz ? 'selected' : '' }}>
                                    {{ $tz }}
                                  </option>
                                @endforeach
                              </select>
                            </div>
                            <div class="form-group col-md-4 col-sm-6">
                                <label> @lang('Site Base Color')</label>
                                <div class="input-group">
                                    <span class="input-group-text p-0 border-0">
                                        <input type='text' class="form-control colorPicker" value="{{ $general->base_color }}" />
                                    </span>
                                    <input type="text" class="form-control colorCode" name="base_color" value="{{ $general->base_color }}" />
                                </div>
                            </div>

                            <div class="form-group col-md-4 col-sm-6">
                                <label> @lang('Site Secondary Color')</label>
                                <div class="input-group">
                                    <span class="input-group-text p-0 border-0">
                                        <input type='text' class="form-control colorPicker" value="{{ $general->secondary_color }}" />
                                    </span>
                                    <input type="text" class="form-control colorCode" name="secondary_color" value="{{ $general->secondary_color }}" />
                                </div>
                            </div> 
                            
                            <div class="col-md-4 col-sm-6">
                              <div class="form-group">
                                <label>@lang('Rate'): 1 POL = {{ getAmount($general->mgr_amount) }} MGR</label>
                                <div class="input-group">
                                  <input
                                    class="form-control"
                                    type="text"
                                    name="mgr_amount"
                                    required
                                    value="{{ getAmount($general->mgr_amount) }}"
                                  >
                                  <div class="input-group-text">MGR</div>
                                </div>
                              </div>
                            </div>

                            
                

                            <div class="col-md-4 col-sm-6">
                                <div class="form-group">
                                    <label>@lang('Min Trade')</label>
                                    <div class="input-group">
                                        <input class="form-control min-trade" type="text" step="any" name="min_trade" required value="{{ getAmount($general->min_trade) }}">
                                        <div class="input-group-text">POL</div>
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-4 col-sm-6">
                                <div class="form-group">
                                    <label>@lang('Max Trade')</label>
                                    <div class="input-group">
                                        <input class="form-control max-trade" type="text" step="any" name="max_trade" required value="{{ getAmount($general->max_trade) }}">
                                          <div class="input-group-text">POL</div>
                                    </div>
                                </div>
                            </div>
                            
                            <div class="col-md-4 col-sm-6">
                              <div class="form-group">
                                <label>@lang('Fake Transactions Mode')</label>
                                <select name="fake_trns" class="form-control form--select">
                                  <option value="0" {{ (int)($general->fake_trns ?? 0) === 0 ? 'selected' : '' }}>
                                    @lang('Both (buys & sells)')
                                  </option>
                                  <option value="1" {{ (int)($general->fake_trns ?? 0) === 1 ? 'selected' : '' }}>
                                    @lang('Buy only')
                                  </option>
                                  <option value="2" {{ (int)($general->fake_trns ?? 0) === 2 ? 'selected' : '' }}>
                                    @lang('Sell only')
                                  </option>
                                </select>
                                <small class="text-muted d-block mt-1">
                                  @lang('Controls Live MGR Trades generation and chart color mix.')
                                </small>
                              </div>
                            </div>
                            
                            <div class="col-md-4 col-sm-6">
                              <div class="form-group">
                                <label>@lang('Market Cap')</label>
                                <div class="input-group">
                                  <input
                                    class="form-control market-cap"
                                    type="text"
                                    name="market_cap" step="any"
                                    required
                                    value="{{ getAmount($general->market_cap) }}"
                                  >
                                  <div class="input-group-text">USD</div>
                                </div>
                                <small class="text-muted d-block mt-1" id="marketCapHuman">
                                  {{-- server-side initial fallback --}}
                                  {{ '$' . number_format((float)$general->market_cap, 0, '.', ',') }}
                                </small>
                              </div>
                            </div>
                            
                            <div class="col-md-4 col-sm-6">
                              <div class="form-group">
                                <label>@lang('Liquidity')</label>
                                <div class="input-group">
                                  <input
                                    class="form-control liquidity"
                                    type="text" step="any"
                                    name="liquidity"
                                    required
                                    value="{{ getAmount($general->liquidity) }}"
                                  >
                                  <div class="input-group-text">USD</div>
                                </div>
                                <small class="text-muted d-block mt-1" id="liquidityHuman">
                                  {{ '$' . number_format((float)$general->liquidity, 0, '.', ',') }}
                                </small>
                              </div>
                            </div>


                            <div class="col-md-4 col-sm-6">
                                <div class="form-group">
                                    <label>@lang('Registration Bonus')</label>
                                    <div class="input-group">
                                        <input class="form-control bal-charge" type="text" name="signup_bonus_amount" required value="{{ getAmount($general->signup_bonus_amount) }}" @if (!$general->signup_bonus_control) readonly @endif>
                                        <div class="input-group-text">{{ $general->cur_text }}</div>
                                        @if (!$general->signup_bonus_control)
                                            <small class="text--small text-muted"><i><i class="las la-info-circle"></i> @lang('To give the registration bonus, please enable the module from the') <a href="{{ route('admin.setting.system.configuration') }}" class="text--small">@lang('System Configuration')</a></i></small>
                                        @endif
                                    </div>
                                </div>
                            </div>
                            
                         



                        </div>

                        <div class="form-group">
                            <button type="submit" class="btn btn--primary w-100 h-45">@lang('Submit')</button>
                        </div>

                    </form>
                </div>
            </div>
        </div>
    </div>
    
    
    <!-- 
    <div class="card mt-5">
        <div class="card-header"><b class="lead">@lang('ROI Wallet Withdrawal Days Settings')</b></div>
        <form action="{{ route('admin.setting.offday') }}" method="post">
            @csrf
            <div class="card-body">
                <div class="row">
                    <div class="form-group col-lg-3 col-sm-6 col-md-4">
                        <label class="form-control-label"> @lang('Sunday')</label>
                        <input type="checkbox" data-height="50" data-width="100%" data-size="large" data-onstyle="-danger"
                            data-offstyle="-success" data-bs-toggle="toggle" data-on="@lang('NOT ALLOWED')"
                            data-off="@lang('ALLOWED')" name="off_day[sun]" @if(@$general->off_day->sun) checked @endif>
                    </div>
                    <div class="form-group col-lg-3 col-sm-6 col-md-4">
                        <label class="form-control-label"> @lang('Monday')</label>
                        <input type="checkbox" data-height="50" data-width="100%" data-size="large" data-onstyle="-danger"
                            data-offstyle="-success" data-bs-toggle="toggle" data-on="@lang('NOT ALLOWED')"
                            data-off="@lang('ALLOWED')" name="off_day[mon]" @if(@$general->off_day->mon) checked @endif>
                    </div>
                    <div class="form-group col-lg-3 col-sm-6 col-md-4">
                        <label class="form-control-label"> @lang('Tuesday')</label>
                        <input type="checkbox" data-height="50" data-width="100%" data-size="large" data-onstyle="-danger"
                            data-offstyle="-success" data-bs-toggle="toggle" data-on="@lang('NOT ALLOWED')"
                            data-off="@lang('ALLOWED')" name="off_day[tue]" @if(@$general->off_day->tue) checked @endif>
                    </div>
                    <div class="form-group col-lg-3 col-sm-6 col-md-4">
                        <label class="form-control-label"> @lang('Wednesday')</label>
                        <input type="checkbox" data-height="50" data-width="100%" data-size="large" data-onstyle="-danger"
                            data-offstyle="-success" data-bs-toggle="toggle" data-on="@lang('NOT ALLOWED')"
                            data-off="@lang('ALLOWED')" name="off_day[wed]" @if(@$general->off_day->wed) checked @endif>
                    </div>
                    <div class="form-group col-lg-3 col-sm-6 col-md-4">
                        <label class="form-control-label"> @lang('Thursday')</label>
                        <input type="checkbox" data-height="50" data-width="100%" data-size="large" data-onstyle="-danger"
                            data-offstyle="-success" data-bs-toggle="toggle" data-on="@lang('NOT ALLOWED')"
                            data-off="@lang('ALLOWED')" name="off_day[thu]" @if(@$general->off_day->thu) checked @endif>
                    </div>
                    <div class="form-group col-lg-3 col-sm-6 col-md-4">
                        <label class="form-control-label"> @lang('Friday')</label>
                        <input type="checkbox" data-height="50" data-width="100%" data-size="large" data-onstyle="-danger"
                            data-offstyle="-success" data-bs-toggle="toggle" data-on="@lang('NOT ALLOWED')"
                            data-off="@lang('ALLOWED')" name="off_day[fri]" @if(@$general->off_day->fri) checked @endif>
                    </div>
                    <div class="form-group col-lg-3 col-sm-6 col-md-4">
                        <label class="form-control-label"> @lang('Saturday')</label>
                        <input type="checkbox" data-height="50" data-width="100%" data-size="large" data-onstyle="-danger"
                            data-offstyle="-success" data-bs-toggle="toggle" data-on="@lang('NOT ALLOWED')"
                            data-off="@lang('ALLOWED')" name="off_day[sat]" @if(@$general->off_day->sat) checked @endif>
                    </div>
                    <div class="form-group mb-0">
                        <button type="submit" class="btn btn--primary w-100 h-45">@lang('Submit')</button>
                    </div>
                </div>
            </div>
        </form>
    </div>-->
@endsection

@push('style')
    <style>
        .border-line-area {
            position: relative;
            text-align: center;
            z-index: 1;
        }

        .border-line-area::before {
            position: absolute;
            content: '';
            top: 50%;
            left: 0;
            width: 100%;
            height: 1px;
            background-color: #e5e5e5;
            z-index: -1;
        }

        .border-line-title {
            display: inline-block;
            padding: 3px 10px;
            background-color: #fff;
        }
    </style>
@endpush

@push('script-lib')
    <script src="{{ asset('assets/admin/js/spectrum.js') }}"></script>
@endpush

@push('style-lib')
    <link rel="stylesheet" href="{{ asset('assets/admin/css/spectrum.css') }}">
@endpush

@push('script')

    <script>
    (function() {
      const $mcapInput  = document.querySelector('input.market-cap');
      const $liqInput   = document.querySelector('input.liquidity');
      const $mcapHuman  = document.getElementById('marketCapHuman');
      const $liqHuman   = document.getElementById('liquidityHuman');
    
      // Compact USD formatter: 1234 -> $1.23k, 1250000 -> $1.25M, etc.
      function abbrUSD(v) {
        const n = Number(String(v).replace(/[, ]/g, '')) || 0;
        const abs = Math.abs(n);
        let out, unit = '';
        if (abs >= 1e12) { out = (n/1e12).toFixed(2); unit = 'T'; }
        else if (abs >= 1e9) { out = (n/1e9).toFixed(2); unit = 'B'; }
        else if (abs >= 1e6) { out = (n/1e6).toFixed(2); unit = 'M'; }
        else if (abs >= 1e3) { out = (n/1e3).toFixed(2); unit = 'k'; }
        else { out = n.toFixed(2); }
        // trim trailing .00 or .0
        out = out.replace(/\.00$|(\.\d)0$/,'$1');
        return '$' + out + (unit ? unit : '');
      }
    
      function updateHint(inputEl, hintEl) {
        if (!inputEl || !hintEl) return;
        hintEl.textContent = abbrUSD(inputEl.value);
      }
    
      // Initial paint
      updateHint($mcapInput, $mcapHuman);
      updateHint($liqInput,  $liqHuman);
    
      // Live updates while typing
      [$mcapInput, $liqInput].forEach(el => {
        if (!el) return;
        el.addEventListener('input', () => {
          if (el === $mcapInput) updateHint($mcapInput, $mcapHuman);
          if (el === $liqInput)  updateHint($liqInput,  $liqHuman);
        });
        el.addEventListener('change', () => {
          if (el === $mcapInput) updateHint($mcapInput, $mcapHuman);
          if (el === $liqInput)  updateHint($liqInput,  $liqHuman);
        });
      });
    })();
    </script>


    <script>
        (function($) {
            "use strict";
            $('.colorPicker').spectrum({
                color: $(this).data('color'),
                change: function(color) {
                    $(this).parent().siblings('.colorCode').val(color.toHexString().replace(/^#?/, ''));
                }
            });

            $('.colorCode').on('input', function() {
                var clr = $(this).val();
                $(this).parents('.input-group').find('.colorPicker').spectrum({
                    color: clr,
                });
            });

            //$('select[name=timezone]').val("'{{ config('app.timezone') }}'").select2();
            $('.select2-basic').select2({
                dropdownParent: $('.card-body')
            });

            $('[name=b_transfer]').change(function() {
                if ($(this).is(":checked")) {
                    $('.bal-charge').removeAttr('readonly');
                } else {
                    $('.bal-charge').attr('readonly', true);
                }
            }).change();
        })(jQuery);
    </script>
@endpush
