@extends('admin.layouts.app')
@section('panel')
    <div class="row">
        <div class="col-lg-12">
            <div class="card b-radius--10 ">
                <div class="card-body p-0">
                    <div class="table-responsive--md  table-responsive">
                        <table class="table table--light style--two">
                            <thead>
                                <tr>
                                    <th>@lang('User')</th>
                                    <th>@lang('Wallet Address')</th>
                              
                                    <th>@lang('Joined At')</th>
                                    <th>@lang('Balance')</th>
                                    <th>@lang('Action')</th>
                                </tr>
                            </thead>
                            <tbody>
                                @forelse($users as $user)
                                    <tr>
                                        <td>
                                            <span class="fw-bold">{{ $user->fullname }}
                                            @if($user->invests->count() > 0) <span class="badge badge--success">Active</span>    @else
                                                <span class="badge badge--danger">Inactive</span>
                                            @endif
                                            </span>
                                            <br>
                                            <span class="small">
                                                <a href="{{ route('admin.users.detail', $user->id) }}"><span>@</span>{{ $user->username }}</a>
                                            </span>
                                        </td>


                                            @php
                                                $walletNameRaw = $user->wallet_name ?? '';
                                                $walletKey     = strtolower(trim($walletNameRaw));
                                            
                                                // Map wallet name -> badge class
                                                $badgeMap = [
                                                    'trust wallet'     => 'bg-primary text-white',   // blue
                                                    'metamask'         => 'bg-warning text-dark',    // orange
                                                    'coinbase wallet'  => 'bg-info text-dark',       // light blue
                                                    'okx'              => 'bg-dark text-white',      // black
                                                    'phantom'          => 'bg-purple text-white',    // purple (see tiny CSS below)
                                                    'rainbow'          => 'bg-success text-white',   // green
                                                    'zerion'           => 'bg-secondary text-white', // gray
                                                    'safe'             => 'bg-success text-white',   // green
                                                    'ledger live'      => 'bg-secondary text-white', // gray
                                                ];
                                            
                                                $badgeClass = $badgeMap[$walletKey] ?? 'bg-secondary text-white';
                                            @endphp
                                        
                                        <td>
                                            {{ $user->wallet }}<br>
                                            <span class="badge {{ $badgeClass }}">
                                                {{ $walletNameRaw ?: 'Unknown Wallet' }}
                                            </span>
                                        </td>
                                     

                                        <td>
                                            {{ showDateTime($user->created_at) }} <br> {{ diffForHumans($user->created_at) }}
                                        </td>


                                        <td>
                                            <span class="fw-bold">
                                                @lang('TOKEN WALLET') {{ $general->cur_sym }} {{ showAmount($user->token_balance) }}<br>
                                                @lang('ROI WALLET') {{ $general->cur_sym }} {{ showAmount($user->referral_walltet) }}
                                            </span>
                                        </td>

                                        <td>
                                            <div class="button--group">
                                                <a href="{{ route('admin.users.detail', $user->id) }}" class="btn btn-sm btn-outline--primary">
                                                    <i class="las la-desktop"></i> @lang('Details')
                                                </a>
                                                @if (request()->routeIs('admin.users.kyc.pending'))
                                                    <a href="{{ route('admin.users.kyc.details', $user->id) }}" target="_blank" class="btn btn-sm btn-outline--dark">
                                                        <i class="las la-user-check"></i>@lang('KYC Data')
                                                    </a>
                                                @endif
                                            </div>
                                        </td>

                                    </tr>
                                @empty
                                    <tr>
                                        <td class="text-muted text-center" colspan="100%">{{ __($emptyMessage) }}</td>
                                    </tr>
                                @endforelse

                            </tbody>
                        </table><!-- table end -->
                    </div>
                </div>
                @if ($users->hasPages())
                    <div class="card-footer py-4">
                        {{ paginateLinks($users) }}
                    </div>
                @endif
            </div>
        </div>


    </div>
@endsection



@push('breadcrumb-plugins')
    <x-search-form placeholder="Username / Email" />
@endpush
