<div class="col-md-12">
    <div class="dashboard-table">
        <table class="table transection__table table--responsive--xl">
            <thead>
                <tr>
                    <th>@lang('Plan')</th>
                    <th>@lang('Returns')</th>
                    <th>@lang('Received')</th>
                    <th class="text-center">@lang('Next payment')</th>
                    <th class="text-end">@lang('Action')</th>
                </tr>
            </thead>
            <tbody>
                @forelse($invests as $invest)
                    <tr>
                        <td>{{ __($invest->plan->name) }} <br> {{ showAmount($invest->amount) }}
                            {{ __($general->cur_text) }} </td>
                        <td>
                            {{ showAmount($invest->interest) }} {{ __($general->cur_text) }}
                            @lang('every') {{ $invest->time_name }}
                            <br>
                            @lang('for')
                            @if ($invest->period == '-1')
                                @lang('Lifetime')
                            @else
                                {{ $invest->period }}
                                {{ $invest->time_name }}
                            @endif
                            @if ($invest->capital_status == '1')
                                + @lang('Capital')
                            @endif
                        </td>
                        <td>
                            @if ($invest->compound_times)
                                {{ $invest->return_rec_time }} @lang('times') | {{ showAmount($invest->paid) }} {{ $general->cur_text }}
                            @else
                                {{ $invest->return_rec_time }}x{{ showAmount($invest->interest) }} = {{ showAmount($invest->paid) }} {{ __($general->cur_text) }}
                            @endif
                        </td>

                        <td scope="row" class="font-weight-bold text-center">
                            @if ($invest->status == '1')
                                <p id="counter{{ $invest->id }}" class="demo countdown"></p>

                                @php
                                    if ($invest->last_time) {
                                        $start = $invest->last_time;
                                    } else {
                                        $start = $invest->created_at;
                                    }
                                @endphp
                                <div class="progress">
                                    <div class="progress-bar progress-bar-striped bg-success" role="progressbar" style="width: {{ diffDatePercent($start, $invest->next_time) }}%" aria-valuenow="10" aria-valuemin="0" aria-valuemax="100">
                                    </div>
                                </div>
                              @elseif($invest->status == 2)
                                            <span class="badge badge--danger">@lang('Canceled')</span>
                              @else
                                <span class="badge badge--info">@lang('Completed')</span>
                             @endif
                        </td>

                        <td class="text-end">
                            <a href="{{ route('user.invest.details', encrypt($invest->id)) }}" class="btn btn--base btn--sm">
                                <i class="fa fa-desktop"></i>
                            </a>
                             @if ($invest->status == 1)
                                <button class="btn btn--base btn--sm cancelPlan" data-id="{{ $invest->id }}">
                                    <i class="fas fa-minus-circle"></i>
                                </button>
                             @endif
                             
                            @if ($invest->eligibleCapitalBack())
                                <button class="btn btn--base btn--sm manageCapital" data-id="{{ $invest->id }}">
                                    <i class="fas fa-hand-holding-usd"></i>
                                </button>
                            @endif
                        </td>

                        @php
                            $nextTime = \Carbon\Carbon::parse($invest->next_time);
                        @endphp

                    </tr>
                    @if ($nextTime > now())
                        <script>
                            createCountDown('counter<?php echo $invest->id; ?>', {{ $nextTime->diffInSeconds() }});
                        </script>
                    @endif
                @empty
                    <tr>
                        <td colspan="100%" class="text-center">{{ __($emptyMessage) }}</td>
                    </tr>
                @endforelse
            </tbody>
        </table>
    </div>
</div>

<div class="modal custom--modal fade" id="capitalModal">
    <div class="modal-dialog modal-dialog-centered modal-content-bg">
        <div class="modal-content">
            <div class="modal-header">
                <strong class="modal-title text-white" id="ModalLabel">
                    @lang('Manage Invest Capital')
                </strong>
                <span class="close" class="text--base" data-bs-dismiss="modal">
                    <i class="las la-times"></i>
                </span>
            </div>
            <form action="{{ route('user.invest.capital.manage') }}" method="post">
                @csrf
                <div class="modal-body">
                    <input type="hidden" name="invest_id">
                    <div class="form-group has-icon-select">
                        <label>@lang('Investment Capital')</label>
                        <select name="capital" class="form--control form-select">
                            <option value="reinvest">@lang('Reinvest')</option>
                            <option value="capital_back">@lang('Capital Back')</option>
                        </select>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="submit" class="btn btn--base btn-md w-100">@lang('Submit')</button>
                </div>
            </form>
        </div>
    </div>
</div>


<div class="modal custom--modal fade" id="cancelModal">
    <div class="modal-dialog modal-dialog-centered modal-content-bg">
        <div class="modal-content">
            <div class="modal-header">
                <strong class="modal-title text-white" id="ModalLabel">
                    @lang('Are You Sure want to Cancele the plan?')
                </strong>
                <span class="close" class="text--base" data-bs-dismiss="modal">
                    <i class="las la-times"></i>
                </span>
            </div>
            <form action="{{ route('user.invest.cancell') }}" method="post">
                @csrf
                  <input type="hidden" name="invest_id">
              
                <div class="modal-footer">
                    <button type="submit" class="btn btn--base btn-md w-100">@lang('Confirm')</button>
                </div>
            </form>
        </div>
    </div>
</div>

@push('script')
    <script>
        (function($) {
            "use strict";
            $('.manageCapital').on('click', function() {
                let modal = $('#capitalModal');
                modal.find('[name=invest_id]').val($(this).data('id'));
                modal.modal('show');
            });
            
              $('.cancelPlan').on('click', function() {
                let modal = $('#cancelModal');
                modal.find('[name=invest_id]').val($(this).data('id'));
                modal.modal('show');
            });
            
        })(jQuery);
    </script>
@endpush
