@php
    $statisticsContent = getContent('live_statistics.content', true);
     $liveElement = getContent('live_statistics.element', orderById: true);
     
       $topInvestor = \App\Models\Invest::with('user')
        ->selectRaw('SUM(amount) as totalAmount, user_id')
        ->orderBy('totalAmount', 'desc')
        ->groupBy('user_id')
        ->limit(8)
        ->get();
@endphp
<section class="investor-area section-common-bg pt-70 pb-120">
    <div class="container mb-30">
        <div class="row  justify-content-center">
            <div class="col-xl-10 col-12">
                <div class="row">
                    <div class="col-xl-9 col-lg-9 col-md-8">
                        <div class="section_title_wrapper mb-50">
                            <h2 class="section-title">
                                {{ __(@$statisticsContent->data_values->heading) }}
                            </h2>
                   
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <div class="container">
        <div class="row gy-4 justify-content-center">
            
                <div class="col-md-3">
                    <div class="investor-card border-radius--5">
                        <span class="investor-card__number text--base">{{ __(@$statisticsContent->data_values->day) }}</span>
                        <h5 class="investor-card__name">Day</h5>
                    </div>
                </div>
                
                <div class="col-md-3">
                    <div class="investor-card border-radius--5">
                        <span class="investor-card__number text--base">{{ __(@$statisticsContent->data_values->users) }}</span>
                        <h5 class="investor-card__name">Users</h5>
                        </div>
                </div>
                
                <div class="col-md-3">
                    <div class="investor-card border-radius--5">
                        <span class="investor-card__number text--base"> {{ $general->cur_sym }}{{ __(@$statisticsContent->data_values->deposits) }}</span>
                        <h5 class="investor-card__name">Deposits</h5>
                        </div>
                </div>
                
                <div class="col-md-3">
                    <div class="investor-card border-radius--5">
                        <span class="investor-card__number text--base">{{ $general->cur_sym }}{{ __(@$statisticsContent->data_values->withdrawls) }}</span>
                        <h5 class="investor-card__name">Withdrawals</h5>
                        </div>
                </div>
        
        </div>
    </div>
</section>
