@extends($activeTemplate . 'layouts.master')
@section('content')
    <div class="row justify-content-center">
        <div class="col-md-8">
            <div class="card custom--card">
                <form action="" method="post" enctype="multipart/form-data">
                    @csrf
                    <div class="card-body">
                        <div class="row">
                            <div class="col-md-12">
                                <div class="form-group mb-3 has-icon-select">
                                    <label>@lang('Wallet')</label>
                                    <select class="form-control form--control form-select" name="wallet">
                                        <option value="">@lang('Select From wallet')</option>
                                        @if (auth()->user()->interest_wallet > 0)
                                        <option value="interest_wallet">@lang('ROI WALLET') -
                                            {{ showAmount($user->interest_wallet) }} {{ $general->cur_text }}</option>
                                        @endif
                                        @if (auth()->user()->referral_walltet > 0)
                                        <option value="referral_walltet">@lang('REFERRAL WALLET') -
                                            {{ showAmount($user->referral_walltet) }} {{ $general->cur_text }}</option>
                                        @endif
                                        
                                        @if (auth()->user()->return_walltet > 0)
                                        <option value="return_walltet">@lang('TERM WALLET') -
                                            {{ showAmount($user->return_walltet) }} {{ $general->cur_text }}</option>
                                        @endif
                                    </select>
                                </div>
                       
                                <div class="form-group mb-3">
                                    <label>@lang('Amount')</label>
                                    <div class="input-group">
                                        <input type="number" step="any" autocomplete="off" name="amount"
                                            class="form-control form--control">
                                        <span class="input-group-text bg--base">{{ $general->cur_text }}</span>
                                    </div>
                                
                                </div>

                                @if (auth()->user()->ts)
                                    <div class="form-group">
                                        <label>@lang('Google Authenticator Code')</label>
                                        <input type="text" name="authenticator_code" class="form-control form--control"
                                            required>
                                    </div>
                                @endif


                            </div>
                        </div>
                        <div class="form-group mt-3">
                            <button type="submit" class="btn btn--outline-base btn-small w-100">@lang('Transfer')</button>
                        </div>
                    </div>
                </form>
            </div>
        </div>
    </div>
@endsection


@push('script')
    <script>
       
    </script>
@endpush
