@extends($activeTemplate . 'layouts.master')
@section('content')
    <div class="row justify-content-center">
        <div class="col-md-12">
            <!-- 
            @if ($user->deposit_wallet <= 0 && $user->interest_wallet <= 0)
                <div class="alert border border--danger" role="alert">
                    <div class="alert__icon d-flex align-items-center text--danger">
                        <i class="fas fa-exclamation-triangle"></i>
                    </div>
                    <p class="alert__message">
                        <span class="fw-bold">@lang('Empty Balance')</span><br>
                        <small>
                            <i>@lang('Your balance is empty. Please make')
                                <a href="{{ route('user.deposit.index') }}" class="text--base">
                                    @lang('deposit')
                                </a>
                                @lang('for your next investment.')
                            </i>
                        </small>
                    </p>
                </div>
            @endif
            -->

            @if ($user->deposits->where('status', 1)->count() == 1 && !$user->invests->count())
                <div class="alert border border--success" role="alert">
                    <div class="alert__icon d-flex align-items-center text--success">
                        <i class="fas fa-check"></i>
                    </div>
                    <p class="alert__message">
                        <span class="fw-bold">@lang('First Deposit')</span><br>
                        <small>
                            <i>
                                <span class="fw-bold">@lang('Congratulations!')</span>
                                @lang('You\'ve made your first deposit successfully. Go to')
                                <a href="{{ route('plan') }}" class="text--base">
                                    @lang('investment plan')
                                </a>
                                @lang('page and invest now')
                            </i>
                        </small>
                    </p>
                </div>
            @endif

            @if ($pendingWithdrawals)
                <div class="alert border border--primary" role="alert">
                    <div class="alert__icon d-flex align-items-center text--primary"><i class="fas fa-spinner"></i>
                    </div>
                    <p class="alert__message">
                        <span class="fw-bold">@lang('Withdrawal Pending')</span><br>
                        <small><i>@lang('Total') {{ showAmount($pendingWithdrawals) }} {{ __($general->cur_text) }}
                                @lang('withdrawal request is pending. Please wait for admin approval. The amount will send to the account which you\'ve provided. See') <a href="{{ route('user.withdraw.history') }}"
                                    class="text--base">@lang('withdrawal history')</a></i></small>
                    </p>
                </div>
            @endif

            @if ($pendingDeposits)
                <div class="alert border border--primary" role="alert">
                    <div class="alert__icon d-flex align-items-center text--primary"><i class="fas fa-spinner"></i>
                    </div>
                    <p class="alert__message">
                        <span class="fw-bold">@lang('Deposit Pending')</span><br>
                        <small><i>@lang('Total') {{ showAmount($pendingDeposits) }} {{ __($general->cur_text) }}
                                @lang('deposit request is pending. Please wait for admin approval. See') <a href="{{ route('user.deposit.history') }}"
                                    class="text--base">@lang('deposit history')</a></i></small>
                    </p>
                </div>
            @endif

            <!-- 
            @if (!$user->ts)
                <div class="alert border border--warning" role="alert">
                    <div class="alert__icon d-flex align-items-center text--warning">
                        <i class="fas fa-user-lock"></i>
                    </div>
                    <p class="alert__message">
                        <span class="fw-bold">@lang('2FA Authentication')</span><br>
                        <small><i>@lang('To keep safe your account, Please enable') <a href="{{ route('user.twofactor') }}"
                                    class="text--base">@lang('2FA')</a> @lang('security').</i>
                            @lang('It will make secure your account and balance.')</small>
                    </p>
                </div>
            @endif

            @if ($isHoliday)
                <div class="alert border border--info" role="alert">
                    <div class="alert__icon d-flex align-items-center text--info">
                        <i class="fas fa-toggle-off"></i>
                    </div>
                    <p class="alert__message">
                        <span class="fw-bold">@lang('Holiday')</span><br>
                        <small><i>@lang('Today is holiday on this system. You\'ll not get any interest today from this system. Also you\'re unable to make withdrawal request today.') <br> @lang('The next working day is coming after') <span id="counter"
                                    class="fw-bold text--primary fs--15px"></span></i></small>
                    </p>
                </div>
            @endif

            @if ($user->kv == 0)
                <div class="alert border border--info" role="alert">
                    <div class="alert__icon d-flex align-items-center text--info"><i class="fas fa-file-signature"></i>
                    </div>
                    <p class="alert__message">
                        <span class="fw-bold">@lang('KYC Verification Required')</span><br>
                        <small><i>@lang('Please submit the required KYC information to verify yourself. Otherwise, you couldn\'t make any withdrawal requests to the system.') <a href="{{ route('user.kyc.form') }}"
                                    class="text--base">@lang('Click here')</a> @lang('to submit KYC information').</i></small>
                    </p>
                </div>
            @elseif($user->kv == 2)
                <div class="alert border border--warning" role="alert">
                    <div class="alert__icon d-flex align-items-center text--warning"><i class="fas fa-user-check"></i></div>
                    <p class="alert__message">
                        <span class="fw-bold">@lang('KYC Verification Pending')</span><br>
                        <small><i>@lang('Your submitted KYC information is pending for admin approval. Please wait till that.') <a href="{{ route('user.kyc.data') }}"
                                    class="text--base">@lang('Click here')</a> @lang('to see your submitted information')</i></small>
                    </p>
                </div>
            @endif
            -->
        </div>
    </div>
    
    
    
    <div class="row justify-content-center">
        <div class="card custom--card">
            <div class="card-body">
                <div class="form-group">
                    <label>@lang('Referral Link')</label>
                    <div class="input-group">
                        <input type="text" name="text" class="form-control form--control referralURL"
                            value="{{ route('home') }}?reference={{ auth()->user()->username }}" readonly>
                        <button class="input-group-text bg--base copytext copyBoard" id="copyBoard">
                            <i class="fa fa-copy"></i>
                        </button>
                    </div>
                </div>
            </div>
        </div>
    </div>
    

    <div class="row gy-4 pt-60">
        
        <div class="col-xxl-3 col-sm-6">
            <div class="card-item">
                <div class="card-item-body d-flex justify-content-between">
                    <div class="card-item-body-left">
                        <i class="fas fa-coins"></i>
                        <p>@lang('BALANCE WALLET')</p>
                        <h4>{{ showAmount($user->deposit_wallet) }} {{ __($general->cur_text) }}</h4>
                    </div>
                    <div class="card-item-body-right">
                        <a class="btn btn--outline-base btn--back-bg btn-dashboard"
                            href="{{ route('user.deposit.history') }}">@lang('View All')</a>
                    </div>
                </div>
            </div>
        </div>
        
        <div class="col-xxl-3 col-sm-6">
            <div class="card-item">
                <div class="card-item-body d-flex justify-content-between">
                    <div class="card-item-body-left">
                        <i class="fas fa-hand-holding-usd"></i>
                        <p>@lang('ROI WALLET ')</p>
                        <h4>{{ showAmount($user->interest_wallet) }} {{ __($general->cur_text) }}</h4>
                    </div>
                    <div class="card-item-body-right">
                        <a class="btn btn--outline-base btn-dashboard btn--back-bg"
                            href="{{ route('user.transactions') }}?remark=interest">@lang('View All')</a>
                    </div>
                </div>
            </div>
        </div>
        
        <div class="col-xxl-3 col-sm-6">
            <div class="card-item">
                <div class="card-item-body d-flex justify-content-between">
                    <div class="card-item-body-left">
                        <i class="fas fa-dollar-sign"></i>
                        <p>@lang('REFERRAL WALLET')</p>
                        <h4>{{ showAmount($user->referral_walltet) }} {{ __($general->cur_text) }}</h4>
                    </div>
                    <div class="card-item-body-right">
                        <a class="btn btn--outline-base btn-dashboard btn--back-bg"
                            href="{{ route('user.transactions') }}?remark=referral_commission">@lang('View All')</a>
                    </div>
                </div>
            </div>
        </div>
        
        <div class="col-xxl-3 col-sm-6">
            <div class="card-item">
                <div class="card-item-body d-flex justify-content-between">
                    <div class="card-item-body-left">
                        <i class="fab fa-bitcoin"></i>
                        <p>@lang('TERM WALLET')</p>
                        <h4>{{ showAmount($user->return_walltet) }} {{ __($general->cur_text) }}</h4>
                    </div>
                    <div class="card-item-body-right">
                        <a class="btn btn--outline-base btn-dashboard btn--back-bg"
                            href="{{ route('user.transactions') }}?wallet_type=return_walltet">@lang('View All')</a>
                    </div>
                </div>
            </div>
        </div>
        
        
        
        <div class="col-xxl-3 col-sm-6">
            <div class="card-item">
                <div class="card-item-body d-flex justify-content-between">
                    <div class="card-item-body-left">
                        <i class="fas fa-chart-area"></i>
                        <p>@lang('Total Investments') </p>
                        <h4>{{ showAmount($totalInvest) }} {{ __($general->cur_text) }}</h4>
                    </div>
                    <div class="card-item-body-right">
                        <a class="btn btn--outline-base btn--back-bg btn-dashboard"
                            href="{{ route('user.invest.statistics') }}">@lang('View All')</a>
                    </div>
                </div>
            </div>
        </div>
        <div class="col-xxl-3 col-sm-6">
            <div class="card-item">
                <div class="card-item-body d-flex justify-content-between">
                    <div class="card-item-body-left">
                        <i class="fas fa-file-invoice-dollar"></i>
                        <p>@lang('Total Deposits') </p>
                        <h4>{{ showAmount($user->deposits->where('status', 1)->sum('amount')) }}
                            {{ __($general->cur_text) }}
                        </h4>
                    </div>
                    <div class="card-item-body-right">
                        <a class="btn btn--outline-base btn--back-bg btn-dashboard"
                            href="{{ route('user.deposit.history') }}">@lang('View All')</a>
                    </div>
                </div>
            </div>
        </div>
        <div class="col-xxl-3 col-sm-6 ">
            <div class="card-item">
                <div class="card-item-body d-flex justify-content-between">
                    <div class="card-item-body-left">
                        <i class="las la-cloud-download-alt"></i>
                        <p>@lang('Total Withdrawals')</p>

                        <h4>{{ showAmount($user->withdrawals->where('status', 1)->sum('amount')) }}
                            {{ __($general->cur_text) }}</h4>
                    </div>
                    <div class="card-item-body-right">
                        <a class="btn btn--outline-base btn--back-bg btn-dashboard"
                            href="{{ route('user.withdraw.history') }}">@lang('View All')</a>
                    </div>
                </div>
            </div>
        </div>
        <div class="col-xxl-3 col-sm-6">
            <div class="card-item">
                <div class="card-item-body d-flex justify-content-between">
                    <div class="card-item-body-left">
                        <i class="fas fa-wallet"></i>
                        <p>@lang('Total Referral Earnings')</p>
                        <h4>{{ showAmount($referral_earnings) }} {{ __($general->cur_text) }}</h4>
                    </div>
                    <div class="card-item-body-right">
                        <a class="btn btn--outline-base btn--back-bg btn-dashboard"
                            href="{{ route('user.transactions') }}?remark=referral_commission">@lang('View All')</a>
                    </div>
                </div>
            </div>
        </div>

    </div>
    
    
      

    <div class="dashboard-table pt-60">
        <h2 class="dashboard-table-title mb-30">@lang('My Transaction')</h2>
        <table class="table transection__table table--responsive--xl">
            <thead>
                <tr>
                    <th>@lang('Date')</th>
                    <th>@lang('Transaction ID')</th>
                    <th>@lang('Amount')</th>
                    <th>@lang('Wallet')</th>
                    <th>@lang('Details')</th>
                    <th>@lang('Balance')</th>
                </tr>
            </thead>
            <tbody>
                @forelse($transactions as $trx)
                    <tr>
                        <td>
                            {{ showDatetime($trx->created_at, 'd/m/Y') }}
                        </td>
                        <td><span class="text-primary">{{ $trx->trx }}</span></td>

                        <td>
                            @if ($trx->trx_type == '+')
                                <span class="text-success">+
                                    {{ $general->cur_sym }}{{ showAmount($trx->amount) }}</span>
                            @else
                                <span class="text-danger">-
                                    {{ $general->cur_sym }}{{ showAmount($trx->amount) }}</span>
                            @endif
                        </td>
                        <td>
                            @if ($trx->wallet_type == 'deposit_wallet')
                                <span class="badge badge--info">@lang('BALANCE WALLET')</span>
                            @elseif ($trx->wallet_type == 'referral_walltet')
                                 <span class="badge bg--success">@lang('REFERRAL WALLET')</span>
                            @elseif ($trx->wallet_type == 'return_walltet')
                                 <span class="badge bg--danger">@lang('TERM WALLET')</span>
                            @else
                                <span class="badge badge--primary">@lang('ROI Wallet')</span>
                            @endif
                        </td>
                        <td>{{ $trx->details }}</td>
                        <td><span>
                                {{ $general->cur_sym }}{{ showAmount($trx->post_balance) }}</span>
                        </td>
                    </tr>
                @empty
                    <tr>
                        <td colspan="100%" class="text-center">
                            @lang('No Transaction Found')
                        </td>
                    </tr>
                @endforelse
            </tbody>
        </table>
    </div>

    </div><!-- row end -->
@endsection


@push('script')
    <script>
        (function($) {
            "use strict"
            $('.copyBoard').click(function() {
                var copyText = document.getElementsByClassName("referralURL");
                copyText = copyText[0];
                copyText.select();
                copyText.setSelectionRange(0, 99999);

                /*For mobile devices*/
                document.execCommand("copy");
                copyText.blur();
                this.classList.add('copied');
                setTimeout(() => this.classList.remove('copied'), 1500);
            });
        })(jQuery);
    </script>
@endpush
