@extends($activeTemplate . 'layouts.master')
@section('content')
    <div class="row">
        <div class="col-lg-4 mb-30">
            <div class="card custom--card">
                <div class="card-body">
                    <h4 class="mb-2">{{ $user->fullname }}</h4>
                    <ul class="list-group">

                        <li class="list-group-item d-flex justify-content-between align-items-center">
                            <span><i class="las la-user base--color"></i> @lang('Username')</span> <span
                                class="fw-bold">{{ $user->username }}</span>
                        </li>
                        
                        @if($user->referrer)
                        <li class="list-group-item d-flex justify-content-between align-items-center">
                            <span><i class="las la-user base--color"></i> @lang('Sponsor Name')</span> <span
                                class="fw-bold">{{ $user->referrer->username }}</span>
                        </li>
                        @endif

                        <li class="list-group-item d-flex justify-content-between align-items-center">
                            <span><i class="las la-envelope base--color"></i> @lang('Email')</span> <span
                                class="fw-bold">{{ $user->email }}</span>
                        </li>

                        <li class="list-group-item d-flex justify-content-between align-items-center">
                            <span><i class="las la-phone base--color"></i> @lang('Mobile')</span> <span
                                class="fw-bold">{{ $user->mobile }}</span>
                        </li>

                        <li class="list-group-item d-flex justify-content-between align-items-center">
                            <span><i class="las la-globe base--color"></i> @lang('Country')</span> <span
                                class="fw-bold">{{ @$user->address->country }}</span>
                        </li>

                    </ul>
                </div>
            </div>
        </div>
        <div class="col-lg-8">
            <div class="card custom--card">
                <div class="card-body">
                    <form class="register" action="" method="post">
                        @csrf
                        <div class="row">
                            
                             <div class="col-md-12 mb-3">
                                <div class="form-group">
                                    <label class="form-label">@lang('E-Mail Address')</label>
                                    <input type="email" class="form-control form--control checkUser" name="email"
                                        value="{{$user->email}}" required>
                                </div>
                            </div>
                            
                            <div class="form-group mb-3 col-sm-6">
                                <label class="form-label">@lang('First Name')</label>
                                <input type="text" class="form-control form--control" name="firstname"
                                    value="{{ $user->firstname }}" required>
                            </div>
                            <div class="form-group mb-3 col-sm-6">
                                <label class="form-label">@lang('Last Name')</label>
                                <input type="text" class="form-control form--control" name="lastname"
                                    value="{{ $user->lastname }}" required>
                            </div>
                        </div>
                        <div class="row">
                            <div class="form-group mb-3 col-sm-6">
                                <label class="form-label">@lang('Address')</label>
                                <input type="text" class="form-control form--control" name="address"
                                    value="{{ @$user->address->address }}">
                            </div>
                            <div class="form-group mb-3 col-sm-6">
                                <label class="form-label">@lang('State')</label>
                                <input type="text" class="form-control form--control" name="state"
                                    value="{{ @$user->address->state }}">
                            </div>
                        </div>
                        
                        <div class="row">
                            <div class="form-group mb-3 col-sm-6">
                                <label class="form-label">@lang('Country')</label>
                                <select name="country" class="form-control form--control">
                                    @foreach ($countries as $key => $country)
                                        <option data-mobile_code="{{ $country->dial_code }}" value="{{ $key }}">
                                            {{ __($country->country) }}</option>
                                    @endforeach
                                </select>
                            </div>
                            <div class="form-group mb-3 col-sm-6">
                                <label class="form-label">@lang('Mobile')</label>
                                    <div class="input-group ">
                                        <span class="input-group-text mobile-code bg--base">

                                        </span>
                                        <input type="hidden" name="mobile_code">
                                        <input type="hidden" name="country_code">
                                        <input type="number" name="mobile" value="{{ old('mobile') }}"
                                            class="form-control form--control checkUser" required>
                                    </div>
                            </div>
                        </div>
                        
                      


                        <div class="row">
                            <div class="form-group mb-3 col-sm-6">
                                <label class="form-label">@lang('Zip Code')</label>
                                <input type="text" class="form-control form--control" name="zip"
                                    value="{{ @$user->address->zip }}">
                            </div>

                            <div class="form-group mb-3 col-sm-6">
                                <label class="form-label">@lang('City')</label>
                                <input type="text" class="form-control form--control" name="city"
                                    value="{{ @$user->address->city }}">
                            </div>
                        </div>

                        <div class="form-group">
                            <button type="submit" class="btn btn--outline-base w-100 h-45">@lang('Submit')</button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
@endsection


@push('script')
<script>
    (function($){
    "use strict"
    
        let mobileElement = $('.mobile-code');
        $('select[name=country]').change(function(){
            mobileElement.text(`+${$('select[name=country] :selected').data('mobile_code')}`);
        });

        $('select[name=country]').val('{{@$user->country_code}}');
        let dialCode        = $('select[name=country] :selected').data('mobile_code');
        let mobileNumber    = `{{ $user->mobile }}`;
        mobileNumber        = mobileNumber.replace(dialCode,'');
        $('input[name=mobile]').val(mobileNumber);
        mobileElement.text(`+${dialCode}`);

    })(jQuery);
</script>
@endpush
