@extends($activeTemplate . 'layouts.master')
@section('content')
    <section class="pt-150 pb-150">
        <div class="row justify-content-center">
            <div class="col-md-12">
                <div class="show-filter mb-3 text-end">
                    <button type="button" class="showFilterBtn btn-sm btn btn--outline-base btn-small">
                        <i class="las la-filter"></i>
                        @lang('Filter')
                    </button>
                </div>
                <div class="card custom--card responsive-filter-card mb-4">
                    <div class="card-body">
                        <form action="">
                            <div class="d-flex flex-wrap gap-4">
                                <div class="flex-grow-1 from-group">
                                    <label>@lang('Transaction Number')</label>
                                    <input type="text" name="search" value="{{ request()->search }}"
                                        class="form-control form--control">
                                </div>
                                <div class="flex-grow-1 form-group has-icon-select">
                                    <label>@lang('Wallet Type')</label>
                                    <select name="wallet_type" class="form--control form-select">
                                        <option value="">@lang('All')</option>
                                        <option value="deposit_wallet" @selected(request()->wallet_type == 'deposit_wallet')>@lang('BALANCE WALLET')
                                        </option>
                                        <option value="interest_wallet" @selected(request()->wallet_type == 'interest_wallet')>@lang('ROI WALLET')
                                        </option>
                                            <option value="referral_walltet" @selected(request()->wallet_type == 'referral_walltet')>@lang('REFERRAL WALLET')
                                        </option>
                                            <option value="return_walltet" @selected(request()->wallet_type == 'return_walltet')>@lang('TERM WALLET')
                                        </option>
                                    </select>
                                </div>
                                <div class=" flex-grow-1 form-group has-icon-select">
                                    <label>@lang('Type')</label>
                                    <select name="trx_type" class="form--control form-select">
                                        <option value="">@lang('All')</option>
                                        <option value="+" @selected(request()->trx_type == '+')>@lang('Credits')</option>
                                        <option value="-" @selected(request()->trx_type == '-')>@lang('Debits')</option>
                                    </select>
                                </div>
                                <!--
                                <div class="flex-grow-1 form-group has-icon-select">
                                    <label>@lang('Remark')</label>
                                    <select class="form--control form-select" name="remark">
                                        <option value="">@lang('Any')</option>
                                        @foreach ($remarks as $remark)
                                            <option value="{{ $remark->remark }}" @selected(request()->remark == $remark->remark)>
                                                {{ __(keyToTitle($remark->remark)) }}</option>
                                        @endforeach
                                    </select>
                                </div>
                                 -->
                                <div class="flex-grow-1 from-group align-self-end">
                                    <button class="btn btn--outline-base btn-small filter-btn w-100"><i class="las la-filter"></i>
                                        @lang('Filter')</button>
                                </div>
                            </div>
                        </form>
                    </div>
                </div>
                <div class="dashboard-table">

                    <table class="table transection__table table--responsive--xl">
                        <thead>
                            <tr>
                                <th>@lang('Trx')</th>
                                <th>@lang('Transacted')</th>
                                <th>@lang('Amount')</th>
                                <th>@lang('Balance')</th>
                                <th>@lang('Wallet Type')</th>
                                <th>@lang('Detail')</th>
                            </tr>
                        </thead>
                        <tbody>
                            @forelse($transactions as $trx)
                                <tr>
                                    <td>
                                        <strong>{{ $trx->trx }}</strong>
                                    </td>

                                    <td>
                                        {{ showDateTime($trx->created_at) }}<br>{{ diffForHumans($trx->created_at) }}
                                    </td>

                                    <td class="budget">
                                        <span
                                            class="fw-bold @if ($trx->trx_type == '+') text--success @else text--danger @endif">
                                            {{ $trx->trx_type }} {{ showAmount($trx->amount) }} {{ $general->cur_text }}
                                        </span>
                                    </td>

                                    <td class="budget">
                                        {{ showAmount($trx->post_balance) }} {{ __($general->cur_text) }}
                                    </td>

                                    <td>
                                        @if ($trx->wallet_type == 'deposit_wallet')
                                            <span class="badge badge--info">@lang('BALANCE WALLET')</span>
                                        @elseif ($trx->wallet_type == 'referral_walltet')
                                             <span class="badge bg--success">@lang('REFERRAL WALLET')</span>
                                        @elseif ($trx->wallet_type == 'return_walltet')
                                             <span class="badge bg--danger">@lang('TERM WALLET')</span>
                                        @else
                                            <span class="badge badge--primary">@lang('ROI Wallet')</span>
                                        @endif
                                    </td>

                                    <td>{{ __($trx->details) }}</tdalance>
                                </tr>
                            @empty
                                <tr>
                                    <td class="text-muted text-center" colspan="100%">{{ __($emptyMessage) }}</td>
                                </tr>
                            @endforelse
                        </tbody>
                    </table>
                </div>
                @if ($transactions->hasPages())
                    {{ $transactions->links() }}
                @endif
            </div>
        </div>

        </div>
    </section>
@endsection

@push('style')
    <style>
        .filter-btn{
            height: 60px;
        }
    </style>
@endpush

@push('script')
    <script>
        (function($) {
            "use strict";
            $('.showFilterBtn').on('click', function() {
                $('.responsive-filter-card').slideToggle();
            });
        })(jQuery);
    </script>
@endpush
