@extends($activeTemplate . 'layouts.frontend')


@section('content')
    @php
        $banner = getContent('banner.content', true);
    @endphp



    <!--Start Carousel Slider Section-->
    <!--===================================================-->
    <div id="home" class="slider-area d-flex align-items-center">
        <div class="container">
            <div class="row align-items-center">
                
                <div class="col-lg-6 col-md-6">
                    <div class="slider-content">
                        <h1 class="wow fadeInUp" data-wow-delay=".1s">
                            TOKEN<span> MGR</span>
                        </h1>
                        <h4 class="wow fadeInUp" data-wow-delay=".3s">
                            A Smarter Way to Invest
                        </h4>
                        <p class="wow fadeInUp" data-wow-delay=".5s">
                            MEGHRON (MGR) is an Ethereum-based investment token built for long-term growth and stability. By holding MEGHRON, you’re investing in a token engineered by decentralized technology.
                        </p>
                  
                    </div>
                </div>
                <div class="col-lg-6 col-md-6">
                    <div class="slider-thumb wow fadeInUp" data-wow-delay=".6s">
                        <img src="{{ asset($activeTemplateTrue . 'images/hero/hero1.png') }}" alt="" />
                        <div class="hero-shape bounce-animate3">
                            <img src="{{ asset($activeTemplateTrue . 'images/hero/hero2.png') }}" alt="" />
                        </div>
                        <div class="hero-shape2 bounce-animate4">
                            <img style="width:100px; height:auto;" src="{{ asset($activeTemplateTrue . 'images/hero/coin.png') }}" alt="" />
                        </div>
                        <div class="hero-shape3 bounce-animate2">
                            <img src="{{ asset($activeTemplateTrue . 'images/hero/hero4.png') }}" alt="" />
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="shape">
            <img src="{{ asset($activeTemplateTrue . 'images/hero/shape.png') }}" alt="" />
        </div>
    </div>


   <div class="cg-ticker">
      <coingecko-coin-price-marquee-widget
        coin-ids="bitcoin,ethereum,binancecoin,solana,cardano,tron,polygon-ecosystem-token,chainlink,uniswap,arbitrum"
        currency="usd"
        background-color="#0b0e13"
        font-color="#e5e7eb"
        locale="en">
      </coingecko-coin-price-marquee-widget>
    </div>





    <!-- about section -->
    <div id="about" class="about-section pt-100 pb-100">
        <div class="container">
            <div class="row align-items-center gy-4">
                <div class="col-md-6 mb-5">
                           <div  class="coundoun">
                                <div class="container">
                                    <div class="row upper">
                                        <div class="col-lg-12 col-md-12">
                                            <div class="single-coundown-box">
                                                <div id="countdown">
                                                    <div class="coundown-title">
                                                        <h3>Pre-Sale Starting in</h3>
                                                        <span>Super Bounty Up to 50%</span>
                                                    </div>
                                                    <div id="tiles"></div>
                                                    <div class="labels">
                                                        <ul>
                                                            <li>Days</li>
                                                        </ul>
                                                        <ul>
                                                            <li>Hours</li>
                                                        </ul>
                                                        <ul>
                                                            <li>Mins</li>
                                                        </ul>
                                                        <ul>
                                                            <li>Sec</li>
                                                        </ul>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                        
                                    </div>
                                </div>
                            </div>
                </div>
                <div class="col-md-6">
                    <div class="about-right-side">
                        <div class="dreamit-section-title pb-20">
                            <div class="dreamit-section-sub-title">
                                <h5>EXCHANGE YOUR TOKEN</h5>
                            </div>
                            <div class="dreamit-section-main-title">
                                <h1>What is MEGHRON (MGR)?</h1>
                            </div>
                            <div class="dreamit-section-content-text">
                                <p>
                                    MEGHRON (MGR) is an Ethereum-based investment token built for long-term growth and stability. Designed with transparency and security at its core, it allows investors to participate in the expanding blockchain ecosystem with confidence.
                                </p>
                            </div>
                        </div>
                    </div>
                  
                
                </div>
            </div>
        </div>
    </div>


    <!-- service section -->

    <div id="features" class="choose-section pt-100 pb-70">
      <div class="container">
        <div class="row">
          <div class="col-lg-12">
            <div class="dreamit-section-title pb-20">
              <div class="dreamit-section-sub-title">
                <h5>REASONS TO CHOOSE MGR</h5>
              </div>
              <div class="dreamit-section-main-title">
                <h1>Why Choose Our Token?</h1>
              </div>
            </div>
          </div>
        </div>
    
        <div class="row pt-25">
          <!-- 1 -->
          <div class="col-lg-3 col-md-6">
            <div class="choose-single-box">
              <div class="choose-thumb">
                <img src="{{ asset($activeTemplateTrue . 'images/choose/one.png') }}" alt="Fast & low-fee POL transfers" />
              </div>
              <div class="choose-content">
                <h2>Fast, Low-Fee Transfers</h2>
                <p>Move MGR quickly with predictable, POL-denominated fees. Pricing in POL keeps every trade simple and consistent.</p>
                <small class="d-block text-muted mt-1">1 POL = 162 MGR</small>
              </div>
            </div>
          </div>
    
          <!-- 2 -->
          <div class="col-lg-3 col-md-6">
            <div class="choose-single-box two">
              <div class="choose-thumb">
                <img src="{{ asset($activeTemplateTrue . 'images/choose/two.png') }}" alt="Security & self-custody" />
              </div>
              <div class="choose-content">
                <h2>Security & Self-Custody</h2>
                <p>You hold the keys. Connect trusted wallets and maintain full control over your MGR—no custodial risk.</p>
              </div>
            </div>
          </div>
    
          <!-- 3 -->
          <div class="col-lg-3 col-md-6">
            <div class="choose-single-box three">
              <div class="choose-thumb">
                <img src="{{ asset($activeTemplateTrue . 'images/choose/three.png') }}" alt="Privacy & on-chain transparency" />
              </div>
              <div class="choose-content">
                <h2>Privacy & Transparency</h2>
                <p>Minimal data, maximum clarity. Activity is verifiable on-chain, helping you transact with confidence.</p>
              </div>
            </div>
          </div>
    
          <!-- 4 -->
          <div class="col-lg-3 col-md-6">
            <div class="choose-single-box four">
              <div class="choose-thumb">
                <img src="{{ asset($activeTemplateTrue . 'images/choose/four.png') }}" alt="Earning & network incentives" />
              </div>
              <div class="choose-content">
                <h2>Earn as You Grow</h2>
                <p>Boost your holdings through network incentives—team rewards and ROI wallet features are built into the ecosystem.</p>
              </div>
            </div>
          </div>
        </div>
      </div>
    </div>



   <!-- faq section -->
    <div id="faq" class="faq-section pt-100 pb-400">
      <div class="container">
        <div class="row">
          <div class="col-lg-12">
            <div class="dreamit-section-title pb-20">
              <div class="dreamit-section-sub-title">
                <h5>FAQ</h5>
              </div>
              <div class="dreamit-section-main-title">
                <h1>Frequently Asked Questions</h1>
              </div>
            </div>
          </div>
        </div>
    
        <div class="row align-items-center pt-20">
          <div class="col-lg-6 col-md-12">
            <ul class="accordion">
              <li>
                <a>What is MGR (Meghron)?</a>
                <p>
                  MGR is a utility token on the POL network powering fast, low-fee transactions,
                  community rewards, and upcoming governance utilities across the Meghron ecosystem.
                </p>
              </li>
    
              <li>
                <a>Which network and contract does MGR use?</a>
                <p>
                  MGR lives on the <strong>POL</strong> chain (EVM compatible). Always verify the
                  contract address from our official dashboard before importing it into your wallet.
                  Token has <strong>18 decimals</strong> and a total supply of <strong>1,000,000,000</strong> MGR.
                </p>
              </li>
    
              <li>
                <a>How do I buy MGR?</a>
                <p>
                  Connect a POL-compatible wallet to our dashboard and use the <em>Buy</em> flow
                  (or your preferred POL DEX when liquidity is live). Select MGR, confirm the swap,
                  and approve in your wallet. The dashboard shows synchronized live price and liquidity.
                </p>
              </li>
    
              <li>
                <a>How do I view MGR in my wallet?</a>
                <p>
                  In your wallet, choose <em>Import Token</em> and paste the verified MGR contract.
                  If fields don’t auto-fill, use <strong>Symbol: MGR</strong> and
                  <strong>Decimals: 18</strong>. Ensure your wallet is connected to the POL network/RPC.
                </p>
              </li>
    
              <li>
                <a>Are there taxes or special fees?</a>
                <p>
                  The token contract does <strong>not</strong> add a transfer tax. You only pay POL
                  network gas. Exchange or DEX fees may apply depending on the platform you use.
                </p>
              </li>
            </ul>
          </div>
    
          <div class="col-lg-6 col-md-12">
            <div class="faq-thumb">
              <img src="{{ asset($activeTemplateTrue . 'images/faq.png') }}" alt="FAQ">
            </div>
          </div>
        </div>
      </div>
    </div>


    <!-- contact section -->
    <div id="contact" class="contact-section">
        <div class="container">
            <div class="row upper12 align-items-center">
                <div class="col-lg-7 col-md-7 p-0">
                    <div class="contact_from upper10">
                        <div class="dreamit-section-title pb-20">
                            <div class="dreamit-section-sub-title">
                                <h5>Contact us</h5>
                            </div>
                        </div>
                        <form action="{{ url('/contact') }}" method="POST" id="dreamit-form" autocomplete="on" novalidate>
                            @csrf
                        
                            <div class="row">
                                <div class="col-lg-6">
                                    <div class="form_box mb-2">
                                        <input class="form-control" type="text" name="name" placeholder="Name"
                                               value="{{ old('name') }}" required>
                                        @error('name') <small class="text-danger">{{ $message }}</small> @enderror
                                    </div>
                                </div>
                        
                                <div class="col-lg-6">
                                    <div class="form_box mb-2">
                                        <input class="form-control" type="email" name="email" placeholder="Email"
                                               value="{{ old('email') }}" required>
                                        @error('email') <small class="text-danger">{{ $message }}</small> @enderror
                                    </div>
                                </div>
                        
                                <div class="col-lg-12">
                                    <div class="form_box mb-2">
                                        <input class="form-control" type="text" name="subject" placeholder="Subject"
                                               value="{{ old('subject') }}" maxlength="255" required>
                                        @error('subject') <small class="text-danger">{{ $message }}</small> @enderror
                                    </div>
                                </div>
                        
                                <div class="col-lg-12">
                                    <div class="form_box">
                                        <textarea class="form-control" name="message" id="message" cols="10" rows="5"
                                                  placeholder="Message" required>{{ old('message') }}</textarea>
                                        @error('message') <small class="text-danger">{{ $message }}</small> @enderror
                                    </div>
                                </div>
                        
                                {{-- reCAPTCHA (required by verifyCaptcha()) --}}
                                <div class="col-lg-12 mt-2">
                                    @php echo loadReCaptcha() @endphp
                                    @error('g-recaptcha-response') <small class="text-danger">{{ $message }}</small> @enderror
                                </div>
                        
                                <div class="quote_btn text_center mt-15">
                                    <button class="btn" type="submit">Send Now</button>
                                </div>
                            </div>
                        </form>

                        <div id="status"></div>
                    </div>
                </div>
                
                <div class="col-lg-5 col-md-5 p-0">
                    <div class="right-side-info">
                        <div class="dreamit-section-sub-title">
                            <h5>Visit Us</h5>
                        </div>
                        <div class="single-conpany-info-box">
                            <div class="single-info-box d-flex">
                                <div class="info-icon">
                                    <i class="flaticon-maps-and-flags"></i>
                                </div>
                                <div class="info-content">
                                    <h4>Meghron </h4>
                                    <p>
                                       The San Francisco Bay Area in Northern California
                                    </p>
                                </div>
                            </div>
                         
                            <div class="single-info-box d-flex">
                                <div class="info-icon three">
                                    <i class="flaticon-email-1"></i>
                                </div>
                                <div class="info-content">
                                    <h4>E-Mail Us</h4>
                                    <p>info@meghron.com <br />support@meghron.com</p>
                                </div>
                            </div>
                            <div class="info-socail-address pt-40">
                                <div class="info-content-inner">
                                    <h4>Be Part of our Community</h4>
                                </div>
                                <ul>
                                    <li>
                                        <a href="#"><i class="fab fa-facebook-f"></i></a>
                                    </li>
                                    <li>
                                        <a href="#"><i class="fab fa-linkedin-in"></i></a>
                                    </li>
                                    <li>
                                        <a href="#"><i class="fa-brands fa-x-twitter"></i></a>
                                    </li>
                                    <li>
                                        <a href="#"><i class="fab fa-pinterest-p"></i></a>
                                    </li>
                                </ul>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    
    <!-- ConnectWallet Project ID:  5f94c9f1ca0e63a3507327870de22bd1  -->
@endsection


@push('script-lib')


    <script src="{{ asset($activeTemplateTrue . 'js/chart.js') }}"></script>
@endpush


@push('script')


<script>
      (function () {
        // Target: 12-10-2025 10:00 PM (dd-mm-yyyy, local time)
        // Month is 0-based in JS: 0=Jan ... 9=Oct
        const targetDate = new Date(2025, 9, 12, 22, 0, 0, 0); 
    
        const tiles = document.getElementById('tiles');
        if (!tiles) return;
    
        const pad = n => (n < 10 ? '0' : '') + n;
    
        function render(msLeft) {
          // guard
          if (msLeft <= 0) {
            tiles.innerHTML = "<span>00</span><span>00</span><span>00</span><span>00</span>";
            return true; // finished
          }
    
          let s = Math.floor(msLeft / 1000);
    
          const days = Math.floor(s / 86400);  s %= 86400;
          const hrs  = Math.floor(s / 3600);   s %= 3600;
          const mins = Math.floor(s / 60);
          const secs = s % 60;
    
          tiles.innerHTML = `<span>${pad(days)}</span><span>${pad(hrs)}</span><span>${pad(mins)}</span><span>${pad(secs)}</span>`;
          return false;
        }
    
        // initial paint
        render(targetDate - new Date());
    
        const t = setInterval(() => {
          const done = render(targetDate - new Date());
          if (done) clearInterval(t);
        }, 1000);
      })();
</script>



@endpush


