@php
    $links   = getContent('policy_pages.element', false, null, true);
    $footer  = getContent('footer.content', true);
    $socials = getContent('social_icon.element', false, null, true);

    $footerText = @$footer->data_values->short_details
        ?? 'Meghron (MGR) is building simple, secure, and low-fee utility on Polygon. Join our community and get the latest updates.';
@endphp

<!--==================================================-->
<!-- START FOOTER SECTION -->
<!--===================================================-->
<div class="footer pt-100">
  <div class="container">
    <div class="row">
      <!-- Brand + About + Social -->
      <div class="col-lg-3 col-md-6">
        <div class="footer-location-box">
          <div class="footer-logo">
            <img style="width:230px;height:auto;" src="{{ asset($activeTemplateTrue . 'images/logo-dark.png') }}" alt="Meghron Footer Logo" />
          </div>
          <div class="footer-content">
            <p>{{ $footerText }}</p>
          </div>
        </div>

        <div class="footer-social-box">
          <div class="social-content">
            <h3>Follow Us</h3>
          </div>
          <div class="footer-about-social-icon pt-20">
            <ul>
              @forelse($socials as $s)
                @php
                  $url  = @$s->data_values->url ?: '#';
                  $icon = @$s->data_values->icon ?: 'fab fa-globe';
                @endphp
                <li><a href="{{ $url }}" target="_blank" rel="noopener"><i class="{{ $icon }}"></i></a></li>
              @empty
                <li><a href="#"><i class="fab fa-facebook-f"></i></a></li>
                <li><a href="#"><i class="fa-brands fa-x-twitter"></i></a></li>
                <li><a href="#"><i class="fab fa-linkedin-in"></i></a></li>
              @endforelse
            </ul>
          </div>
        </div>
      </div>

      <!-- Help Links (anchor to sections) -->
      <div class="col-lg-3 col-md-6">
        <div class="widget">
          <div class="footer-quick-link">
            <div class="footer-widget-title">
              <h3>Help Links</h3>
            </div>
            <div class="footer-quick-link-list">
              <ul>
                <li><a href="#about">What is MGR?</a></li>
                <li><a href="#features">Features</a></li>
                <li><a href="#token">Token</a></li>
                <li><a href="#roadmap">Roadmap</a></li>
                <li><a href="#faq">FAQ</a></li>
                <li><a href="#contact">Contact</a></li>
              </ul>
            </div>
          </div>
        </div>
      </div>

      <!-- Quick Links (anchor to sections) -->
      <div class="col-lg-3 col-md-6">
        <div class="widget">
          <div class="footer-quick-link-list">
            <div class="footer-widget-title">
              <h3>Quick Links</h3>
            </div>
            <div class="footer-quick-link-list">
              <ul>
                <li><a href="#home">Home</a></li>
                <li><a href="#charts">Price & Charts</a></li>
                <li><a href="#features">Why Choose MGR</a></li>
                <li><a href="#token">Buy Token</a></li>
                <li><a href="#roadmap">Milestones</a></li>
                <li><a href="#contact">Support</a></li>
              </ul>
            </div>
          </div>
        </div>
      </div>

      <!-- Newsletter -->
      <div class="col-lg-3 col-md-6 p-0">
        <div class="widget">
          <div class="footer-popular-post">
            <div class="footer-widget-title two">
              <h3>Newsletter</h3>
            </div>
            <div class="footer-content-text">
              <p>Get the latest Meghron (MGR) updates in your inbox.</p>
            </div>
            <form action="https://formspree.io/f/myyleorq" method="POST" id="dreamit-form">
              <div class="subscribe-area">
                <input class="subscribe-mail-box" type="email" name="email" placeholder="Enter your email…" required>
                <button class="subscribe-button" type="submit">Subscribe</button>
              </div>
            </form>
            <div id="status"></div>
          </div>
        </div>
      </div>
    </div>

    <!-- Bottom bar -->
    <div class="row upper11 mt-50 align-items-center">
      <div class="col-lg-6 col-md-6">
        <div class="footer-copyright-text">
          <p class="text-white">Copyright © {{ date('Y') }} Meghron (MGR). All rights reserved.</p>
        </div>
      </div>
      <div class="col-lg-6 col-md-6">
        <div class="footer-copyright-content">
          <div class="footer-sicial-address-link">
            <ul>
              @if(!empty($links) && count($links))
                @foreach($links as $item)
                  @php
                    $title = __(@$item->data_values->title ?? 'Policy');
                    $url   = @$item->data_values->url
                           ?? (@$item->data_values->link ?? '#');
                  @endphp
                  <li><a href="{{ $url }}">{{ $title }}</a></li>
                @endforeach
              @else
                <li><a href="#!">Terms & Conditions</a></li>
                <li><a href="#!">Privacy Policy</a></li>
              @endif
              <li><a href="#faq">FAQ</a></li>
            </ul>
          </div>
        </div>
      </div>
    </div>

  </div>
</div>
<!--==================================================-->
<!-- END FOOTER SECTION -->
<!--===================================================-->
