@extends($activeTemplate . 'layouts.master')

@section('content')






<div class="card bg-white border-0 rounded-3 mb-4">
    <div class="card-body p-4">
        <div class="d-flex justify-content-between align-items-center flex-wrap gap-3 pb-3">
            <h3 class="mb-0">Crypto Rankings</h3>
            
        </div>

        <div class="default-table-area style-two rankings-table">
            <div class="table-responsive">
                <table class="table align-middle border-0">
                    <thead>
                        <tr class="border-bottom">
                            <th scope="col" class="bg-transparent">Rank</th>
                            <th scope="col" class="bg-transparent">Cryptocurrency</th>
                            <th scope="col" class="text-end bg-transparent">Market Cap</th>
                            <th scope="col" class="text-end bg-transparent">Price</th>
                            <th scope="col" class="text-end bg-transparent">24h Change %</th>
                            <th scope="col" class="text-end bg-transparent">7d Change %</th>
                            <th scope="col" class="text-end bg-transparent">Value 24h</th>
                            <th scope="col" class="text-end bg-transparent">Circulating Supply</th>
                        </tr>
                    </thead>
                    <tbody>
                        <tr>
                            <td class="fw-medium">1</td>
                            <td class="text-end fw-medium ps-0">
                                <div class="d-flex">
                                    <img src="{{ asset('assets/user/images/cardano.png') }}" class="rounded-circle" style="width: 22px; height: 22px;" alt="cardano">
                                    <span class="ps-2 fw-medium">Bitcoin <span class="text-body">(BTC)</span></span>
                                </div>
                            </td>
                            <td class="text-end fw-medium">$520B</td>
                            <td class="text-end fw-medium">$27,500</td>
                            <td class="text-end fw-medium text-success">+2.3%</td>
                            <td class="text-end fw-medium text-success">+10.2%</td>
                            <td class="text-end fw-medium">$35B</td>
                            <td class="text-end fw-medium">19M BTC</td>
                        </tr>
                        <tr>
                            <td class="fw-medium">2</td>
                            <td class="text-end fw-medium ps-0">
                                <div class="d-flex">
                                    <img src="{{ asset('assets/user/images/ethereum-2.png') }}" class="rounded-circle" style="width: 22px; height: 22px;" alt="ethereum">
                                    <span class="ps-2 fw-medium">Ethereum <span class="text-body">(ETH)</span></span>
                                </div>
                            </td>
                            <td class="text-end fw-medium">$210B</td>
                            <td class="text-end fw-medium">$1,750</td>
                            <td class="text-end fw-medium text-danger">-1.2%</td>
                            <td class="text-end fw-medium text-success">+6.3%</td>
                            <td class="text-end fw-medium">$20B</td>
                            <td class="text-end fw-medium">120M ETH</td>
                        </tr>
                        <tr>
                            <td class="fw-medium">3</td>
                            <td class="text-end fw-medium ps-0">
                                <div class="d-flex">
                                    <img src="{{ asset('assets/user/images/binance-2.png') }}" class="rounded-circle" style="width: 22px; height: 22px;" alt="binance">
                                    <span class="ps-2 fw-medium">Binance <span class="text-body">(BNB)</span></span>
                                </div>
                            </td>
                            <td class="text-end fw-medium">$40B</td>
                            <td class="text-end fw-medium">$250</td>
                            <td class="text-end fw-medium text-success">+1.5%	</td>
                            <td class="text-end fw-medium text-success">+7.8%</td>
                            <td class="text-end fw-medium">$1.8B</td>
                            <td class="text-end fw-medium">160M BNB</td>
                        </tr>
                        <tr>
                            <td class="fw-medium">4</td>
                            <td class="text-end fw-medium ps-0">
                                <div class="d-flex">
                                    <img src="{{ asset('assets/user/images/tether.png') }}" class="rounded-circle" style="width: 22px; height: 22px;" alt="tether">
                                    <span class="ps-2 fw-medium">Tether <span class="text-body">(USDT)</span></span>
                                </div>
                            </td>
                            <td class="text-end fw-medium">$83B</td>
                            <td class="text-end fw-medium">$1.00</td>
                            <td class="text-end fw-medium text-success">+0.01%</td>
                            <td class="text-end fw-medium text-success">+0.02%</td>
                            <td class="text-end fw-medium">$45B</td>
                            <td class="text-end fw-medium">83B USDT</td>
                        </tr>
                        <tr>
                            <td class="fw-medium">5</td>
                            <td class="text-end fw-medium ps-0">
                                <div class="d-flex">
                                    <img src="{{ asset('assets/user/images/xrp.png') }}" class="rounded-circle" style="width: 22px; height: 22px;" alt="xrp">
                                    <span class="ps-2 fw-medium">XRP <span class="text-body">(XRP)</span></span>
                                </div>
                            </td>
                            <td class="text-end fw-medium">$25B</td>
                            <td class="text-end fw-medium">$0.50</td>
                            <td class="text-end fw-medium text-success">+0.9%</td>
                            <td class="text-end fw-medium text-danger">-8.6%</td>
                            <td class="text-end fw-medium">$2.2B</td>
                            <td class="text-end fw-medium">50B XRP</td>
                        </tr>
                        <tr>
                            <td class="fw-medium">6</td>
                            <td class="text-end fw-medium ps-0">
                                <div class="d-flex">
                                    <img src="{{ asset('assets/user/images/solana-2.png') }}" class="rounded-circle" style="width: 22px; height: 22px;" alt="solana">
                                    <span class="ps-2 fw-medium">Solana <span class="text-body">(SOL)</span></span>
                                </div>
                            </td>
                            <td class="text-end fw-medium">$12B</td>
                            <td class="text-end fw-medium">$35</td>
                            <td class="text-end fw-medium text-success">+5.8%</td>
                            <td class="text-end fw-medium text-success">+15.5%</td>
                            <td class="text-end fw-medium">$3.5B</td>
                            <td class="text-end fw-medium">400M SOL</td>
                        </tr>
                    </tbody>
                </table>
            </div>

            <div class="d-flex justify-content-center justify-content-sm-between align-items-center text-center flex-wrap gap-2 showing-wrap mt-4">
                <span class="fs-12 fw-medium">Showing 6 of 30 Results</span>

                <nav aria-label="Page navigation example">
                    <ul class="pagination mb-0 justify-content-center">
                        <li class="page-item">
                            <a class="page-link icon" href="crypto.html" aria-label="Previous">
                                <i class="material-symbols-outlined">keyboard_arrow_left</i>
                            </a>
                        </li>
                        <li class="page-item"><a class="page-link active" href="crypto.html">1</a></li>
                        <li class="page-item"><a class="page-link" href="crypto.html">2</a></li>
                        <li class="page-item"><a class="page-link" href="crypto.html">3</a></li>
                        <li class="page-item"><a class="page-link" href="crypto.html">4</a></li>
                        <li class="page-item">
                            <a class="page-link icon" href="crypto.html" aria-label="Next">
                                <i class="material-symbols-outlined">keyboard_arrow_right</i>
                            </a>
                        </li>
                    </ul>
                </nav>
            </div>
        </div>
    </div>
</div>



@endsection


@push('style')

<style>


</style>

@endpush


@push('script')

        <!-- CoinGecko Price MARKET LIST (dark) -->
        <script>
            (() => {
              // ---------- SETTINGS ----------
              const WRAP_SEL       = '.rankings-table'; // your wrapper
              const ROWS_PER_PAGE  = 6;                 // rows per page
              const TOTAL_RESULTS  = 30;                // how many coins to request
              const CACHE_KEY      = 'cg_rankings_cache_v1';
              const STALE_MS       = 60 * 60 * 1000;    // 1 hour cache TTL
              const FAILOVER_MS    = 24 * STALE_MS;     // accept up to 1-day-old cache if API fails
            
              // ---------- HELPERS ----------
              const $ = (sel, root = document) => root.querySelector(sel);
              const $$ = (sel, root = document) => Array.from(root.querySelectorAll(sel));
              const fmtUSD = v => {
                if (v == null || isNaN(v)) return '$—';
                const n = Number(v);
                if (Math.abs(n) >= 1e12) return '$' + (n/1e12).toFixed(2) + 'T';
                if (Math.abs(n) >= 1e9)  return '$' + (n/1e9 ).toFixed(2) + 'B';
                if (Math.abs(n) >= 1e6)  return '$' + (n/1e6 ).toFixed(2) + 'M';
                if (Math.abs(n) >= 1e3)  return '$' + (n/1e3 ).toFixed(0) + 'k';
                return '$' + n.toFixed(2);
              };
              const fmtPct = v => {
                if (v == null || isNaN(v)) return '—';
                const s = Number(v).toFixed(2);
                const cls = Number(v) >= 0 ? 'text-success' : 'text-danger';
                return `<span class="${cls}">${Number(v) >= 0 ? '+' : ''}${s}%</span>`;
              };
              const fromCache = () => {
                try { return JSON.parse(localStorage.getItem(CACHE_KEY) || 'null'); }
                catch { return null; }
              };
              const toCache = (coins) => {
                try { localStorage.setItem(CACHE_KEY, JSON.stringify({ at: Date.now(), coins })); }
                catch(_) {}
              };
            
              // ---------- STATE / DOM ----------
              const wrap = $(WRAP_SEL);
              if (!wrap) return; // nothing to do on pages without the table
            
              const tbody   = $('tbody', wrap);
              const showTxt = $('.showing-wrap span', wrap);
              const pager   = $('.pagination', wrap);
            
              let coins = [];
              let page  = 1;
            
              // ---------- RENDER ----------
              function renderPage() {
                const pages = Math.max(1, Math.ceil(coins.length / ROWS_PER_PAGE));
                page = Math.max(1, Math.min(page, pages));
                const start = (page - 1) * ROWS_PER_PAGE;
                const rows  = coins.slice(start, start + ROWS_PER_PAGE);
            
                tbody.innerHTML = rows.map((c, idx) => {
                  const rank = start + idx + 1;
                  const img  = c.image || '';
                  const name = c.name || '';
                  const sym  = c.symbol ? c.symbol.toUpperCase() : '';
                  const mcap = fmtUSD(c.market_cap);
                  const price= c.current_price != null ? ('$' + Number(c.current_price).toLocaleString(undefined,{minimumFractionDigits:2, maximumFractionDigits:8})) : '$—';
                  const p24  = c.price_change_percentage_24h_in_currency;
                  const p7   = c.price_change_percentage_7d_in_currency;
                  const vol  = fmtUSD(c.total_volume);
                  const circ = c.circulating_supply != null ? Number(c.circulating_supply).toLocaleString() + ' ' + sym : '—';
            
                  return `
                    <tr>
                      <td class="fw-medium">${rank}</td>
                      <td class="text-end fw-medium ps-0">
                        <div class="d-flex">
                          <img src="${img}" class="rounded-circle" style="width:22px;height:22px;" alt="${name}">
                          <span class="ps-2 fw-medium">${name} <span class="text-body">(${sym})</span></span>
                        </div>
                      </td>
                      <td class="text-end fw-medium">${mcap}</td>
                      <td class="text-end fw-medium">${price}</td>
                      <td class="text-end fw-medium">${fmtPct(p24)}</td>
                      <td class="text-end fw-medium">${fmtPct(p7)}</td>
                      <td class="text-end fw-medium">${vol}</td>
                      <td class="text-end fw-medium">${circ}</td>
                    </tr>
                  `;
                }).join('');
            
                // showing text
                if (showTxt) showTxt.textContent = `Showing ${rows.length} of ${coins.length} Results`;
            
                // (Re)build pagination UI
                if (pager) {
                  pager.innerHTML = `
                    <li class="page-item ${page===1?'disabled':''}">
                      <a class="page-link icon" href="#" data-page="${page-1}" aria-label="Previous">
                        <i class="material-symbols-outlined">keyboard_arrow_left</i>
                      </a>
                    </li>
                    ${Array.from({length: Math.max(1, Math.ceil(coins.length / ROWS_PER_PAGE))}, (_,i)=>i+1).map(num => `
                      <li class="page-item">
                        <a class="page-link ${num===page?'active':''}" href="#" data-page="${num}">${num}</a>
                      </li>
                    `).join('')}
                    <li class="page-item ${page>=Math.ceil(coins.length/ROWS_PER_PAGE)?'disabled':''}">
                      <a class="page-link icon" href="#" data-page="${page+1}" aria-label="Next">
                        <i class="material-symbols-outlined">keyboard_arrow_right</i>
                      </a>
                    </li>
                  `;
                  // wire clicks
                  $$('a.page-link', pager).forEach(a => {
                    a.addEventListener('click', e => {
                      e.preventDefault();
                      const to = Number(a.dataset.page);
                      if (!isNaN(to)) { page = to; renderPage(); }
                    });
                  });
                }
              }
            
              // ---------- DATA (with 1h cache + failover) ----------
              async function loadData() {
                const now   = Date.now();
                const cache = fromCache();
            
                // 1) Fresh cache → use it
                if (cache && (now - cache.at) < STALE_MS && Array.isArray(cache.coins) && cache.coins.length) {
                  coins = cache.coins.slice(0, TOTAL_RESULTS);
                  renderPage();
                  console.info('[CG] Using fresh cache');
                  return;
                }
            
                // 2) Try live fetch
                const url = `https://api.coingecko.com/api/v3/coins/markets?vs_currency=usd&order=market_cap_desc&per_page=${TOTAL_RESULTS}&page=1&sparkline=false&price_change_percentage=24h,7d`;
                try {
                  const res = await fetch(url, { headers: { 'accept':'application/json' } });
                  if (!res.ok) throw new Error(res.status + ' ' + res.statusText);
                  const data = await res.json();
                  if (!Array.isArray(data) || !data.length) throw new Error('Empty data');
                  coins = data;
                  toCache(coins);
                  renderPage();
                  console.info('[CG] Live data loaded, cache updated');
                  return;
                } catch (err) {
                  console.warn('[CG] Live fetch failed:', err?.message || err);
                }
            
                // 3) Fall back to older cache (up to FAILOVER_MS)
                if (cache && (now - cache.at) < FAILOVER_MS && Array.isArray(cache.coins) && cache.coins.length) {
                  coins = cache.coins.slice(0, TOTAL_RESULTS);
                  renderPage();
                  console.info('[CG] Using stale cache (API failed). Age:', Math.round((now - cache.at)/60000), 'min');
                  return;
                }
            
                // 4) No data at all → show one-line error
                tbody.innerHTML = `
                  <tr>
                    <td colspan="8" class="text-center text-danger">Failed to load market data. Please try again later.</td>
                  </tr>
                `;
                if (showTxt) showTxt.textContent = 'Showing 0 of 0';
              }
            
              // Kick off
              loadData();
            })();
        </script>


@endpush

