@extends($activeTemplate . 'layouts.master')

@section('content')




    
    
<div class="border-0 p-4 pb-0 bg-white rounded-3 mb-4 without-card">
    <div class="d-flex flex-wrap gap-2 justify-content-between mb-4">
        <div>
            <h3 class="mb-0">MGR Price Performance — Market Snapshot</h3>
        </div>
        
    </div>
    
    <div class="row gy-2 mb-3">
        
         @include($activeTemplate . 'user.partials.info_card')
    
        
    </div>

                
    <div class="row">
        <div class="col-lg-8">
           @include($activeTemplate . 'user.partials.live_chart')
        </div>

        
        <div class="col-lg-4">
              @include($activeTemplate . 'user.partials.token_purchase')
          
        </div>


        
    </div>
</div>




@include($activeTemplate . 'user.partials.fake_transaction')

 <div class="row">
        <div class="col-md-12">
            <div class="card bg-white border-0 rounded-3 mb-4">
               <div class="card-body p-4">
                    <h4 class="fs-18 mb-4">@lang('Referral Link')</h4>      
                     <div class="form-group position-relative">
                        <input type="text" class="form-control h-55 bg-body-bg border-0 text-dark rounded-pill referralURL" value="{{ route('home') }}?reference={{ auth()->user()->username }}" readonly>
                        <button type="button" class="position-absolute top-50 end-0 translate-middle-y bg-primary p-0 border-0 text-center text-white rounded-pill px-3 py-2 me-2 fw-semibold copytext copyBoard" id="copyBoard">
                            Copy
                        </button>
                    </div>
                </div>
            </div>
        </div>
</div>

@endsection


@push('style')

<style>
    @keyframes copiedPulse {
      0%   { transform: scale(1); }
      50%  { transform: scale(1.1); background-color: #28a745; } /* green flash */
      100% { transform: scale(1); }
    }
    
    button.copied {
      animation: copiedPulse 0.6s ease;
    }

</style>

@endpush


@push('script')

<script>

document.addEventListener('DOMContentLoaded', function () {
  const btn = document.getElementById('copyBoard');
  const input = document.querySelector('.referralURL');

  if (!btn || !input) return;

  btn.addEventListener('click', async function () {
    try {
      await navigator.clipboard.writeText(input.value);

      // Change text
      const oldText = btn.textContent;
      btn.textContent = 'Copied!';

      // Add animation class
      btn.classList.add('copied');

      // Reset after 2s
      setTimeout(() => {
        btn.textContent = oldText;
        btn.classList.remove('copied');
      }, 2000);

    } catch (err) {
      console.error('Copy failed', err);
    }
  });
});
</script>


@endpush

