@extends($activeTemplate . 'layouts.master')

@section('content')

<div class="d-flex justify-content-between align-items-center flex-wrap gap-2 mb-4">
    <h3 class="mb-0">My Investment (MGR TOKEN)</h3>

    <nav style="--bs-breadcrumb-divider: '>';" aria-label="breadcrumb">
        <ol class="breadcrumb align-items-center mb-0 lh-1">
            <li class="breadcrumb-item">
                <a href="{{ route('user.home') }}" class="d-flex align-items-center text-decoration-none">
                    <i class="ri-home-4-line fs-18 text-primary me-1"></i>
                    <span class="text-secondary fw-medium hover">Dashboard</span>
                </a>
            </li>
            <li class="breadcrumb-item active" aria-current="page">
                <span class="fw-medium">Token Trades</span>
            </li>
            <li class="breadcrumb-item active" aria-current="page">
                <span class="fw-medium">My Invest</span>
            </li>
        </ol>
    </nav>
</div>

<div class="card bg-white border-0 rounded-3 mb-4">
    <div class="card-body p-0">
        <div class="d-flex justify-content-between align-items-center flex-wrap gap-2 p-25">
            <form method="GET" class="position-relative table-src-form me-0" action="">
                <input type="text" name="q" value="{{ request('q') }}" class="form-control border-0" placeholder="Search by tx hash, from/to address...">
                <i class="material-symbols-outlined position-absolute top-50 start-0 translate-middle-y text-secondary">search</i>
            </form>
        </div>

        <div class="default-table-area style-two py-15 individual-asset-performance">
            <div class="table-responsive">
                <table class="table align-middle">
                    <thead>
                        <tr>
                            <th class="text-secondary">Date</th>
                            <th class="text-secondary">Tx Hash</th>
                            <th class="text-secondary">MGR Received</th>
                            <th class="text-secondary">POL Spent</th>
                            <th class="text-secondary">From</th>
                            <th class="text-secondary">To</th>
                            <th class="text-secondary text-end">Status</th>
                        </tr>
                    </thead>

                    <tbody>
                        @forelse ($invests as $inv)
                            @php
                                $tx  = $inv->trx ?? '';
                                $txShort = $tx ? substr($tx, 0, 10) . '…' . substr($tx, -6) : '-';

                                $from = $inv->from_address ?? '';
                                $fromShort = $from ? substr($from, 0, 6) . '…' . substr($from, -4) : '-';

                                $to = $inv->to_address ?? '';
                                $toShort = $to ? substr($to, 0, 6) . '…' . substr($to, -4) : '-';

                                $mgr = number_format((float)($inv->amount ?? 0), 8, '.', '');
                                $pol = isset($inv->pol_amount) ? number_format((float)$inv->pol_amount, 8, '.', '') : '-';

                                $isCompleted = (int)($inv->status ?? 0) === 1;
                            @endphp
                            <tr>
                                <td class="text-body">
                                    <div class="d-flex align-items-center" style="gap: 8px;">
                                        <img src="https://meghron.com/assets/images/logoIcon/favicon.png" style="max-width: 22px;" alt="MGR">
                                        <span class="fw-medium text-secondary fs-13">
                                            {{ $inv->created_at ? $inv->created_at->format('Y-m-d H:i') : '-' }}
                                        </span>
                                    </div>
                                </td>

                                <td class="fw-medium">
                                    @if($tx)
                                        <a href="https://polygonscan.com/tx/{{ $tx }}" target="_blank" rel="noopener" class="text-decoration-none fw-semibold text-primary">
                                            {{ $txShort }} <i class="material-symbols-outlined align-middle ms-1" style="font-size:14px;">open_in_new</i>
                                        </a>
                                    @else
                                        -
                                    @endif
                                </td>

                                <td class="fw-medium">
                                    {{ $mgr }} <span class="text-muted">MGR</span>
                                </td>

                                <td class="fw-medium">
                                    {{ $pol }} @if($pol !== '-') <span class="text-muted">POL</span> @endif
                                </td>

                                <td class="text-body">
                                    @if($from)
                                        <a href="https://polygonscan.com/address/{{ $from }}" target="_blank" rel="noopener" class="text-decoration-none">
                                            {{ $fromShort }}
                                        </a>
                                    @else
                                        -
                                    @endif
                                </td>

                                <td class="text-body">
                                    @if($to)
                                        <a href="https://polygonscan.com/address/{{ $to }}" target="_blank" rel="noopener" class="text-decoration-none">
                                            {{ $toShort }}
                                        </a>
                                    @else
                                        -
                                    @endif
                                </td>

                                <td class="text-end">
                                    @if($isCompleted)
                                        <span class="badge bg-success">Completed</span>
                                    @else
                                        <span class="badge bg-warning text-dark">Pending</span>
                                    @endif
                                </td>
                            </tr>
                        @empty
                            <tr>
                                <td colspan="7" class="text-center text-muted py-4">
                                    No purchases yet.
                                </td>
                            </tr>
                        @endforelse
                    </tbody>
                </table>
            </div>

            <div class="d-flex justify-content-center justify-content-sm-between align-items-center text-center flex-wrap gap-2 showing-wrap p-4" style="padding-top: 15px !important;">
                <span class="fs-13">
                    @if($invests->total())
                        Showing {{ $invests->firstItem() }}–{{ $invests->lastItem() }} of {{ $invests->total() }} results
                    @else
                        Showing 0 results
                    @endif
                </span>

                <nav aria-label="Page navigation example">
                    {{ $invests->onEachSide(1)->links() }}
                </nav>
            </div>
        </div>
    </div>
</div>

@endsection
