        
        <div class="col-md-4">
          <!-- MGR Overview (replaces Prices/MCap card) -->
            <div class="border-0 rounded-3 mb-4 bg-primary bg-opacity-10 p-4">
              <div class="d-flex align-items-center">
                <div class="flex-shrink-0">
                  <img src="{{ asset($activeTemplateTrue . 'images/icon.png') }}" class="rounded-circle" style="width:48px;height:48px" alt="MGR">
                </div>
                <div class="flex-grow-1 ms-2">
                  <span class="mb-1 d-block fw-medium text-secondary">
                    MEGHRON <span class="text-body fw-normal">(MGR)</span>
                  </span>
                  <div class="d-flex align-items-center">
                    <h3 class="mb-0 fs-20 fw-semibold me-1" id="miniPrice22">0.006899 POL</h3>
                
                  </div>
                </div>
              </div>
            
              <!-- optional tiny sparkline area; safe to leave empty -->
              <div id="mgrMiniSpark" style="margin:-11px 0;max-width:325px;margin:auto;"></div>
            
              <div class="d-flex justify-content-between align-items-center mt-2">
                <div>
                  <span class="fs-12 fw-medium d-block mb-1">Market Cap:</span>
                  <h4 class="fs-12 fw-semibold mb-0" id="mcapVal">$0</h4>
                </div>
                <div>
                  <span class="fs-12 fw-medium d-block mb-1">Liquidity:</span>
                  <h4 class="fs-12 fw-semibold mb-0" id="vol24hVal">$0</h4>
                </div>
              </div>
            </div>

        </div>
        
        
        <div class="col-md-4">
            <div class="border-0 rounded-3 mb-4 bg-primary-div bg-opacity-10 p-4">
                <div class="mb-3">
                    <h3 class="mb-0 text-white">ROI WALLET</h3>
                </div>
                <div class="d-flex align-items-center">
                    <div class="flex-shrink-0">
                        <img src="{{ asset('assets/user/images/polygon.png') }}" style="width: 41px;" alt="balance">
                    </div>
                    <div class="flex-grow-1 ms-2">
                        <span class="mb-1 d-block fw-medium text-white">Team (Commission + Reward)</span>
                        <div class="d-flex">
                            <h3 class="mb-0 fs-20 fw-semibold me-1 text-white">{{ number_format(auth()->user()->referral_walltet) }} MGR</h3>
                          
                        </div>
                    </div>
                </div>
               
               
      
            </div>
        </div>
        

        <div class="col-md-4">
            <div class="card bg-primary p-4 border-0 position-relative z-1">
                <div class="mb-3">
                    <h3 class="mb-0 text-white">Portfolio</h3>
                </div>
                <div class="d-flex align-items-center">
                    <div class="flex-shrink-0">
                        <img src="{{ asset('assets/user/images/trust-wallet.png') }}" style="width: 41px;" alt="balance">
                    </div>
                    <div class="flex-grow-1 ms-2">
                        <span class="mb-1 d-block fw-medium text-white">MY WALLET</span>
                        <div class="d-flex">
                            <h3 class="mb-0 fs-20 fw-semibold me-1 text-white">{{ number_format(auth()->user()->token_balance) }} MGR</h3>
                            <!--
                            <i class="material-symbols-outlined fs-16 position-relative top-3 text-success">trending_up</i>
                            <span class="text-success">+2.3%</span>   
                             -->
                        </div>
                    </div>
                </div>
               
               
      
            </div>
        </div>
        
        
@push('script')
@php($g = gs())
<script>
(() => {
  // ------- Elements -------
  const $mcap = document.getElementById('mcapVal');
  const $liq  = document.getElementById('vol24hVal');
  const $mini = document.getElementById('miniPrice2');

  // ------- Initial server values (as strings, no precision loss) -------
  let MARKET_CAP_STR = @json((string) ($g->market_cap ?? '0'));
  let LIQ_STR        = @json((string) ($g->liquidity  ?? '0'));

  // Endpoint that returns: market_cap, liquidity, mgr_amount, fake_trns, min_trade, max_trade
  const MARKET_URL = @json(route('user.mgr.market'));

  // Abbreviated USD formatter that works on DECIMAL strings
  function usdAbbrFromStr(s){
    s = String(s ?? '0').replace(/[,\s]/g,'');
    const neg = s.startsWith('-') ? '-' : '';
    if (neg) s = s.slice(1);
    const [iRaw, f='0'] = s.split('.');
    const i = (iRaw || '0').replace(/^0+/, '') || '0';
    const len = i.length;
    const mk = (k, suf) => {
      if (len <= k) return null;
      const head = i.slice(0, len - k);
      const tail = i.slice(len - k, len - k + 2);
      return '$' + (neg?'-':'') + head + (tail?'.'+tail:'') + suf;
    };
    const num = Number((neg?'-':'') + (i || '0') + (f ? '.'+f : '0'));
    return mk(12,'T') || mk(9,'B') || mk(6,'M') || mk(3,'k') || ('$' + (isFinite(num) ? num.toFixed(2) : '0.00'));
  }

  function paintUSD(){
    if ($mcap) $mcap.textContent = usdAbbrFromStr(MARKET_CAP_STR);
    if ($liq)  $liq.textContent  = usdAbbrFromStr(LIQ_STR);
  }

  // Initial paint from Blade-injected values
  paintUSD();

  // ------- Live refresh from server (no reload) -------
  async function refreshMarket(){
    try{
      const res = await fetch(MARKET_URL, { cache: 'no-store' });
      const j = await res.json();
      if (typeof j.market_cap === 'string') MARKET_CAP_STR = j.market_cap;
      if (typeof j.liquidity  === 'string') LIQ_STR        = j.liquidity;
      paintUSD();
    }catch(e){
      // silent fail is OK
    }
  }
  // First pull + periodic
  refreshMarket();
  setInterval(refreshMarket, 30000);

  // ------- Live price from chart (POL per 1 MGR) -------
  const setMini = (pol) => {
    if (!$mini) return;
    if (typeof pol === 'number' && isFinite(pol)) {
      $mini.textContent = pol.toFixed(6) + ' POL';
    }
  };

  // Prefer the bus (instant + delivers the latest immediately)
  if (window.MGR_BUS?.subscribe) {
    window.MGR_BUS.subscribe(({ pricePol }) => setMini(pricePol));
    const last = window.MGR_BUS.last?.();
    if (last && typeof last.pricePol === 'number') setMini(last.pricePol);
  }

  // Back-compat fallbacks
  window.addEventListener('mgr:metrics', e => {
    const p = e?.detail?.pricePol;
    if (isFinite(p)) setMini(p);
  });

  // Poll fallback: read from global or chart header if needed
  setInterval(() => {
    const d = window.MGR_DATA;
    if (d && isFinite(d.pricePol)) { setMini(d.pricePol); return; }
    const t = document.getElementById('mgrPrice')?.textContent || ''; // e.g. "0.006173 POL"
    const m = t.match(/([\d.]+)/);
    if (m) setMini(parseFloat(m[1]));
  }, 1000);
})();
</script>
@endpush


        
        
        
   