
<div class="card p-0 border-0 rounded-3 mb-4 exchange-for-dark" style="background-color: #F3E8FF;">
  <div class="d-flex flex-wrap gap-2 justify-content-between align-items-center mb-4 p-3 px-4" style="border-bottom: 1px solid #D5D9E2;">
    <div><h3 class="mb-0">Buy Meghron (MGR)</h3></div>
    <button class="p-0 border-0 bg-transparent position-relative top-3" type="button" id="mgrResetBtn">
      <span class="material-symbols-outlined">replay</span>
    </button>
  </div>

  <form class="p-4 pt-0" id="mgrBuyForm">
    <!-- PAY WITH -->
    <div class="mb-30">
      <div class="d-flex justify-content-between align-items-center mb-3">
        <span>PAY WITH</span>
      </div>

      <div class="dropdown action-opt mb-3">
        <button id="mgrCryptoBtn" class="btn bg-transparent p-0 d-flex justify-content-between align-items-center w-100" type="button" data-bs-toggle="dropdown" aria-expanded="false">
          <div class="d-flex align-items-center">
            <img id="mgrCryptoIcon" src="{{ asset('assets/user/images/polygon.png') }}" style="width: 42px;" alt="polygon">
            <span id="mgrCryptoLabel" class="fs-14 fw-semibold text-secondary ms-1">POLYGON (POL)</span>
          </div>
          <i data-feather="chevron-down" style="stroke: #3A4252;"></i>
        </button>

        <ul class="dropdown-menu dropdown-menu-end bg-white border box-shadow w-100">
          <li>
            <a class="dropdown-item text-secondary mgr-coin-option"
               data-id="polygon" data-symbol="POL"
               data-name="POLYGON (POL)"
               data-icon="{{ asset('assets/user/images/polygon.png') }}" href="javascript:void(0);">
              <img src="{{ asset('assets/user/images/polygon.png') }}" style="width: 24px;" alt="polygon">
              <span class="ms-1">Polygon (POL)</span>
            </a>
          </li>
        </ul>
      </div>

      <div class="small text-muted">You will spend: ≈ <b id="mgrCryptoNeed">0.000000 POL</b></div>
    </div>

    <!-- AMOUNT in POL -->
    <div class="mb-30">
      <div class="d-flex justify-content-between align-items-center mb-3">
        <span>AMOUNT (POL)</span>
        <span id="mgrRateLine" class="text-muted small">1 POL = 162 MGR</span>
      </div>

      <div class="position-relative z-1">
        <input type="text" id="mgrUsdInput" class="form-control h-55 bg-white border-0" placeholder="Enter POL amount">
        <span class="fs-14 position-absolute top-50 end-0 translate-middle-y pe-3" id="mgrUsdEcho">0.000000 POL</span>
      </div>

      <div class="mt-2 small text-muted">You will get: <b id="mgrWillGet">0</b> MGR</div>
    </div>

  
    <button type="submit" id="mgrBuyBtn" class="btn btn-primary py-2 px-4 w-100">
      <span class="d-inline-block py-1">Buy Token</span>
    </button>
     

    <button type="button" id="mgrSellBtn" class="btn btn-danger py-2 px-4 text-white w-100 mt-2">
      <span class="d-inline-block py-1">Sell Token</span>
    </button>
  </form>
</div>


@push('script')
<script>
/**
 * MGR Buy Form — MetaMask Only
 * ---------------------------------------------------------
 * What this script does:
 * 1) Forces MetaMask as the only wallet provider:
 *    - If multiple wallets inject window.ethereum, we pick the one with isMetaMask === true.
 *    - If MetaMask isn’t present: 
 *        • Desktop: disable form + show "Install MetaMask" link. 
 *        • Mobile: show “Open in MetaMask” button that reopens the page in the MetaMask app browser.
 * 2) Ensures Polygon network (137) and sends the presale transaction.
 * 3) Pulls live rate (MGR per POL) from your backend & updates UI.
 * 4) Prevents page refresh by using e.preventDefault() and attaching handlers only after provider gating succeeds.
 *
 * Notes:
 * - No MetaMask SDK is required. We use window.ethereum directly.
 * - If you modify element IDs, update the selectors below.
 */

(function () {
  // ==============================
  // 0) CONSTANTS & ELEMENTS
  // ==============================
  const MARKET_URL       = @json(route('user.mgr.market')); // returns mgr_amount, min_trade, max_trade, etc.

  const POLYGON_CHAIN_ID = 137; // Polygon mainnet
  const PRESALE_ADDRESS  = '0xb1a6Ba43AFE9bedC1760ecD5ccD58B97FEAF23D4';
  const TREASURY_ADDRESS = '0x071e497CFd574350eab7F9E4E9c308f59f11b691';
  const TOKEN_ADDRESS    = '0x6d9249010ecAf6F0014e67EE79702A714D64A1f3';
  const TOKEN_SYMBOL     = 'MGR';
  const TOKEN_DECIMALS   = 18;
  const TOKEN_IMAGE      = 'https://meghron.com/assets/images/logoIcon/favicon.png';

  let MGR_PER_POL = 162;   // fallback until fetched
  let MIN_TRADE   = 0;
  let MAX_TRADE   = Infinity;

  const $form       = document.getElementById('mgrBuyForm');
  const $polInput   = document.getElementById('mgrUsdInput');
  const $polEcho    = document.getElementById('mgrUsdEcho');
  const $willGet    = document.getElementById('mgrWillGet');
  const $cryptoNeed = document.getElementById('mgrCryptoNeed');
  const $rateLine   = document.getElementById('mgrRateLine');
  const $resetBtn   = document.getElementById('mgrResetBtn');
  const $sellBtn    = document.getElementById('mgrSellBtn');

  if (!$form || !$polInput) return; // nothing to do

  // ==============================
  // 1) UTILITIES
  // ==============================
  const isMobile = /Android|iPhone|iPad|iPod/i.test(navigator.userAgent);

  function notifyOrAlert(type, msg) {
    if (typeof notify === 'function') return notify(type, msg);
    alert(msg.replace(/<br>/g, '\n'));
  }

  function openInMetaMaskMobile() {
    // Opens current page inside MetaMask mobile in-app browser
    const dappUrl = location.href.replace(/^https?:\/\//, '');
    location.href = 'https://metamask.app.link/dapp/' + dappUrl;
  }

  function disableBuyUI(reason) {
    try {
      $form.querySelectorAll('input,button,select').forEach(el => el.disabled = true);
    } catch {}
    notifyOrAlert('error', reason);
  }

  function cleanNumber(str) {
    if (typeof str !== 'string') return 0;
    const n = str.replace(/[^\d.,]/g, '').replace(',', '.');
    const v = parseFloat(n);
    return isNaN(v) ? 0 : v;
  }

  function fmtPOL(n) {
    return (n || 0).toLocaleString(undefined, { minimumFractionDigits: 6, maximumFractionDigits: 6 }) + ' POL';
  }

  function fmtInt(n) {
    return (n || 0).toLocaleString(undefined, { maximumFractionDigits: 0 });
  }

  function toWeiBigInt(amount) {
    const s = String(amount ?? '');
    if (!/^\d+(\.\d+)?$/.test(s)) {
      const num = Number(amount || 0);
      return BigInt(Math.round(num * 1e6)) * 10n ** 12n;
    }
    const [i, fRaw = ''] = s.split('.');
    const f = (fRaw + '000000000000000000').slice(0, 18);
    return BigInt(i) * 10n ** 18n + BigInt(f);
  }

  async function ensurePolygon(ethereum) {
    const chainIdHex = await ethereum.request({ method: 'eth_chainId' });
    const current = parseInt(chainIdHex, 16);
    if (current === POLYGON_CHAIN_ID) return true;
    try {
      await ethereum.request({ method: 'wallet_switchEthereumChain', params: [{ chainId: '0x89' }] });
      return true;
    } catch (e) {
      if (e && e.code === 4902) {
        try {
          await ethereum.request({
            method: 'wallet_addEthereumChain',
            params: [{
              chainId: '0x89',
              chainName: 'Polygon Mainnet',
              nativeCurrency: { name: 'POL', symbol: 'POL', decimals: 18 },
              rpcUrls: ['https://polygon-rpc.com'],
              blockExplorerUrls: ['https://polygonscan.com']
            }]
          });
          return true;
        } catch { return false; }
      }
      return false;
    }
  }

  async function tryAddTokenToWallet(ethereum) {
    if (!ethereum?.request) return false;
    try {
      const added = await ethereum.request({
        method: 'wallet_watchAsset',
        params: {
          type: 'ERC20',
          options: {
            address: TOKEN_ADDRESS,
            symbol: TOKEN_SYMBOL,
            decimals: TOKEN_DECIMALS,
            image: TOKEN_IMAGE
          }
        }
      });
      return !!added;
    } catch { return false; }
  }

  async function postPurchase(txHash, from, polAmount, mgrAmount, toAddress) {
    const csrf = document.querySelector('meta[name="csrf-token"]')?.getAttribute('content');
    const url  = "{{ route('user.mgr.purchases.store') }}";
    const res = await fetch(url, {
      method: 'POST',
      headers: {
        'Content-Type':'application/json',
        'Accept':'application/json',
        'X-CSRF-TOKEN': csrf
      },
      body: JSON.stringify({
        tx_hash: txHash,
        from_address: from,
        pol_amount: polAmount,
        mgr_amount: mgrAmount,
        to_address: toAddress || TREASURY_ADDRESS
      })
    });
    try { return await res.json(); } catch { return { ok: res.ok }; }
  }

  // ==============================
  // 2) FORCE METAMASK ONLY (DESKTOP & MOBILE)
  // ==============================
  async function forceMetaMask() {
    let mm = null;

    // If multiple providers injected, pick the MetaMask one
    const eth = window.ethereum;
    if (eth?.providers?.length) {
      mm = eth.providers.find(p => p && p.isMetaMask) || null;
    } else if (eth?.isMetaMask) {
      mm = eth;
    }

    if (mm) {
      // Make MetaMask the default provider for all subsequent calls
      try {
        window.ethereum = mm;
        if (window.web3?.currentProvider) {
          window.web3.currentProvider = mm;
        }
      } catch (_) {}
      return mm;
    }

    // MetaMask not detected or not the active provider
    if (isMobile) {
      // Show "Open in MetaMask" button above the form
      const btn = document.createElement('button');
      btn.className = 'btn btn-primary w-100 mb-3';
      btn.textContent = 'Open in MetaMask';
      btn.onclick = openInMetaMaskMobile;
      $form?.parentElement?.insertBefore(btn, $form);
      // Keep form present but disabled to avoid confusion
      disableBuyUI('Please open this page in the MetaMask app to continue.');
    } else {
      disableBuyUI('MetaMask not detected as the active wallet. Please install/enable MetaMask (and disable other wallet extensions for this site), then refresh.');
      const dl = document.createElement('a');
      dl.href = 'https://metamask.io/download/';
      dl.target = '_blank';
      dl.rel   = 'noopener';
      dl.className = 'btn btn-outline-primary mt-2';
      dl.textContent = 'Install MetaMask';
      $form?.parentElement?.appendChild(dl);
    }
    return null;
  }

  // Run the gating first (and STOP the script if MetaMask is not present)
  let metamaskProvider = null;
  (async function initWalletGate() {
    metamaskProvider = await forceMetaMask();
    if (!metamaskProvider) return; // stop: no MetaMask => form stays disabled, no handlers attached

    // With MetaMask ensured, proceed to attach handlers and fetch rate.
    attachUIHandlers();
    await pullMarket();
    setInterval(pullMarket, 30000);
  })();

  // ==============================
  // 3) UI & RATE
  // ==============================
  function refresh() {
    const pol = cleanNumber($polInput.value);
    $polEcho.textContent    = fmtPOL(pol);
    $cryptoNeed.textContent = fmtPOL(pol);
    $rateLine.textContent   = `1 POL = ${MGR_PER_POL} MGR`;
    const mgr = pol * MGR_PER_POL;
    $willGet.textContent = fmtInt(mgr);
  }

  async function pullMarket() {
    try {
      const res = await fetch(MARKET_URL, { cache: 'no-store' });
      const j   = await res.json();

      const newRate = Number(j.mgr_amount);
      if (newRate > 0 && isFinite(newRate)) MGR_PER_POL = newRate;

      const min = Number(j.min_trade);
      const max = Number(j.max_trade);
      MIN_TRADE = isFinite(min) && min >= 0 ? min : 0;
      MAX_TRADE = isFinite(max) && max > 0 ? max : Infinity;

      refresh();
    } catch {
      refresh(); // keep fallback
    }
  }

  function attachUIHandlers() {
    // Inputs
    $polInput.addEventListener('input', refresh);
    $resetBtn?.addEventListener('click', (e) => { e.preventDefault(); $polInput.value = ''; refresh(); });

    $sellBtn?.addEventListener('click', () => {
      notifyOrAlert('error', 'We are now presale the token. After listing, you can sell.');
    });

    // Submit (BUY) — MetaMask only
    $form.addEventListener('submit', async (e) => {
      e.preventDefault();
      refresh();

      const pol = cleanNumber($polInput.value);
      if (!pol || pol <= 0) {
        return alert('Enter a valid POL amount');
      }
      if (pol < MIN_TRADE) return alert(`Minimum trade is ${fmtPOL(MIN_TRADE)}.`);
      if (pol > MAX_TRADE) return alert(`Maximum trade is ${fmtPOL(MAX_TRADE)}.`);

      try {
        const accounts = await metamaskProvider.request({ method: 'eth_requestAccounts' });
        if (!accounts?.length) { alert('MetaMask connection is required.'); return; }

        const ok = await ensurePolygon(metamaskProvider);
        if (!ok) { alert('Please switch to Polygon network in MetaMask to continue.'); return; }

        const valueWei = toWeiBigInt(pol);
        // buy() -> 0xa6f2ae3a
        const data = '0xa6f2ae3a';

        const txHash = await metamaskProvider.request({
          method: 'eth_sendTransaction',
          params: [{ from: accounts[0], to: PRESALE_ADDRESS, value: '0x' + valueWei.toString(16), data }]
        });

        await tryAddTokenToWallet(metamaskProvider);

        const mgr = pol * MGR_PER_POL;
        try { await postPurchase(txHash, accounts[0], pol, mgr, TREASURY_ADDRESS); } catch {}

        notifyOrAlert('success', `Token Purchase sent! <br>
          TX: <a href="https://polygonscan.com/tx/${txHash}" target="_blank" rel="noopener">
          ${txHash.slice(0,10)}…${txHash.slice(-6)}</a><br>
          Buying ~${mgr.toFixed(0)} MGR for ${pol.toFixed(6)} POL.`);

        $form.reset();
        $polInput.value = '';
        refresh();
      } catch (err) {
        console.error(err);
        if (err?.code === 4001 || /user rejected/i.test(err?.message || '')) {
          alert('Transaction rejected.');
        } else if (String(err).toLowerCase().includes('insufficient')) {
          alert('Insufficient POL for this purchase.');
        } else {
          alert('Could not send transaction. Please try again.');
        }
      }
    });

    // Clean up any old labels from previous versions
    document.querySelectorAll('.text-muted.small').forEach(el => {
      if (el.textContent?.includes('USDT') || el.textContent?.includes('USD')) {
        el.textContent = `1 POL = ${MGR_PER_POL} MGR`;
      }
    });
    const labelEl = [...document.querySelectorAll('span')].find(e => e.textContent?.trim() === 'AMOUNT (USD)');
    if (labelEl) labelEl.textContent = 'AMOUNT (POL)';
    if ($polInput?.placeholder?.toLowerCase().includes('usd')) $polInput.placeholder = 'Enter POL amount';

    // First paint
    refresh();
  }
})();
</script>
@endpush


