@extends($activeTemplate . 'layouts.master')
@section('content')



    <div class="d-flex justify-content-between align-items-center flex-wrap gap-2 mb-4">
        <h3 class="mb-0">Settings</h3>

        <nav style="--bs-breadcrumb-divider: '>';" aria-label="breadcrumb">
            <ol class="breadcrumb align-items-center mb-0 lh-1">
                <li class="breadcrumb-item">
                    <a href="#" class="d-flex align-items-center text-decoration-none">
                        <i class="ri-home-4-line fs-18 text-primary me-1"></i>
                        <span class="text-secondary fw-medium hover">Dashboard</span>
                    </a>
                </li>
                <li class="breadcrumb-item active" aria-current="page">
                    <span class="fw-medium">Social</span>
                </li>
                <li class="breadcrumb-item active" aria-current="page">
                    <span class="fw-medium">Settings</span>
                </li>
            </ol>
        </nav>
    </div>
    
    
    
        <div class="position-relative">
            <img src="{{ getImage(getFilePath('userCover') . '/' . $user->cover_pic, getFileSize('userCover')) }}" class="rounded-top-3" alt="profile-bg">
            <div class="position-absolute for-rtl-position" style="bottom: 25px; right: 25px;">
             
            </div>
        </div>
        <div class="card bg-white border-0 rounded-3 mb-4 rounded-top-0">
            <div class="card-body p-4">
                <div class="d-flex justify-content-between flex-wrap gap-3">
                    <div class="d-flex align-items-end">
                        <div class="flex-shrink-0 position-relative mt-minus-110">
                            <img src="{{ getImage(getFilePath('userProfile') . '/' . $user->profile_pic, getFileSize('userProfile')) }}" class="rounded-circle border border-2 wh-160" alt="user">
                            <img src="{{ asset('assets/user/images/check.svg') }}" class="position-absolute bottom-0 end-0" alt="check">
                        </div>
                        <div class="flex-grow-1 ms-3">
                            <h4 class="fs-24 mb-1">{{auth()->user()->fullname }}</h4>
                            <span class="fs-15 fw-medium">{{auth()->user()->wallet ?? ''}}</span>
                        </div>
                    </div>
                    <div class="d-flex align-items-center">
                      <a href="#"
                         id="shareReferralBtn"
                         data-url="{{ route('home') }}?reference={{ $user->username }}"
                         class="btn btn-primary fw-medium fs-16 px-4 ms-3">
                        <i class="ri-share-fill fw-medium fs-18 me-1"></i>
                        <span>Share</span>
                      </a>
                    </div>
                </div>
            </div>
        </div>
                    
                    

    <div class="row justify-content-center">
        <div class="col-lg-4">
            <div class="card bg-white border-0 rounded-3 mb-4">
                <div class="card-body p-4">
                    <div class="d-flex align-items-center justify-content-between mb-2">
                        <h4 class="">{{ $user->fullname }}</h4>
                        @if ($user->userRanking && $general->user_ranking)
                            <img class="ranking-user" src="{{ getImage(getFilePath('userRanking') . '/' . $user->userRanking->icon, getFileSize('userRanking')) }}" alt="">
                        @endif
                    </div>
                    <ul class="list-group">

                        <li class="list-group-item d-flex justify-content-between align-items-center">
                            <span><i class="las la-user base--color"></i> @lang('Username')</span> <span class="fw-bold">{{ $user->username }}</span>
                        </li>

                        <li class="list-group-item d-flex justify-content-between align-items-center">
                            <span><i class="las la-envelope base--color"></i> @lang('Email')</span> <span class="fw-bold">{{ $user->email }}</span>
                        </li>


                        <li class="list-group-item d-flex justify-content-between align-items-center">
                            <span><i class="las la-globe base--color"></i> @lang('Country')</span> <span class="fw-bold">{{ @$user->address->country }}</span>
                        </li>

                    </ul>
                </div>
            </div>
                    
        </div>
        <div class="col-lg-8">
            <div class="card bg-white border-0 rounded-3 mb-4">
                <div class="card-body p-4">
                    <h3 class="mb-lg-4 mb-3">Profile Settings</h3>

                    <form action="" method="post" enctype="multipart/form-data">
                          @csrf
                          
                        <div class="row">
                            <div class="col-lg-6 col-sm-6">
                                <div class="form-group mb-4">
                                    <label class="label text-secondary">First Name</label>
                                    <input type="text" class="form-control h-55" name="firstname"
                                    value="{{ $user->firstname }}" required>
                                </div>
                            </div>
                            <div class="col-lg-6 col-sm-6">
                                <div class="form-group mb-4">
                                    <label class="label text-secondary">Last Name</label>
                                    <input type="text" class="form-control h-55" name="lastname"
                                    value="{{ $user->lastname }}" required>
                                </div>
                            </div>
                            <div class="col-lg-6 col-sm-6">
                                <div class="form-group mb-4">
                                    <label class="label text-secondary">Email Address</label>
                                    <input type="email" class="form-control h-55" name="email"
                                        value="{{$user->email}}" required>
                                </div>
                            </div>
                            
                            @php
                                // prefer old input, then saved user country code, else default 'BD'
                                $selectedCountry = old('country', @$user->address->country_code ?? 'BD');
                            @endphp
                            
                            <div class="col-lg-6 col-sm-6">
                                <div class="form-group mb-4">
                                    <label class="label text-secondary">Country</label>
                                    <select id="countrySelect"
                                            class="form-select form-control h-55"
                                            name="country"
                                            aria-label="Country">
                                        @foreach ($countries as $key => $country)
                                            <option
                                                value="{{ $key }}"
                                                data-mobile_code="{{ $country->dial_code }}"
                                                {{ $key == $selectedCountry ? 'selected' : '' }}>
                                                {{ __($country->country) }}
                                            </option>
                                        @endforeach
                                    </select>
                                </div>
                            </div>
                            
                         
                      
                    
                         
                            {{-- Profile Picture --}}
                            <div class="col-lg-6 col-sm-6">
                              <div class="form-group mb-4">
                                <label class="label text-secondary">Profile Picture</label>
                                <div class="form-control h-100 text-center position-relative p-4 p-lg-5">
                                  <div class="product-upload">
                                    <label for="profile-file" class="file-upload mb-0">
                                      <i class="ri-folder-image-line bg-primary bg-opacity-10 p-2 rounded-1 text-primary"></i>
                                      <span class="d-block text-body fs-14">
                                        Drag and drop an image or <span class="text-primary text-decoration-underline">Browse</span>
                                      </span>
                                    </label>
                                    <input id="profile-file" type="file" name="profile_pic" accept="image/*" class="d-none">
                                  </div>
                            
                                  {{-- Hidden flag the JS will flip when user clicks "Remove" --}}
                                  <input type="hidden" name="remove_profile_pic" id="remove_profile_pic" value="0">
                            
                                  <!-- Preview -->
                                  <div id="profile-preview" class="mt-3">
                                    @if(!empty($user->profile_pic))
                                      <img
                                        src="{{ getImage(getFilePath('userProfile') . '/' . $user->profile_pic, getFileSize('userProfile')) }}"
                                        class="img-fluid rounded-3" style="max-height:160px" alt="Profile preview">
                                      <div class="mt-2">
                                        <button type="button" class="btn btn-sm btn-outline-danger" data-remove="profile">Remove</button>
                                      </div>
                                    @endif
                                  </div>
                                </div>
                              </div>
                            </div>
                            
                            {{-- Cover Photo --}}
                            <div class="col-lg-6 col-sm-6">
                              <div class="form-group mb-4">
                                <label class="label text-secondary">Cover Photo</label>
                                <div class="form-control h-100 text-center position-relative p-4 p-lg-5">
                                  <div class="product-upload">
                                    <label for="cover-file" class="file-upload mb-0">
                                      <i class="ri-file-line bg-primary bg-opacity-10 p-2 rounded-1 text-primary"></i>
                                      <span class="d-block text-body fs-14">
                                        Drag and drop a file or <span class="text-primary text-decoration-underline">Browse</span>
                                      </span>
                                    </label>
                                    <input id="cover-file" type="file" name="cover_pic" accept="image/*" class="d-none">
                                  </div>
                            
                                  {{-- Hidden flag the JS will flip when user clicks "Remove" --}}
                                  <input type="hidden" name="remove_cover_pic" id="remove_cover_pic" value="0">
                            
                                  <!-- Preview -->
                                  <div id="cover-preview" class="mt-3">
                                    @if(!empty($user->cover_pic))
                                      <img
                                        src="{{ getImage(getFilePath('userCover') . '/' . $user->cover_pic, getFileSize('userCover')) }}"
                                        class="img-fluid rounded-3" style="max-height:160px" alt="Cover preview">
                                      <div class="mt-2">
                                        <button type="button" class="btn btn-sm btn-outline-danger" data-remove="cover">Remove</button>
                                      </div>
                                    @endif
                                  </div>
                                </div>
                              </div>
                            </div>


                            
                            
                            <div class="col-lg-12">
                                <div class="d-flex flex-wrap gap-3">
                            
                                    <button class="btn btn-primary py-2 px-4 fw-medium fs-16 w-100"> <i class="ri-add-line text-white fw-medium"></i> Save Information</button>
                                </div>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>
      
    </div>



@endsection



@push('script')
<script>
(function(){
  const select        = document.getElementById('countrySelect');
  const hiddenMobile  = document.getElementById('mobile_code');   // dial code digits
  const hiddenCountry = document.getElementById('country_code');   // ISO-2
  const mobileInput   = document.getElementById('mobileInput');

  if (!select || !hiddenMobile || !hiddenCountry || !mobileInput) return;

  function getSelectedDialAndCode() {
    const opt = select.options[select.selectedIndex];
    const dial = (opt?.getAttribute('data-mobile_code') || '').replace(/\D+/g, ''); // digits only
    const cc   = opt?.value || '';
    return { dial, cc };
  }

  function applyFromSelectedOption() {
    const { dial, cc } = getSelectedDialAndCode();
    hiddenMobile.value  = dial;
    hiddenCountry.value = cc;
  }

  // NEW: Strip any leading +<dial> (or bare <dial>) from the input value
  function stripDialFromInput() {
    const dial = hiddenMobile.value; // digits only
    if (!dial) return;

    let v = (mobileInput.value || '').trim();

    // Normalize to digits-only for comparison
    const digits = v.replace(/\D+/g, '');

    // If it already starts with the dial code, remove it ONCE
    if (digits.startsWith(dial)) {
      const rest = digits.slice(dial.length);
      // Keep whatever was after the dial, write back as plain local number
      mobileInput.value = rest;
    }
  }

  // Ensure a default is selected server-side; this is just a safety net
  if (!select.value) {
    const bdOpt = Array.from(select.options).find(o => o.value === 'BD');
    if (bdOpt) bdOpt.selected = true;
  }

  // Initial sync + strip dial from visible input if present
  applyFromSelectedOption();
  stripDialFromInput();

  // If phone is empty, hint with +dial code (placeholder)
  if (!mobileInput.value && hiddenMobile.value) {
    mobileInput.placeholder = `+${hiddenMobile.value} 1XXXXXXXXX`;
  }

  // Update on change (country changes): sync hidden, update placeholder, strip dial again
  select.addEventListener('change', function(){
    applyFromSelectedOption();
    stripDialFromInput();
    if (!mobileInput.value) {
      mobileInput.placeholder = hiddenMobile.value ? `+${hiddenMobile.value} 1XXXXXXXXX` : '';
    }
  });

  // Optional: as user types, keep it digits-only (comment out if you don't want this)
  mobileInput.addEventListener('input', () => {
    mobileInput.value = mobileInput.value.replace(/\D+/g, '');
  });
})();
</script>



<script>
(function () {
  function makePreview({ inputId, previewId, removeKey }) {
    const input   = document.getElementById(inputId);
    const preview = document.getElementById(previewId);
    const flag    = document.getElementById(`remove_${removeKey}_pic`);
    if (!input || !preview || !flag) return;

    // Selecting a new file cancels any pending remove
    input.addEventListener('change', function () {
      const file = this.files && this.files[0];
      flag.value = '0';

      if (!file) { preview.innerHTML = ''; return; }
      if (!file.type.startsWith('image/')) { this.value = ''; preview.innerHTML = ''; return; }

      const reader = new FileReader();
      reader.onload = function (e) {
        preview.innerHTML = `
          <img src="${e.target.result}" class="img-fluid rounded-3" style="max-height:160px" alt="preview">
          <div class="mt-2">
            <button type="button" class="btn btn-sm btn-outline-danger" data-remove="${removeKey}">Remove</button>
          </div>
        `;
      };
      reader.readAsDataURL(file);
    });

    // Remove button: clear input, clear preview, set flag so server deletes old file
    preview.addEventListener('click', function (ev) {
      const btn = ev.target.closest('button[data-remove]');
      if (!btn) return;
      input.value = '';
      preview.innerHTML = '';
      flag.value = '1';
    });
  }

  makePreview({ inputId: 'profile-file', previewId: 'profile-preview', removeKey: 'profile' });
  makePreview({ inputId: 'cover-file',   previewId: 'cover-preview',   removeKey: 'cover' });
})();
</script>



<script>
(function(){
  const btn = document.getElementById('shareReferralBtn');
  if (!btn) return;

  async function copyToClipboard(text) {
    // Try modern API first
    if (navigator.clipboard && window.isSecureContext) {
      await navigator.clipboard.writeText(text);
      return;
    }
    // Fallback: temporary input
    const ta = document.createElement('textarea');
    ta.value = text;
    ta.style.position = 'fixed';
    ta.style.left = '-9999px';
    document.body.appendChild(ta);
    ta.select();
    ta.setSelectionRange(0, ta.value.length);
    document.execCommand('copy');
    document.body.removeChild(ta);
  }

  btn.addEventListener('click', async function(e){
    e.preventDefault();
    const url = this.getAttribute('data-url');
    if (!url) return;

    const labelSpan = this.querySelector('span');
    const oldLabel  = labelSpan ? labelSpan.textContent : '';

    try {
      await copyToClipboard(url);

      // Optional: try native share AFTER copying (nice UX on mobile)
      if (navigator.share) {
        try { await navigator.share({ title: 'My referral link', url }); } catch(_) {}
      }

      // Visual feedback
      if (labelSpan) {
        labelSpan.textContent = 'Copied!';
        this.classList.add('copied'); // if you want to style it
        setTimeout(() => {
          labelSpan.textContent = oldLabel || 'Share';
          this.classList.remove('copied');
        }, 2000);
      }
    } catch (err) {
      console.error('Copy failed', err);
    }
  });
})();
</script>

@endpush
