@extends($activeTemplate.'layouts.master')

@section('content')
  <div class="d-flex justify-content-between align-items-center flex-wrap gap-2 mb-4">
    <h3 class="mb-0">Team Members</h3>
    <nav style="--bs-breadcrumb-divider: '>';" aria-label="breadcrumb">
      <ol class="breadcrumb align-items-center mb-0 lh-1">
        <li class="breadcrumb-item">
          <a href="#" class="d-flex align-items-center text-decoration-none">
            <i class="ri-home-4-line fs-18 text-primary me-1"></i>
            <span class="text-secondary fw-medium hover">Dashboard</span>
          </a>
        </li>
        <li class="breadcrumb-item active" aria-current="page">
          <span class="fw-medium">User</span>
        </li>
        <li class="breadcrumb-item active" aria-current="page">
          <span class="fw-medium">Team Members</span>
        </li>
      </ol>
    </nav>
  </div>

  <div class="row">
    <div class="col-md-12">
      <div class="card bg-white border-0 rounded-3 mb-4">
        <div class="card-body p-4">
          @if ($user->referrer)
            <h4 class="fs-18 mb-4">@lang('You are referred by') {{ $user->referrer->fullname }}</h4>
         @else
               <h4 class="fs-18 mb-4">Referral Link</h4>
          @endif

 
          <div class="form-group position-relative">
            <input type="text"
                   class="form-control h-55 bg-body-bg border-0 text-dark rounded-pill referralURL"
                   value="{{ route('home') }}?reference={{ $user->username }}"
                   readonly>
            <button type="button"
                    id="copyBoard"
                    class="position-absolute top-50 end-0 translate-middle-y bg-primary p-0 border-0 text-center text-white rounded-pill px-3 py-2 me-2 fw-semibold">
              Copy
            </button>
          </div>
        </div>
      </div>
    </div>
  </div>
  
  
  
    
    <div class="row gy-3  border-0 rounded-3 mb-5">
        <div class="col-xxl-6 col-xl-6 col-lg-6 col-md-6 col-sm-6">
            <div class="bg-primary bg-opacity-10 p-5 rounded-3 text-center">
                 <h4 class="card-title mb-2">@lang('Total Team Members')</h4>
                 <h5 class="card-text">{{ $totalTeamMembers }}</h5>
            </div>
        </div>
        <div class="col-xxl-6 col-xl-6 col-lg-6 col-md-6 col-sm-6">
            <div class="bg-primary bg-opacity-10 p-5 rounded-3 text-center">
                 <h4 class="card-title mb-2">@lang('Total Team Buy Token')</h4>
                 <h5 class="card-text">{{ $general->cur_sym ?? '$' }}{{ number_format($totalTeamInvestment, 2) }}</h5> 
            </div>
        </div>
        
    </div>
    
    



      {{-- Level-wise cards (ONLY when there is data) --}}
      @if (!empty($levelData))
        <div class="row gy-4 mb-5">
          @foreach ($levelData as $level => $data)
            <div class="col-md-4">
              <div class="card-item">
                <div class="card-item-body text-center">
                  <h4 class="card-title"><i class="fas fa-users"></i> @lang('Level') {{ $level }}</h4>
                  <h5>@lang('Team Members'): {{ $data['team_members'] }}</h5>
                  <h5>@lang('Token'): {{ $general->cur_sym ?? '$' }}{{ number_format($data['investment'], 2) }}</h5>
                </div>
              </div>
            </div>
          @endforeach
        </div>
      @endif

   {{-- Treant.js tree --}}
    <div class="row justify-content-center mt-4  mb-4">
      <div class="col-12">
        <div class="card bg-white border-0 rounded-3">
          <div class="card-body">
            <h4 class="mb-4 text-center">@lang('Hierarchical Tree View')</h4>
            <!-- Tree canvas -->
            <div id="tree" class="mgr-tree"></div>
          </div>
        </div>
      </div>
    </div>

@endsection

@push('style')
<style>
  /* ---- Tree canvas ---- */
  .mgr-tree{
    position: relative;
    width: 100%;
    height: 620px;               /* fixed height as requested */
    overflow: auto;              /* scroll when needed */
    background:#0b1220;          /* dark like your theme */
    border-radius: 12px;
  }

  /* Use Bootstrap primary as connector color if present */
  :root{
    --mgr-line: var(--bs-primary, #0d6efd);
    --mgr-node-bg: #121a2b;
    --mgr-node-border: var(--bs-primary, #0d6efd);
    --mgr-text: #ffffff;
    --mgr-sub: #9fb3c8;
  }

  /* SVG layer holding the connectors */
  .mgr-svg{
    position:absolute; inset:0;
    pointer-events:none;
  }
  .mgr-link{
    stroke: var(--mgr-line);
    stroke-width: 2.5;
  }

  /* Node (circle) */
  .mgr-node{
    position:absolute;
    width: 120px; height: 120px;
    border-radius: 50%;
    background: radial-gradient(ellipse at 30% 30%, #1a2440, #0f1627);
    border:3px solid var(--mgr-node-border);
    box-shadow: 0 6px 18px rgba(13,110,253,.15);
    color: var(--mgr-text);
    display:flex; flex-direction:column; align-items:center; justify-content:center;
    text-align:center;
    user-select:none;
  }
  .mgr-node .mgr-name{
    font-weight: 700;
    font-size: 12px;
    line-height: 1.2;
    padding: 0 10px;
  }
  .mgr-node .mgr-amt{
    margin-top: 6px;
    font-size: 12px;
    color: var(--mgr-sub);
  }

  /* Level spacing & min gaps (in px) */
  .mgr-tree{ --lvl-gap: 120; --col-gap: 40; }  /* vertical gap, horizontal gap */

  /* Small screens: slightly smaller nodes */
  @media (max-width: 420px){
    .mgr-node{ width: 100px; height: 100px; }
    .mgr-node .mgr-name{ font-size: 11px; }
    .mgr-node .mgr-amt{ font-size: 11px; }
    .mgr-tree{ --lvl-gap: 100; --col-gap: 28; }
  }
</style>
@endpush



@push('style-lib')

@endpush

@push('script-lib')

@endpush


@push('script')
<script>
/**
 * IMPORTANT: make sure in your controller you eager-load referrals deep enough:
 *
 *   $user->load([
 *     'referrals.invests',
 *     'referrals.referrals.invests',
 *     'referrals.referrals.referrals.invests',
 *     ... (repeat to your max expected depth)
 *   ]);
 *
 * We read whatever depth is available and render it.
 */

(function () {
  // Back-end data
  const currency = @json($general->cur_sym ?? '$');
  const root     = @json($user->toArray()); // must include nested 'referrals' arrays
  const treeEl   = document.getElementById('tree');

  // Build a flat list with parent references using DFS
  const nodes = [];
  (function dfs(user, parentId = null){
    // Sum invests if present
    let inv = 0;
    if (Array.isArray(user.invests)) {
      for (const tx of user.invests) inv += Number(tx.amount || 0);
    }
    nodes.push({
      id: user.id,
      parentId,
      name: (user.firstname && user.lastname) ? (user.firstname + ' ' + user.lastname)
            : (user.fullname || user.username || 'User ' + user.id),
      amount: currency + inv.toFixed(2)
    });
    if (Array.isArray(user.referrals)) {
      for (const child of user.referrals) dfs(child, user.id);
    }
  })(root, null);

  // Compute levels (BFS by parentId)
  const byId = Object.fromEntries(nodes.map(n => [n.id, n]));
  const children = {};
  for (const n of nodes) {
    if (n.parentId != null) {
      (children[n.parentId] ||= []).push(n.id);
    }
  }
  const rootNode = nodes.find(n => n.parentId == null) || nodes[0];
  const levels = [];
  let q = [rootNode.id];
  const seen = new Set();
  while (q.length) {
    const next = [];
    levels.push(q.slice());
    for (const id of q) {
      if (seen.has(id)) continue;
      seen.add(id);
      const kids = children[id] || [];
      next.push(...kids);
    }
    q = next;
  }

  // Create layers
  treeEl.innerHTML = '';
  const svg = document.createElementNS('http://www.w3.org/2000/svg','svg');
  svg.classList.add('mgr-svg');
  treeEl.appendChild(svg);

  // Dimensions
  function nodeW(){ return treeEl.querySelector('.mgr-node')?.offsetWidth || 120; }
  function nodeH(){ return treeEl.querySelector('.mgr-node')?.offsetHeight || 120; }
  const L = parseInt(getComputedStyle(treeEl).getPropertyValue('--lvl-gap')) || 120;
  const G = parseInt(getComputedStyle(treeEl).getPropertyValue('--col-gap')) || 40;

  // Layout: center each level and space nodes evenly
  const placed = {}; // id -> {x,y}
  function layoutAndRender(){
    // Clear
    svg.setAttribute('width', treeEl.scrollWidth);
    svg.setAttribute('height', treeEl.scrollHeight);
    svg.innerHTML = '';
    treeEl.querySelectorAll('.mgr-node').forEach(el => el.remove());

    const w = treeEl.clientWidth;
    const nw = nodeW();
    const nh = nodeH();

    let maxRight = 0, maxBottom = 0;

    levels.forEach((ids, levelIdx) => {
      const count = ids.length;
      if (count === 0) return;

      // total width of this level row
      const totalRowWidth = count * nw + (count - 1) * G;
      let startX = Math.max(20, (w - totalRowWidth) / 2); // center, with padding
      const y = 20 + levelIdx * (nh + L);

      ids.forEach((id, i) => {
        const x = startX + i * (nw + G);
        placed[id] = {x, y};

        // Node element
        const node = document.createElement('div');
        node.className = 'mgr-node';
        node.style.left = x + 'px';
        node.style.top  = y + 'px';
        node.innerHTML = `
          <div class="mgr-name">${escapeHtml(byId[id].name)}</div>
          <div class="mgr-amt">${escapeHtml(byId[id].amount)}</div>
        `;
        treeEl.appendChild(node);

        maxRight  = Math.max(maxRight, x + nw + 20);
        maxBottom = Math.max(maxBottom, y + nh + 20);
      });
    });

    // Draw connectors: parent bottom center -> child top center
    for (const n of nodes) {
      if (n.parentId == null) continue;
      const p = placed[n.parentId], c = placed[n.id];
      if (!p || !c) continue;
      const x1 = p.x + nw / 2, y1 = p.y + nh;
      const x2 = c.x + nw / 2, y2 = c.y;
      const line = document.createElementNS('http://www.w3.org/2000/svg','line');
      line.setAttribute('x1', x1);
      line.setAttribute('y1', y1);
      line.setAttribute('x2', x2);
      line.setAttribute('y2', y2);
      line.setAttribute('class','mgr-link');
      svg.appendChild(line);
    }

    // Expand scrollable area to fit all content
    svg.setAttribute('width',  Math.max(treeEl.clientWidth,  maxRight));
    svg.setAttribute('height', Math.max(treeEl.clientHeight, maxBottom));
    treeEl.style.minWidth  = Math.max(treeEl.clientWidth,  maxRight) + 'px';
    treeEl.style.minHeight = Math.max(620, maxBottom) + 'px';
  }

  // Basic HTML escaper
  function escapeHtml(s){
    return String(s ?? '').replace(/[&<>"']/g, m =>
      ({'&':'&amp;','<':'&lt;','>':'&gt;','"':'&quot;',"'":'&#39;'}[m]));
  }

  // Initial render & responsive rerender
  layoutAndRender();
  window.addEventListener('resize', () => {
    // throttle slightly
    clearTimeout(window.__mgr_tree_resize);
    window.__mgr_tree_resize = setTimeout(layoutAndRender, 120);
  });


  
})();
</script>


<script>



  document.addEventListener('DOMContentLoaded', function () {

    // Copy referral link
    const btn   = document.getElementById('copyBoard');
    const input = document.querySelector('.referralURL');
    if (btn && input) {
      btn.addEventListener('click', async function () {
        try {
          await navigator.clipboard.writeText(input.value);
          const old = btn.textContent;
          btn.textContent = 'Copied!';
          setTimeout(()=> btn.textContent = old, 2000);
        } catch (e) {}
      });
    }
  });
</script>
@endpush


