@extends($activeTemplate.'layouts.master')

@section('content')
  <div class="d-flex justify-content-between align-items-center flex-wrap gap-2 mb-4">
    <h3 class="mb-0">@lang('Open Support Ticket')</h3>

    <nav style="--bs-breadcrumb-divider: '>';" aria-label="breadcrumb">
      <ol class="breadcrumb align-items-center mb-0 lh-1">
        <li class="breadcrumb-item">
          <a href="#" class="d-flex align-items-center text-decoration-none">
            <i class="ri-home-4-line fs-18 text-primary me-1"></i>
            <span class="text-secondary fw-medium hover">@lang('Dashboard')</span>
          </a>
        </li>
        <li class="breadcrumb-item active" aria-current="page">
          <span class="fw-medium">@lang('Support')</span>
        </li>
        <li class="breadcrumb-item active" aria-current="page">
          <span class="fw-medium">@lang('Open Ticket')</span>
        </li>
      </ol>
    </nav>
  </div>

  <div class="row justify-content-center">
    <div class="col-lg-10">
      <div class="card bg-white border-0 rounded-3 mb-4">
        <div class="card-body p-4">
          <h3 class="mb-lg-4 mb-3">@lang('Ticket Details')</h3>

          <form action="{{ route('ticket.store') }}" method="post" enctype="multipart/form-data">
            @csrf

            <div class="row">
              <div class="col-lg-6 col-sm-6">
                <div class="form-group mb-4">
                  <label class="label text-secondary">@lang('Name')</label>
                  <input type="text" class="form-control h-55" name="name"
                         value="{{ @$user->firstname . ' ' . @$user->lastname }}"
                         readonly required>
                </div>
              </div>

              <div class="col-lg-6 col-sm-6">
                <div class="form-group mb-4">
                  <label class="label text-secondary">@lang('Email Address')</label>
                  <input type="email" class="form-control h-55" name="email"
                         value="{{ @$user->email }}"
                         readonly required>
                </div>
              </div>

              <div class="col-lg-6 col-sm-6">
                <div class="form-group mb-4">
                  <label class="label text-secondary">@lang('Subject')</label>
                  <input type="text" class="form-control h-55" name="subject"
                         value="{{ old('subject') }}" required>
                </div>
              </div>

              <div class="col-lg-6 col-sm-6">
                <div class="form-group mb-4">
                  <label class="label text-secondary">@lang('Priority')</label>
                  <select name="priority" class="form-select form-control h-55" required>
                    <option value="3" @selected(old('priority')=='3')>@lang('High')</option>
                    <option value="2" @selected(old('priority')=='2')>@lang('Medium')</option>
                    <option value="1" @selected(old('priority')=='1')>@lang('Low')</option>
                  </select>
                </div>
              </div>

              <div class="col-12">
                <div class="form-group mb-4">
                  <label class="label text-secondary">@lang('Message')</label>
                  <textarea name="message" rows="6" class="form-control" required>{{ old('message') }}</textarea>
                </div>
              </div>

              {{-- Attachments --}}
              <div class="col-12">
                <div class="form-group mb-3">
                  <div class="d-flex justify-content-between align-items-center">
                    <label class="label text-secondary mb-0">
                      @lang('Attachments')
                      <small class="text-muted">(@lang('max') 5)</small>
                    </label>
                    <button type="button" class="btn btn-outline-primary btn-sm addFile">
                      <i class="ri-add-line"></i> @lang('Add File')
                    </button>
                  </div>

                  <small class="text-muted d-block mt-1">
                    @lang('Allowed'): .jpg, .jpeg, .png, .pdf, .doc, .docx — @lang('Max upload size'): {{ ini_get('upload_max_filesize') }}
                  </small>

                  <div class="mt-3" id="fileUploadsContainer">
                    <div class="input-group mb-2 file-row">
                      <input type="file" name="attachments[]" class="form-control"
                             accept=".jpg,.jpeg,.png,.pdf,.doc,.docx">
                      <button type="button" class="btn btn-outline-danger remove-btn">
                        <i class="ri-close-line"></i>
                      </button>
                    </div>
                  </div>
                </div>
              </div>

              <div class="col-12">
                <button class="btn btn-primary py-2 px-4 fw-medium fs-16 w-100" type="submit">
                  <i class="ri-send-plane-2-line text-white fw-medium"></i> @lang('Submit Ticket')
                </button>
              </div>
            </div>
          </form>

        </div>
      </div>
    </div>
  </div>
@endsection

@push('style')
<style>
  /* match the newer form look/feel */
  .form-control.h-55, .form-select.h-55 { height: 55px; }
  .file-row .remove-btn { border-left: 0; }
</style>
@endpush

@push('script')
<script>
(function ($) {
  "use strict";

  const container = $('#fileUploadsContainer');
  const maxFiles  = 5;
  const rowHtml = () => `
    <div class="input-group mb-2 file-row">
      <input type="file" name="attachments[]" class="form-control"
             accept=".jpg,.jpeg,.png,.pdf,.doc,.docx">
      <button type="button" class="btn btn-outline-danger remove-btn">
        <i class="ri-close-line"></i>
      </button>
    </div>`;

  // Ensure at least one row exists
  if (container.find('.file-row').length === 0) {
    container.append(rowHtml());
  }

  $('.addFile').on('click', function () {
    const count = container.find('input[type="file"]').length;
    if (count >= maxFiles) {
      // Use your notify/toast if available
      if (window.notify) notify('error', "@lang('You have reached the maximum number of files')");
      return;
    }
    container.append(rowHtml());
  });

  container.on('click', '.remove-btn', function () {
    const rows = container.find('.file-row');
    if (rows.length === 1) {
      // clear the only input instead of removing the row
      rows.find('input[type="file"]').val('');
      return;
    }
    $(this).closest('.file-row').remove();
  });

})(jQuery);
</script>
@endpush
