@extends($activeTemplate.'layouts.master')

@section('content')

@php
    use Carbon\Carbon;
    use Illuminate\Pagination\AbstractPaginator;

    // Always work with a Collection
    $col = ($supports instanceof AbstractPaginator) ? $supports->getCollection() : collect($supports);

    // Status mapping (adjust to your app):
    // 0 = Open, 1 = Answered, 2 = Customer Reply, 3 = Closed
    $resolvedCount   = $col->where('status', 3)->count();
    $inProgressCount = $col->whereIn('status', [1, 2])->count();
    
    $newOpenCount    = $col->where('status', 0)
                           ->filter(function($t){
                               // created this month
                               try { return Carbon::parse($t->created_at)->betweenIncluded(now()->startOfMonth(), now()->endOfMonth()); }
                               catch (\Throwable $e) { return false; }
                           })->count();

    // Count due tickets if a due_date exists on items (and not closed)
    $ticketsDueCount = $col->filter(function($t){
        if (!isset($t->due_date) || empty($t->due_date)) return false;
        if (isset($t->status) && (int)$t->status === 3)   return false; // skip closed
        try { return Carbon::parse($t->due_date)->isPast(); }
        catch (\Throwable $e) { return false; }
    })->count();
    
@endphp

<div class="d-flex justify-content-between align-items-center flex-wrap gap-2 mb-4">
    <h3 class="mb-0">@lang('Support Tickets')</h3>

    <nav style="--bs-breadcrumb-divider: '>';" aria-label="breadcrumb">
        <ol class="breadcrumb align-items-center mb-0 lh-1">
            <li class="breadcrumb-item">
                <a href="{{ route('user.home') }}" class="d-flex align-items-center text-decoration-none">
                    <i class="ri-home-4-line fs-18 text-primary me-1"></i>
                    <span class="text-secondary fw-medium hover">@lang('Dashboard')</span>
                </a>
            </li>
            <li class="breadcrumb-item active" aria-current="page">
                <span class="fw-medium">@lang('Support')</span>
            </li>
            <li class="breadcrumb-item active" aria-current="page">
                <span class="fw-medium">@lang('Tickets')</span>
            </li>
        </ol>
    </nav>
</div>

{{-- KPI cards --}}
<div class="row justify-content-center">
    
 
                        
                        
    <div class="col-lg-3 col-md-6">
        <div class="card bg-white border-0 rounded-3 mb-4">
            <div class="card-body p-3">
                <span>@lang('Tickets Resolved')</span>
                <h3 class="mb-0 fs-20">{{ number_format($resolvedCount) }}</h3>
                <div id="tickets_resolved" style="margin: -11px 0;"></div>
                <div class="d-flex justify-content-between align-items-center mt-3">
                    <span class="fs-12">@lang('This Month')</span>
                    <i class="material-symbols-outlined text-success">trending_up</i>
                </div>
            </div>
        </div>
    </div>
    <div class="col-lg-3 col-md-6">
        <div class="card bg-white border-0 rounded-3 mb-4">
            <div class="card-body p-3">
                <span>@lang('In Progress')</span>
                <h3 class="mb-0 fs-20">{{ number_format($inProgressCount) }}</h3>
                <div id="in_progress" style="margin: -11px 0;"></div>
                <div class="d-flex justify-content-between align-items-center mt-3">
                    <span class="fs-12">@lang('This Month')</span>
                    <i class="material-symbols-outlined text-danger">trending_down</i>
                </div>
            </div>
        </div>
    </div>
    <div class="col-lg-3 col-md-6">
        <div class="card bg-white border-0 rounded-3 mb-4">
            <div class="card-body p-3">
                <span>@lang('Tickets Due')</span>
                <h3 class="mb-0 fs-20">{{ number_format($ticketsDueCount) }}</h3>
                <div id="tickets_due" style="margin: -11px 0;"></div>
                <div class="d-flex justify-content-between align-items-center mt-3">
                    <span class="fs-12">@lang('This Month')</span>
                    <i class="material-symbols-outlined text-danger">trending_down</i>
                </div>
            </div>
        </div>
    </div>
    <div class="col-lg-3 col-md-6">
        <div class="card bg-white border-0 rounded-3 mb-4">
            <div class="card-body p-3">
                <span>@lang('Tickets New Open')</span>
                <h3 class="mb-0 fs-20">{{ number_format($newOpenCount) }}</h3>
                <div id="tickets_new_open" style="margin: -11px 0;"></div>
                <div class="d-flex justify-content-between align-items-center mt-3">
                    <span class="fs-12">@lang('This Month')</span>
                    <i class="material-symbols-outlined text-success">trending_up</i>
                </div>
            </div>
        </div>
    </div>
</div>

{{-- Tickets table --}}
<div class="card bg-white border-0 rounded-3 mb-4">
    <div class="card-body p-4">
        <div class="d-flex justify-content-between align-items-center flex-wrap gap-2 mb-4">
            <h3 class="mb-0">@lang('All Tickets')</h3>
            <a href="{{ route('ticket.open') }}" class="btn btn-outline-primary py-1 px-2 px-sm-4 fs-14 fw-medium rounded-3">
                <span class="py-sm-1 d-block">
                    <i class="ri-add-line d-none d-sm-inline-block"></i>
                    <span>@lang('Open Support Ticket')</span>
                </span>
            </a>
        </div>

        <div class="default-table-area all-projects">
            <div class="table-responsive">
                <table class="table align-middle">
                    <thead>
                        <tr>
                            <th scope="col">@lang('ID')</th>
                            <th scope="col">@lang('Ticket Title')</th>
                            <th scope="col">@lang('Requester')</th>
                            <th scope="col">@lang('Assigned To')</th>
                            <th scope="col">@lang('Created Date')</th>
                            <th scope="col">@lang('Due Date')</th>
                            <th scope="col">@lang('Priority')</th>
                            <th scope="col">@lang('Status')</th>
                            <th scope="col">@lang('Action')</th>
                        </tr>
                    </thead>
                    <tbody>
                        @forelse($supports as $support)
                            <tr>
                                <td class="text-body">#{{ $support->ticket }}</td>

                                <td>
                                    <a href="{{ route('ticket.view', $support->ticket) }}" class="fw-medium">
                                        {{ __($support->subject) }}
                                    </a>
                                </td>

                                <td class="text-secondary">
                                    {{ auth()->user()->fullname ?? auth()->user()->username }}
                                </td>

                                <td class="text-secondary">
                                    {{-- If you have $support->agent or similar, show it here --}}
                                    —
                                </td>

                                <td class="text-secondary">
                                    {{ showDateTime($support->created_at) }}
                                </td>

                                <td class="text-secondary">
                                    {{-- If you store due_date on the ticket, show it; else dash --}}
                                    {{ isset($support->due_date) ? showDateTime($support->due_date) : '—' }}
                                </td>

                                <td class="text-secondary">
                                    @if($support->priority == 1)
                                        <span class="badge bg-secondary bg-opacity-10 text-secondary p-2 fs-12 fw-normal">@lang('Low')</span>
                                    @elseif($support->priority == 2)
                                        <span class="badge bg-success bg-opacity-10 text-success p-2 fs-12 fw-normal">@lang('Medium')</span>
                                    @elseif($support->priority == 3)
                                        <span class="badge bg-primary bg-opacity-10 text-primary p-2 fs-12 fw-normal">@lang('High')</span>
                                    @else
                                        <span class="badge bg-light text-dark p-2 fs-12 fw-normal">@lang('N/A')</span>
                                    @endif
                                </td>

                                <td>
                                    {!! $support->statusBadge !!}
                                </td>

                                <td>
                                    <div class="d-flex align-items-center gap-1">
                                        <a href="{{ route('ticket.view', $support->ticket) }}"
                                           class="ps-0 border-0 bg-transparent lh-1 position-relative top-2">
                                            <i class="material-symbols-outlined fs-16 text-primary">visibility</i>
                                        </a>
                                    </div>
                                </td>
                            </tr>
                        @empty
                            <tr>
                                <td colspan="9" class="text-center text-muted py-4">{{ __($emptyMessage ?? 'No tickets found') }}</td>
                            </tr>
                        @endforelse
                    </tbody>
                </table>
            </div>

            {{-- Pagination --}}
            @if ($supports->hasPages())
                <div class="d-flex justify-content-center justify-content-sm-between align-items-center text-center flex-wrap gap-2 showing-wrap mt-3">
                    <span class="fs-13 fw-medium">
                        @lang('Items per page'): {{ $supports->perPage() }}
                    </span>
                    <div>
                        {{ $supports->links() }}
                    </div>
                </div>
            @endif
        </div>
    </div>
</div>


@endsection
