@extends($activeTemplate.'layouts.'.$layout)

@section('content')
  <div class="d-flex justify-content-between align-items-center flex-wrap gap-2 mb-4">
    <h3 class="mb-0">@lang('Ticket Details')</h3>

    <nav style="--bs-breadcrumb-divider: '>';" aria-label="breadcrumb">
      <ol class="breadcrumb align-items-center mb-0 lh-1">
        <li class="breadcrumb-item">
          <a href="#" class="d-flex align-items-center text-decoration-none">
            <i class="ri-home-4-line fs-18 text-primary me-1"></i>
            <span class="text-secondary fw-medium hover">@lang('Dashboard')</span>
          </a>
        </li>
        <li class="breadcrumb-item active" aria-current="page">
          <span class="fw-medium">@lang('HelpDesk')</span>
        </li>
        <li class="breadcrumb-item active" aria-current="page">
          <span class="fw-medium">@lang('Ticket Details')</span>
        </li>
      </ol>
    </nav>
  </div>

  {{-- Top summary table (single row) --}}
  <div class="card bg-white border-0 rounded-3 mb-4">
    <div class="card-body py-4 px-0">
      <div class="default-table-area style-two all-projects">
        <div class="table-responsive">
          <table class="table align-middle mb-0">
            <thead>
              <tr>
                <th scope="col">@lang('ID')</th>
                <th scope="col">@lang('Ticket Title')</th>
                <th scope="col">@lang('Requester')</th>
                <th scope="col">@lang('Assigned To')</th>
                <th scope="col">@lang('Created Date')</th>
                <th scope="col">@lang('Priority')</th>
                <th scope="col">@lang('Status')</th>
                <th scope="col" class="text-end">@lang('Action')</th>
              </tr>
            </thead>
            <tbody>
              <tr>
                <td class="text-body">#{{ $myTicket->ticket }}</td>
                <td>
                  <span class="fw-medium">{{ $myTicket->subject }}</span>
                </td>
                <td class="text-secondary">
                  {{ $myTicket->name ?? optional($myTicket->user)->fullname ?? optional($myTicket->user)->username }}
                </td>
                <td class="text-secondary">
                  {{-- If you store an assigned admin/user, render here; else dash --}}
                  {{ $myTicket->assigned_to ?? '—' }}
                </td>
                <td class="text-secondary">
                  {{ showDateTime($myTicket->created_at) }}
                </td>
                <td class="text-secondary">
                  @if($myTicket->priority == 3)
                    <span class="badge bg-danger bg-opacity-10 text-danger p-2 fs-12 fw-normal">@lang('High')</span>
                  @elseif($myTicket->priority == 2)
                    <span class="badge bg-success bg-opacity-10 text-success p-2 fs-12 fw-normal">@lang('Medium')</span>
                  @else
                    <span class="badge bg-dark bg-opacity-10 text-body p-2 fs-12 fw-normal">@lang('Low')</span>
                  @endif
                </td>
                <td>{!! $myTicket->statusBadge !!}</td>
                <td class="text-end">
                  @if($myTicket->status != 3 && $myTicket->user)
                    <button
                      class="btn btn-outline-danger btn-sm confirmationBtn"
                      type="button"
                      data-question="@lang('Are you sure to close this ticket?')"
                      data-action="{{ route('ticket.close', $myTicket->id) }}">
                      <i class="ri-close-circle-line me-1"></i>@lang('Close')
                    </button>
                  @endif
                </td>
              </tr>
            </tbody>
          </table>
        </div>
      </div>
    </div>
  </div>

  {{-- Messages + Reply --}}
  <div class="row">
    <div class="col-xxl-8 col-lg-7">
      <div class="card bg-white border-0 rounded-3 mb-4">
        <div class="card-body p-4">
          <h4 class="fs-15 mb-3">@lang('Conversation')</h4>

          @forelse($messages as $message)
            @php
              $isStaff = $message->admin_id != 0;
              $author  = $isStaff ? optional($message->admin)->name : optional($message->ticket)->name;
              $posted  = $message->created_at->format('l, dS F Y @ H:i');
            @endphp

            <div class="border-bottom pb-4 mb-4 {{ $isStaff ? 'ps-4' : '' }}">
              <div class="d-flex flex-wrap gap-3 align-items-center mb-2">
                <div class="wh-34 rounded-circle bg-body-bg d-flex align-items-center justify-content-center">
                  <i class="ri-user-3-line"></i>
                </div>
                <span class="fw-medium {{ $isStaff ? 'text-danger' : 'text-primary' }}">
                  {{ $author }}
                </span>
                <span class="text-secondary">{{ $posted }}</span>
                @if($isStaff)
                  <span class="text-white fw-medium px-2 rounded-1 fs-12 position-relative top-2" style="background-color:#3584fc;">
                    @lang('Support Staff')
                  </span>
                @else
                  <span class="bg-primary text-white fw-medium px-2 rounded-1 fs-12 position-relative top-2">
                    #{{ $message->ticket->ticket }}
                  </span>
                @endif
              </div>

              <p class="mb-2">{{ $message->message }}</p>

              @if($message->attachments->count() > 0)
                <h6 class="fs-13 text-secondary mb-2">@lang('Attachments')</h6>
                <div class="d-flex flex-wrap gap-3">
                  @foreach($message->attachments as $k => $image)
                    <a class="btn btn-light btn-sm d-inline-flex align-items-center"
                       href="{{ route('ticket.download', encrypt($image->id)) }}">
                      <i class="ri-download-2-line me-1"></i>
                      @lang('Attachment') {{ $k+1 }}
                    </a>
                  @endforeach
                </div>
              @endif
            </div>
          @empty
            <p class="text-muted mb-0">@lang('No messages yet.')</p>
          @endforelse

          @if($myTicket->status != 4)
            <form method="post" action="{{ route('ticket.reply', $myTicket->id) }}" enctype="multipart/form-data">
              @csrf
              <div class="form-group mb-4">
                <label class="label text-secondary fs-14">@lang('Post A Reply')</label>
                <textarea name="message" rows="5" class="form-control" required>{{ old('message') }}</textarea>
              </div>

              <div class="form-group mb-3">
                <div class="d-flex justify-content-between align-items-center">
                  <label class="label text-secondary mb-0">
                    @lang('Attachments')
                    <small class="text-muted">(@lang('max') 5)</small>
                  </label>
                  <button type="button" class="btn btn-outline-primary btn-sm addFile">
                    <i class="ri-add-line"></i> @lang('Add File')
                  </button>
                </div>

                <small class="text-muted d-block mt-1">
                  @lang('Allowed'): .jpg, .jpeg, .png, .pdf, .doc, .docx —
                  @lang('Maximum upload size is') {{ ini_get('upload_max_filesize') }}
                </small>

                <div class="mt-3" id="fileUploadsContainer">
                  <div class="input-group mb-2 file-row">
                    <input type="file" name="attachments[]" class="form-control"
                           accept=".jpg,.jpeg,.png,.pdf,.doc,.docx">
                    <button type="button" class="btn btn-outline-danger remove-btn">
                      <i class="ri-close-line"></i>
                    </button>
                  </div>
                </div>
              </div>

              <button type="submit" class="btn btn-primary fw-medium fs-16 py-2 px-4 w-100">
                <i class="ri-send-plane-2-line text-white me-1"></i> @lang('Reply')
              </button>
            </form>
          @endif
        </div>
      </div>
    </div>

    {{-- Right side: last message attachments (optional helper pane) --}}
    <div class="col-xxl-4 col-lg-5">
      <div class="card bg-white border-0 rounded-3 mb-4">
        <div class="card-body p-4">
          <h3 class="mb-4">@lang('Recent Attachments')</h3>

          @php
            $allAttachments = $messages->flatMap->attachments;
          @endphp

          @forelse($allAttachments->take(10) as $att)
            <div class="d-flex justify-content-between align-items-center bg-body-bg p-3 rounded-3 mb-3">
              <div class="d-flex align-items-center">
                <div class="flex-shrink-0">
                  <i class="ri-file-warning-line wh-40 lh-40 d-inline-block bg-white text-center fs-18 text-primary rounded-circle"></i>
                </div>
                <div class="flex-grow-1 ms-3">
                  <h4 class="mb-1 fs-14 fw-medium">{{ basename($att->name ?? ('file-'.$att->id)) }}</h4>
                  <span class="fs-13">{{ number_format(($att->size ?? 0)/1024, 2) }} KB</span>
                </div>
              </div>
              <a class="p-0 border-0 bg-transparent" href="{{ route('ticket.download', encrypt($att->id)) }}">
                <i class="ri-download-2-line fs-22 text-primary"></i>
              </a>
            </div>
          @empty
            <p class="text-muted mb-0">@lang('No attachments yet.')</p>
          @endforelse
        </div>
      </div>
    </div>
  </div>

  {{-- Reuse your existing confirmation modal --}}
  <x-confirmation-modal closeBtn="btn-danger btn-md" submitBtn="btn--base btn-md"></x-confirmation-modal>
@endsection

@push('style')
<style>
  .form-control.h-55, .form-select.h-55 { height: 55px; }
  .file-row .remove-btn { border-left: 0; }
</style>
@endpush

@push('script')

<script>
document.addEventListener('DOMContentLoaded', function () {
  /* ================================
   *  Attachments: add / remove (max 5)
   * ================================ */
  const MAX_FILES = 5;

  // The initial (base) file input just above the container
  const baseInput = document.querySelector('input[type="file"][name="attachments[]"]');
  const addBtn    = document.querySelector('.addFile');
  const holder    = document.getElementById('fileUploadsContainer');

  function currentTotalInputs() {
    // Count the base input + any extra inputs inside holder
    const extra = holder ? holder.querySelectorAll('input[type="file"][name="attachments[]"]').length : 0;
    return (baseInput ? 1 : 0) + extra;
  }

  function canAddMore() {
    return currentTotalInputs() < MAX_FILES;
  }

  function renderNewInputRow() {
    const wrap = document.createElement('div');
    wrap.className = 'input-group my-3';

    const input = document.createElement('input');
    input.type = 'file';
    input.name = 'attachments[]';
    input.className = 'form-control form--control';
    input.required = true;

    const btn = document.createElement('button');
    btn.type = 'button';
    btn.className = 'input-group-text btn-danger remove-btn';
    btn.innerHTML = '<i class="las la-times"></i>';

    wrap.appendChild(input);
    wrap.appendChild(btn);
    return wrap;
  }

  if (addBtn && holder) {
    addBtn.addEventListener('click', function (e) {
      e.preventDefault();
      if (!canAddMore()) {
        // Replace notify(...) with your own toast if you want
        alert(`You can upload up to ${MAX_FILES} files total.`);
        return;
      }
      holder.appendChild(renderNewInputRow());
    });

    holder.addEventListener('click', function (ev) {
      const btn = ev.target.closest('.remove-btn');
      if (!btn) return;
      const row = btn.closest('.input-group');
      if (row) row.remove();
    });
  }

  /* =========================================
   *  Close ticket confirmation (no jQuery)
   *  Expects a button/link with:
   *   - class="confirmationBtn"
   *   - data-action="CLOSE_URL"
   *   - data-question="Are you sure...?"
   * ========================================= */
  const csrf =
    (document.querySelector('meta[name="csrf-token"]') &&
     document.querySelector('meta[name="csrf-token"]').getAttribute('content')) || '';

  function postTo(url) {
    const form = document.createElement('form');
    form.method = 'POST';
    form.action = url;

    // _token
    if (csrf) {
      const token = document.createElement('input');
      token.type = 'hidden';
      token.name = '_token';
      token.value = csrf;
      form.appendChild(token);
    }

    document.body.appendChild(form);
    form.submit();
  }

  document.querySelectorAll('.confirmationBtn[data-action]').forEach(function (btn) {
    btn.addEventListener('click', function (e) {
      e.preventDefault();
      const action   = btn.getAttribute('data-action');
      const question = btn.getAttribute('data-question') || 'Are you sure?';
      if (!action) return;

      if (confirm(question)) {
        postTo(action);
      }
    });
  });
});
</script>

@endpush
