@extends($activeTemplate . 'layouts.master')

@section('content')
  <div class="d-flex justify-content-between align-items-center flex-wrap gap-2 mb-4">
    <h3 class="mb-0">Team Commission</h3>
    <nav style="--bs-breadcrumb-divider: '>';" aria-label="breadcrumb">
      <ol class="breadcrumb align-items-center mb-0 lh-1">
        <li class="breadcrumb-item">
          <a href="{{ route('user.home') }}" class="d-flex align-items-center text-decoration-none">
            <i class="ri-home-4-line fs-18 text-primary me-1"></i>
            <span class="text-secondary fw-medium hover">Dashboard</span>
          </a>
        </li>
        <li class="breadcrumb-item active" aria-current="page">
          <span class="fw-medium">Team Commission</span>
        </li>
      </ol>
    </nav>
  </div>

  {{-- Summary --}}
  <div class="row g-3 mb-4">
    <div class="col-md-6 col-lg-4">
      <div class="card bg-white border-0 rounded-3 h-100">
        <div class="card-body p-4">
          <span class="text-secondary">Your Token Balance</span>
          <h3 class="mb-0 fs-20">{{ number_format($tokenBalance) }}</h3>
          <div class="mt-2 small text-secondary">
            Requirements —
            <strong>Lv 1–2:</strong> {{ number_format($requirements['1-2']) }},
            <strong>Lv 3–5:</strong> {{ number_format($requirements['3-5']) }},
            <strong>Lv 6–8:</strong> {{ number_format($requirements['6-8']) }} tokens
          </div>
        </div>
      </div>
    </div>

    @php
      $completedLevels = 0;
      foreach ($levels as $lvl => $pct) {
          $need = $lvl <= 2 ? $requirements['1-2'] : ($lvl <= 5 ? $requirements['3-5'] : $requirements['6-8']);
          if ($tokenBalance >= $need) $completedLevels++;
      }
      $overallPct = round($completedLevels * 100 / max(1, count($levels)));
    @endphp

    <div class="col-md-6 col-lg-4">
      <div class="card bg-white border-0 rounded-3 h-100">
        <div class="card-body p-4">
          <span class="text-secondary">Levels Unlocked</span>
          <h3 class="mb-0 fs-20">{{ $completedLevels }} / {{ count($levels) }}</h3>
          <div class="progress mt-2" role="progressbar" aria-valuenow="{{ $overallPct }}" aria-valuemin="0" aria-valuemax="100">
            <div class="progress-bar bg-success" style="width: {{ $overallPct }}%"></div>
          </div>
        </div>
      </div>
    </div>
  </div>

  {{-- Cards per Level --}}
  <div class="row g-3">
    @foreach($levels as $level => $percent)
      @php
        // Requirement pack for the level
        $pack = $level <= 2 ? '1-2' : ($level <= 5 ? '3-5' : '6-8');
        $needed = $requirements[$pack];
        $progress = min(100, ($tokenBalance / max(1, $needed)) * 100);
        $progressRounded = round($progress);
        $unlocked = $tokenBalance >= $needed;

        // Colors / labels
        $barClass = $unlocked ? 'bg-success'
                  : ($progress > 0 ? 'bg-warning text-dark' : 'bg-danger');
        $statusText = $unlocked ? 'Completed' : ($progress > 0 ? 'In Progress' : 'Locked');
        $statusBadgeClass = $unlocked ? 'bg-success bg-opacity-10 text-success'
                            : ($progress > 0 ? 'bg-warning bg-opacity-10 text-warning'
                                             : 'bg-danger bg-opacity-10 text-danger');

        // Pack label
        $packLabel = $pack === '1-2' ? 'Unlocks with 6,000 tokens'
                   : ($pack === '3-5' ? 'Unlocks with 14,000 tokens'
                                      : 'Unlocks with 20,000 tokens');
      @endphp

      <div class="col-xxl-3 col-lg-4 col-sm-6">
        <div class="card bg-white border-0 rounded-3 h-100">
          <div class="card-body p-4 d-flex flex-column">
            <div class="d-flex justify-content-between align-items-center mb-2">
              <h4 class="fs-16 fw-semibold mb-0">Level {{ $level }}</h4>
              <span class="badge {{ $statusBadgeClass }} p-2 fs-12 fw-normal">{{ $statusText }}</span>
            </div>

            <div class="mb-1">
              <span class="text-secondary">Commission</span>
              <h5 class="mb-0">{{ $percent }}%</h5>
            </div>

            <div class="small text-secondary mb-2">{{ $packLabel }}</div>

            <div class="progress mb-1" role="progressbar"
                 aria-valuenow="{{ $progressRounded }}" aria-valuemin="0" aria-valuemax="100">
              <div class="progress-bar progress-bar-striped progress-bar-animated {{ $barClass }}"
                   style="width: {{ $progressRounded }}%">{{ $progressRounded }}%</div>
            </div>
            <div class="d-flex justify-content-between small text-secondary">
              <span>{{ number_format($tokenBalance) }} / {{ number_format($needed) }} tokens</span>
              @if($unlocked)
                <span class="text-success fw-semibold">Ready</span>
              @endif
            </div>

            {{-- Spacer to push any future actions to bottom --}}
            <div class="mt-auto"></div>
          </div>
        </div>
      </div>
    @endforeach
  </div>
@endsection
