@extends($activeTemplate.'layouts.master')

@section('content')
  <div class="d-flex justify-content-between align-items-center flex-wrap gap-2 mb-4">
    <h3 class="mb-0">Team Members</h3>
    <nav style="--bs-breadcrumb-divider: '>';" aria-label="breadcrumb">
      <ol class="breadcrumb align-items-center mb-0 lh-1">
        <li class="breadcrumb-item">
          <a href="#" class="d-flex align-items-center text-decoration-none">
            <i class="ri-home-4-line fs-18 text-primary me-1"></i>
            <span class="text-secondary fw-medium hover">Dashboard</span>
          </a>
        </li>
        <li class="breadcrumb-item active"><span class="fw-medium">User</span></li>
        <li class="breadcrumb-item active"><span class="fw-medium">Team Members</span></li>
      </ol>
    </nav>
  </div>
  
  
   <div class="row">
    <div class="col-md-12">
      <div class="card bg-white border-0 rounded-3 mb-4">
        <div class="card-body p-4">
          @if ( $auth->referrer)
            <h4 class="fs-18 mb-4">@lang('You are referred by') {{  $auth->referrer->fullname }}</h4>
         @else
               <h4 class="fs-18 mb-4">Referral Link</h4>
          @endif

 
          <div class="form-group position-relative">
            <input type="text"
                   class="form-control h-55 bg-body-bg border-0 text-dark rounded-pill referralURL"
                   value="{{ route('home') }}?reference={{  $auth->username }}"
                   readonly>
            <button type="button"
                    id="copyBoard"
                    class="position-absolute top-50 end-0 translate-middle-y bg-primary p-0 border-0 text-center text-white rounded-pill px-3 py-2 me-2 fw-semibold">
              Copy
            </button>
          </div>
        </div>
      </div>
    </div>
  </div>
  
  

  @php
    $general        = gs() ?? (object)['cur_sym' => '$'];
    $currency       = $general->cur_sym ?? '$';
    $fallbackAvatar = asset('assets/user/images/user-60.jpg');
    $levelKeys      = array_keys($levels ?? []);
    $initialLevel   = $levelKeys[0] ?? null;
  @endphp

  @if (empty($levels))
    <div class="alert alert-info mb-0">@lang('You do not have any team members yet.')</div>
  @else
    {{-- LEVEL PICKER --}}
    <div class="d-flex justify-content-center flex-wrap gap-2 mb-4" id="levelPicker">
      @foreach ($levelKeys as $lk)
        <button
          type="button"
          class="btn {{ $loop->first ? 'btn-primary' : 'btn-outline-primary' }} py-2 px-3 fw-medium level-btn"
          data-level="{{ $lk }}">
          Level {{ $lk }}
          <span class="badge bg-primary bg-opacity-10 text-primary ms-2">
            {{ $levels[$lk]->count() }}
          </span>
        </button>
      @endforeach
    </div>

    {{-- SEARCH + META --}}
    <div class="card bg-white border-0 rounded-3 mb-3">
      <div class="card-body p-4">
        <div class="row g-2 align-items-center">
          <div class="col-md-6">
            <div class="position-relative">
              <input id="teamSearch" type="text" class="form-control " placeholder="Search any level by username, name or email…">
              <i class="material-symbols-outlined position-absolute top-50 start-0 translate-middle-y ms-2">search</i>
            </div>
          </div>
          <div class="col-md-6 text-md-end">
            <span id="resultMeta" class="text-secondary small"></span>
          </div>
        </div>
      </div>
    </div>

    {{-- LEVEL PANELS (default view) --}}
    <div id="levelsContainer">
      @foreach ($levels as $level => $members)
        <div class="level-panel {{ $level === $initialLevel ? '' : 'd-none' }}" data-level="{{ $level }}">
          <div class="row justify-content-start gy-4 mb-4">
            @forelse ($members as $member)
              @php
                $fullName = trim(($member->firstname ? $member->firstname : '') . ' ' . ($member->lastname ? $member->lastname : '')) ?: $member->username;
                $joined   = optional($member->created_at)->format('d M Y');
                 $avatar = getImage(
                                getFilePath('userProfile') . '/' . ($member->profile_pic ?? 'default.png'),
                                getFileSize('userProfile')
                            );

                $totalReferrals  = $member->referrals_count ?? 0;
                $totalInvestment = number_format((float) ($member->invests_sum_amount ?? 0), 2);
              @endphp

              <div class="col-xxl-3 col-lg-4 col-sm-6 member-col">
                <div class="card bg-white border-0 rounded-3 mb-4 h-100 member-card"
                     data-level="{{ $level }}"
                     data-username="{{ strtolower($member->username) }}"
                     data-name="{{ strtolower($fullName) }}"
                     data-email="{{ strtolower($member->email) }}">
                  <div class="card-body p-4">
                    <div class="d-flex justify-content-between align-items-center mb-3">
                      <div class="d-flex align-items-center">
                        <div class="flex-shrink-0">
                          <img src="{{ $avatar }}" class="wh-65 rounded-circle border border-2" alt="user">
                        </div>
                        <div class="flex-grow-1 ms-2 position-relative top-2">
                          <h4 class="fs-16 fw-semibold mb-1">{{ $fullName }}</h4>
                          <span class="text-secondary">{{ '@'.$member->username }}</span>
                        </div>
                      </div>

                     
                    </div>

                    <div class="d-flex align-items-center mb-2 pb-1">
                      <span class="text-secondary">@lang('Joined Date'):</span>
                      <span class="ms-1">{{ $joined }}</span>
                    </div>

                    <div class="d-flex align-items-center mb-2 pb-1">
                      <span class="text-secondary">@lang('Level'):</span>
                      <span class="ms-1">{{ $level }}</span>
                    </div>

                    <div class="d-flex align-items-center mb-2 pb-1">
                      <span class="text-secondary">@lang('Email'):</span>
                      <span class="ms-1">{{ $member->email }}</span>
                    </div>

                    <div class="d-flex align-items-center mb-2 pb-1">
                      <span class="text-secondary">@lang('Total Referral'):</span>
                      <span class="ms-1">{{ $totalReferrals }}</span>
                    </div>

                    <div class="d-flex align-items-center mb-0">
                      <span class="text-secondary">@lang('Total Token'):</span>
                      <span class="ms-1">{{ $currency }}{{ $totalInvestment }}</span>
                    </div>
                  </div>
                </div>
              </div>
            @empty
              <div class="col-12">
                  <div class="alert alert-primary bg-primary text-white" role="alert">
                        No members at this level.!
                    </div>

                
              </div>
            @endforelse
          </div>
        </div>
      @endforeach
    </div>

    {{-- SEARCH RESULTS (appears when typing; aggregated across ALL levels) --}}
    <div id="searchPanel" class="d-none">
      <div class="d-flex justify-content-between align-items-center mt-2 mb-3">
        <h5 class="mb-0">Search Results</h5>
        <span class="text-secondary small" id="searchMeta"></span>
      </div>
      <div id="searchGrid" class="row justify-content-start gy-4 mb-4"></div>
      <div id="searchEmpty" class="alert alert-primary bg-primary text-white d-none">No matches found.</div>
    </div>
  @endif
@endsection

@push('style')
<style>
  #levelPicker .btn { min-width: 110px; }
  .member-card.hide { display: none !important; }
  .level-badge {
    font-size: 11px;
    line-height: 1;
    padding: 4px 8px;
    border-radius: 999px;
    background: #EEF6FF;
    color: #2563eb;
    margin-left: .5rem;
    white-space: nowrap;
  }
</style>
@endpush

@push('script')
<script>
document.addEventListener('DOMContentLoaded', function () {
  const picker      = document.getElementById('levelPicker');
  const panels      = document.querySelectorAll('.level-panel');
  const searchBox   = document.getElementById('teamSearch');
  const resultMeta  = document.getElementById('resultMeta');

  const searchPanel = document.getElementById('searchPanel');
  const searchGrid  = document.getElementById('searchGrid');
  const searchMeta  = document.getElementById('searchMeta');
  const searchEmpty = document.getElementById('searchEmpty');

  // ---- helpers
  function show(el)   { el?.classList.remove('d-none'); }
  function hide(el)   { el?.classList.add('d-none'); }
  function isShown(el){ return el && !el.classList.contains('d-none'); }

  function activePanel() {
    return Array.from(panels).find(p => !p.classList.contains('d-none'));
  }

  function updateLevelMeta() {
    const panel = activePanel();
    if (!panel || !resultMeta) return;
    const cards = panel.querySelectorAll('.member-card');
    resultMeta.textContent = `Showing ${cards.length} members in Level ${panel.dataset.level}`;
  }

  function showLevel(level) {
    // toggle buttons
    document.querySelectorAll('.level-btn').forEach(b=>{
      const on = b.dataset.level === String(level);
      b.classList.toggle('btn-primary', on);
      b.classList.toggle('btn-outline-primary', !on);
    });
    // panels
    panels.forEach(p => p.classList.toggle('d-none', p.dataset.level !== String(level)));
    // ensure default view visible
    hide(searchPanel);
    show(document.getElementById('levelsContainer'));
    // clear search
    if (searchBox) searchBox.value = '';
    updateLevelMeta();
  }

  // Build a lightweight index of all cards across all levels (for fast search)
  const ALL_CARDS = Array.from(document.querySelectorAll('.member-card')).map(card => {
    return {
      node: card,
      level: card.dataset.level || '',
      username: (card.dataset.username || '').toLowerCase(),
      name:     (card.dataset.name     || '').toLowerCase(),
      email:    (card.dataset.email    || '').toLowerCase()
    };
  });

  function renderSearchResults(matches) {
    // switch view to Search mode
    hide(document.getElementById('levelsContainer'));
    show(searchPanel);

    // clear grid
    searchGrid.innerHTML = '';
    if (!matches.length) {
      show(searchEmpty);
      searchMeta.textContent = '0 results';
      return;
    }
    hide(searchEmpty);

    // append clones with Level badge
    matches.forEach(m => {
      const col = document.createElement('div');
      col.className = 'col-xxl-3 col-lg-4 col-sm-6';

      const clone = m.node.cloneNode(true);
      // inject Level badge next to username/name header area
      const header = clone.querySelector('.fs-16.fw-semibold');
      if (header) {
        const badge = document.createElement('span');
        badge.className = 'level-badge';
        badge.textContent = `Level ${m.level}`;
        header.after(badge);
      }

      col.appendChild(clone);
      searchGrid.appendChild(col);
    });

    // meta
    searchMeta.textContent = `${matches.length} result${matches.length>1?'s':''} across all levels`;
    resultMeta.textContent = searchMeta.textContent; // mirror on the small meta line
  }

  function runSearch() {
    const q = (searchBox?.value || '').trim().toLowerCase();
    if (!q) {
      // back to default (selected level)
      show(document.getElementById('levelsContainer'));
      hide(searchPanel);
      updateLevelMeta();
      return;
    }
    // match across ALL levels
    const hits = ALL_CARDS.filter(c =>
      c.username.includes(q) || c.name.includes(q) || c.email.includes(q)
    );

    // sort by level (asc) then username
    hits.sort((a,b) => {
      if (a.level !== b.level) return Number(a.level) - Number(b.level);
      return a.username.localeCompare(b.username);
    });

    renderSearchResults(hits);
  }

  // bind: level picker
  picker?.addEventListener('click', (e) => {
    const btn = e.target.closest('.level-btn');
    if (!btn) return;
    showLevel(btn.dataset.level);
  });

  // bind: global search
  searchBox?.addEventListener('input', runSearch);

  // init
  const firstBtn = document.querySelector('.level-btn');
  if (firstBtn) showLevel(firstBtn.dataset.level);
});
</script>


<script>



  document.addEventListener('DOMContentLoaded', function () {

    // Copy referral link
    const btn   = document.getElementById('copyBoard');
    const input = document.querySelector('.referralURL');
    if (btn && input) {
      btn.addEventListener('click', async function () {
        try {
          await navigator.clipboard.writeText(input.value);
          const old = btn.textContent;
          btn.textContent = 'Copied!';
          setTimeout(()=> btn.textContent = old, 2000);
        } catch (e) {}
      });
    }
  });
</script>
@endpush
