@extends($activeTemplate . 'layouts.master')

@section('content')
  <div class="d-flex justify-content-between align-items-center flex-wrap gap-2 mb-4">
    <h3 class="mb-0">Team Reward</h3>
    <nav style="--bs-breadcrumb-divider: '>';" aria-label="breadcrumb">
      <ol class="breadcrumb align-items-center mb-0 lh-1">
        <li class="breadcrumb-item">
          <a href="{{ route('user.home') }}" class="d-flex align-items-center text-decoration-none">
            <i class="ri-home-4-line fs-18 text-primary me-1"></i>
            <span class="text-secondary fw-medium hover">Dashboard</span>
          </a>
        </li>
        <li class="breadcrumb-item active" aria-current="page">
          <span class="fw-medium">Team Reward</span>
        </li>
      </ol>
    </nav>
  </div>

  {{-- Quick summary --}}
  <div class="row g-3 mb-4">
    <div class="col-md-6 col-lg-4">
      <div class="card bg-white border-0 rounded-3 h-100">
        <div class="card-body p-4">
          <span class="text-secondary">Your Token Balance</span>
          <h3 class="mb-0 fs-20">{{ number_format((float)($user->token_balance ?? 0)) }} <span class="fs-14 text-muted">MGR</span></h3>
          <div class="mt-2 small text-secondary">Used for eligibility, while rank progress is based on team MGR.</div>
        </div>
      </div>
    </div>

    @php
      $completed = collect($rankCards)->where('completed', true)->count();
      $overallPct = count($rankCards) ? round($completed * 100 / count($rankCards)) : 0;
    @endphp
    <div class="col-md-6 col-lg-4">
      <div class="card bg-white border-0 rounded-3 h-100">
        <div class="card-body p-4">
          <span class="text-secondary">Ranks Achieved</span>
          <h3 class="mb-0 fs-20">{{ $completed }} / {{ count($rankCards) }}</h3>
          <div class="progress mt-2" role="progressbar" aria-valuenow="{{ $overallPct }}" aria-valuemin="0" aria-valuemax="100">
            <div class="progress-bar bg-success" style="width: {{ $overallPct }}%"></div>
          </div>
        </div>
      </div>
    </div>

    <div class="col-md-12 col-lg-4">
      <div class="card bg-white border-0 rounded-3 h-100">
        <div class="card-body p-4">
          <span class="text-secondary d-block">Total Team Balance</span>
          <h3 class="mb-0 fs-20">{{ number_format((float)$teamInvestTotal) }} <span class="fs-14 text-muted">MGR</span></h3>
          <div class="small text-secondary mt-2">Sum of all downline token balances (levels 1–8).</div>
        </div>
      </div>
    </div>
  </div>
  
  
  {{-- Per-level breakdown (new table design) --}}
<div class="card bg-white border-0 rounded-3 mb-4">
  <div class="card-body p-4">
    <div class="d-flex justify-content-between align-items-center flex-wrap gap-2 mb-lg-4 mb-3">
      <form class="position-relative table-src-form me-0">
        <input type="text" class="form-control" placeholder="Search level or value…"
               oninput="
                 const q=this.value.toLowerCase();
                 this.closest('.card').querySelectorAll('tbody tr[data-row]').forEach(tr=>{
                   tr.style.display = tr.textContent.toLowerCase().includes(q)?'':'none';
                 });
               ">
        <i class="material-symbols-outlined position-absolute top-50 start-0 translate-middle-y">search</i>
      </form>

      <span class="btn btn-outline-primary py-1 px-2 px-sm-4 fs-14 fw-medium rounded-3 hover-bg">
        <span class="py-sm-1 d-block">
          <i class="ri-pie-chart-2-line d-none d-sm-inline-block fs-18"></i>
          <span>Exact level totals (not cumulative)</span>
        </span>
      </span>
    </div>

    <div class="default-table-area all-products">
      <div class="table-responsive">
        <table class="table align-middle">
          <thead>
            <tr>
              <th scope="col">Level</th>
              <th scope="col" class="text-end">Members</th>
              <th scope="col" class="text-end">Team MGR</th>
              <th scope="col" class="text-end">Avg / Member</th>
              <th scope="col" class="text-center">Status</th>
            </tr>
          </thead>
          <tbody>
            @for($i=1;$i<=8;$i++)
              @php
                $members = (int)($levelCounts[$i] ?? 0);
                $mgr     = (float)($levelSums[$i] ?? 0);
                $avg     = $members ? $mgr / $members : 0;
                $status  = $members > 0 ? 'Active' : 'Empty';
                $badge   = $members > 0
                          ? 'bg-primary bg-opacity-10 text-primary'
                          : 'bg-danger bg-opacity-10 text-danger';
              @endphp
              <tr data-row>
                <td class="text-body">
                  <span class="badge bg-primary bg-opacity-10 text-primary">Lv {{ $i }}</span>
                </td>
                <td class="text-end text-secondary">{{ number_format($members) }}</td>
                <td class="text-end text-secondary">{{ number_format($mgr) }} MGR</td>
                <td class="text-end text-secondary">{{ number_format($avg) }} MGR</td>
                <td class="text-center">
                  <span class="badge {{ $badge }} p-2 fs-12 fw-normal">{{ $status }}</span>
                </td>
               
              </tr>
            @endfor

            <tr class="table-light">
              <td class="fw-semibold">Total</td>
              <td class="text-end fw-semibold">{{ number_format(array_sum($levelCounts)) }}</td>
              <td class="text-end fw-semibold">{{ number_format((float)$teamInvestTotal) }} MGR</td>
              <td class="text-end text-secondary">—</td>
              <td class="text-center">
                <span class="badge bg-success bg-opacity-10 text-success p-2 fs-12 fw-normal">Summary</span>
              </td>
              <td class="text-center">—</td>
            </tr>
          </tbody>
        </table>
      </div>

      <div class="d-flex justify-content-center justify-content-sm-between align-items-center text-center flex-wrap gap-2 showing-wrap">
        <span class="fs-13 fw-medium">
          Levels: 1–8 • Team Total: <b>{{ number_format((float)$teamInvestTotal) }} MGR</b>
        </span>

        <div class="d-flex align-items-center">
          <span class="fs-13 fw-medium me-2">{{ number_format(array_sum($levelCounts)) }} members in team</span>
          <nav aria-label="pagination-placeholder">
            <ul class="pagination mb-0 justify-content-center">
              <li class="page-item">
                <a class="page-link icon" href="javascript:void(0)" aria-label="Previous">
                  <i class="material-symbols-outlined">keyboard_arrow_left</i>
                </a>
              </li>
              <li class="page-item">
                <a class="page-link icon" href="javascript:void(0)" aria-label="Next">
                  <i class="material-symbols-outlined">keyboard_arrow_right</i>
                </a>
              </li>
            </ul>
          </nav>
        </div>
      </div>
      
    </div>
  </div>
</div>




  {{-- Rank progress cards --}}
  <div class="row g-3 mb-4 gy-3">
    @forelse($rankCards as $r)
      @php
        $barClass = $r['completed'] ? 'bg-success'
                 : ($r['progress'] > 0 ? 'bg-warning text-dark' : 'bg-danger');
        $statusText = $r['completed'] ? 'Completed' : ($r['progress'] > 0 ? 'In Progress' : 'Locked');
        $statusBadgeClass = $r['completed'] ? 'bg-success bg-opacity-10 text-success'
                             : ($r['progress'] > 0 ? 'bg-warning bg-opacity-10 text-warning'
                                                   : 'bg-danger bg-opacity-10 text-danger');
      @endphp
      <div class="col-xxl-3 col-lg-4 col-sm-6">
        <div class="card bg-white border-0 rounded-3 h-100">
          <div class="card-body p-4 d-flex flex-column">
            <div class="d-flex justify-content-between align-items-center mb-2">
              <div>
                <h4 class="fs-16 fw-semibold mb-0">{{ $r['name'] ?? ('Rank #' . $r['level']) }}</h4>
                <div class="small text-secondary">Required: {{ number_format($r['required']) }} MGR team</div>
              </div>
              <span class="badge {{ $statusBadgeClass }} p-2 fs-12 fw-normal">{{ $statusText }}</span>
            </div>

            <div class="row g-2 mb-2">
              <div class="col-12">
                <div class="small text-secondary">Bonus (TOKEN)</div>
                <h6 class="mb-0">MGR {{ number_format($r['bonus_token'], 0) }}</h6>
              </div>
              <!-- 
              <div class="col-6">
                <div class="small text-secondary">Bonus (USD)</div>
                <h6 class="mb-0">$ {{ number_format($r['bonus_usd'], 2) }}</h6>
              </div>
              -->
            </div>

            <div class="progress mb-1" role="progressbar" aria-valuenow="{{ $r['progress'] }}" aria-valuemin="0" aria-valuemax="100">
              <div class="progress-bar progress-bar-striped progress-bar-animated {{ $barClass }}" style="width: {{ $r['progress'] }}%">
                {{ $r['progress'] }}%
              </div>
            </div>
            <div class="d-flex justify-content-between small text-secondary">
              <span>{{ number_format($r['current']) }} / {{ number_format($r['required']) }} MGR</span>
              @if($r['completed'])
                <span class="text-success fw-semibold">Achieved</span>
              @endif
            </div>

            <div class="mt-auto"></div>
          </div>
        </div>
      </div>
    @empty
      <div class="col-12">
        <div class="card bg-white border-0 rounded-3">
          <div class="card-body p-4 text-center text-secondary">
            No ranking rules configured yet.
          </div>
        </div>
      </div>
    @endforelse
  </div>
@endsection
