@extends($activeTemplate . 'layouts.master')

@section('content')
    {{-- Page header + breadcrumb --}}
    <div class="d-flex justify-content-between align-items-center flex-wrap gap-2 mb-4">
        <h3 class="mb-0">@lang('Transactions')</h3>

        <nav style="--bs-breadcrumb-divider: '>';" aria-label="breadcrumb">
            <ol class="breadcrumb align-items-center mb-0 lh-1">
                <li class="breadcrumb-item">
                    <a href="{{ route('user.home') }}" class="d-flex align-items-center text-decoration-none">
                        <i class="ri-home-4-line fs-18 text-primary me-1"></i>
                        <span class="text-secondary fw-medium hover">@lang('Dashboard')</span>
                    </a>
                </li>
                <li class="breadcrumb-item active" aria-current="page">
                    <span class="fw-medium">@lang('Wallet')</span>
                </li>
                <li class="breadcrumb-item active" aria-current="page">
                    <span class="fw-medium">@lang('Transactions')</span>
                </li>
            </ol>
        </nav>
    </div>

    {{-- Table card --}}
    <div class="card bg-white border-0 rounded-3 mb-4">
        <div class="card-body p-4">
            <div class="d-flex justify-content-between align-items-center flex-wrap gap-3 mb-4">
                <h3 class="mb-0">@lang('Transaction List')</h3>

                {{-- Optional quick filter (kept simple; remove if not needed) --}}
                <form method="GET" class="d-flex align-items-center gap-2">
                    <select name="wallet_type" class="form-select form-control p-0 h-auto border-0 w-90"
                            style="background-position: right 0 center;">
                        <option value="">@lang('All Wallets')</option>
                        <option value="token_balance" @selected(request()->wallet_type == 'token_balance')>@lang('Token Wallet')</option>
                        <option value="referral_walltet" @selected(request()->wallet_type == 'referral_walltet')>@lang('ROI Wallet')</option>
                    </select>
                    <select name="trx_type" class="form-select form-control p-0 h-auto border-0 w-90"
                            style="background-position: right 0 center;">
                        <option value="">@lang('All Types')</option>
                        <option value="+" @selected(request()->trx_type == '+')>@lang('Plus')</option>
                        <option value="-" @selected(request()->trx_type == '-')>@lang('Minus')</option>
                    </select>
                    <button class="btn btn-primary btn-sm">@lang('Apply')</button>
                </form>
            </div>

            <div class="default-table-area all-products">
                <div class="table-responsive">
                    <table class="table align-middle" id="transactionsTable">
                        <thead>
                            <tr>
                                <th scope="col">@lang('Trx')</th>
                                <th scope="col">@lang('Transacted')</th>
                                <th scope="col">@lang('Amount')</th>
                                <th scope="col">@lang('Post Balance')</th>
                                <th scope="col">@lang('Wallet Type')</th>
                                <th scope="col">@lang('Detail')</th>
                            </tr>
                        </thead>
                        <tbody>
                            @forelse($transactions as $trx)
                                <tr>
                                    {{-- Trx --}}
                                    <td class="text-body">
                                        @php
                                            $tx = $trx->trx ?? null;
                                            $txShort = $tx ? substr($tx, 0, 10) . '…' . substr($tx, -6) : '-';
                                            $isMgrPurchase = isset($trx->remark) && $trx->remark === 'mgr_purchase';
                                        @endphp
                                    
                                        @if($tx && $isMgrPurchase)
                                            <a href="https://polygonscan.com/tx/{{ $tx }}" target="_blank" rel="noopener"
                                               class="fw-semibold text-primary" title="{{ $tx }}">
                                                {{ $txShort }}
                                                <i class="material-symbols-outlined align-middle ms-1" style="font-size:14px;">open_in_new</i>
                                            </a>
                                        @else
                                            <span class="fw-semibold" title="{{ $tx }}">{{ $txShort }}</span>
                                        @endif
                                    </td>



                                    {{-- Transacted --}}
                                    <td class="text-secondary">
                                        {{ showDateTime($trx->created_at) }} <br>
                                        <small class="text-muted">{{ diffForHumans($trx->created_at) }}</small>
                                    </td>

                                    {{-- Amount (+ / -) --}}
                                    <td>
                                        <span class="fw-bold {{ $trx->trx_type == '+' ? 'text-success' : 'text-danger' }}">
                                            {{ $trx->trx_type }} {{ showAmount($trx->amount) }} {{ __($general->cur_text) }}
                                        </span>
                                    </td>

                                    {{-- Post Balance --}}
                                    <td class="text-secondary">
                                        {{ showAmount($trx->post_balance) }} {{ __($general->cur_text) }}
                                    </td>

                                    {{-- Wallet Type --}}
                                    <td>
                                        @if ($trx->wallet_type == 'referral_walltet')
                                            <span class="badge bg-info">@lang('ROI Wallet')</span>
                                        @else
                                            <span class="badge bg-primary">@lang('Token Wallet')</span>
                                        @endif
                                    </td>

                                    {{-- Detail --}}
                                    <td class="text-secondary">
                                        {{ __($trx->details) }}
                                    </td>
                                </tr>
                            @empty
                                <tr>
                                    <td colspan="6" class="text-center text-muted py-4">
                                        {{ __($emptyMessage ?? 'No transactions found') }}
                                    </td>
                                </tr>
                            @endforelse
                        </tbody>
                    </table>
                </div>

                {{-- Pagination --}}
                @if ($transactions->hasPages())
                    <div class="mt-3">
                        {{ paginateLinks($transactions) }}
                    </div>
                @endif
            </div>
        </div>
    </div>
@endsection
