<!doctype html>
<html lang="en">
<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1">
 <title>Meghron - {{ __($pageTitle) }}</title>
  <meta name="title" Content="Meghron - {{ __($pageTitle) }}">
  <link rel="shortcut icon" href="{{ getImage(getFilePath('logoIcon') . '/favicon.png') }}" type="image/x-icon">
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">

  <style>
    body {
      background: #0b0f3b; /* same dark background */
    }

    .page-wrap {
      min-height: 100vh;
      display: flex;
      align-items: center;
      justify-content: center;
      padding: 24px;
    }

    .form-card {
      width: 100%;
      max-width: 900px;
      background: #fff;
      border-radius: 12px;
      box-shadow: 0 8px 30px rgba(0,0,0,.12);
      padding: 36px 28px;
    }

    @media (min-width:768px) {
      .form-card { padding: 44px 40px; }
    }

    .form-title {
      color: #0b0f3b;
      font-weight: 800;
      margin-bottom: 24px;
    }

    .form-control {
      background: #fff !important;
      color: #0f172a !important;
      border: 2px solid #1f3d9d !important;
      border-radius: 10px !important;
      padding: 14px 16px !important;
      height: auto;
    }
    .form-control::placeholder {
      color: #334155;
      opacity: 1;
    }
    .form-control:focus {
      box-shadow: 0 0 0 .2rem rgba(13,110,253,.15);
      border-color: #1f3d9d !important;
    }

    .btn-submit {
      background: #0d6efd;
      border: none;
      color: #fff;
      font-weight: 700;
      padding: 16px 28px;
      border-radius: 9999px; /* pill */
      transition: transform .06s ease, background .2s ease;
    }
    .btn-submit:hover { background: #1e90ff; }
    .btn-submit:active { transform: scale(.98); }
  </style>
</head>
<body>

<div class="page-wrap">
  <div class="form-card text-center">

    <!-- Logo -->
    <a href="{{ route('home') }}" class="d-inline-block mb-3">
      <img src="{{ asset($activeTemplateTrue . 'images/logo-two.png') }}" 
           alt="Logo" 
           style="max-height:60px;">
    </a>

    <h2 class="form-title">@lang('User Information')</h2>

    <form method="POST" action="{{ route('user.data.submit') }}">
      @csrf
      <div class="row g-4">
        <div class="col-md-6">
          <input class="form-control" type="text" name="firstname" value="{{ old('firstname') }}" required placeholder="First Name">
        </div>
        <div class="col-md-6">
          <input class="form-control" type="text" name="lastname" value="{{ old('lastname') }}" required placeholder="Last Name">
        </div>
        
        <!-- 
        <div class="col-md-12">
          <input class="form-control" type="text" name="phone" value="{{ old('phone') }}" placeholder="Phone">
        </div>
        <div class="col-md-12">
          <input class="form-control" type="email" name="email" value="{{ old('email') }}" placeholder="Email">
        </div>
        -->
        
        <div class="col-md-12">
              <input class="form-control" type="text" name="reference" value="{{ session()->get('reference') }}" placeholder="Invite Code">
        </div>
             
      </div>

      <div class="mt-4">
        <button class="btn btn-submit w-100" type="submit">@lang('Submit')</button>
      </div>
    </form>
  </div>
</div>

<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>
