<?php $__env->startSection('panel'); ?>
    <div class="row">
        <div class="col-xxl-3 col-sm-6 mb-30">
            <div class="widget-two box--shadow2 has-link b-radius--5 bg--info">
                <a href="<?php echo e(route('admin.deposit.rejected')); ?>" class="item-link"></a>
                <div class="widget-two__content">
                    <h2 class="text-white"><?php echo e($totalInvestCount); ?></h2>
                    <p class="text-white"><?php echo app('translator')->get('Total Invest Count'); ?></p>
                </div>
            </div><!-- widget-two end -->
        </div>
        <div class="col-xxl-3 col-sm-6 mb-30">
            <div class="widget-two box--shadow2 b-radius--5 bg--success has-link">
                <a href="<?php echo e(route('admin.deposit.successful')); ?>" class="item-link"></a>
                <div class="widget-two__content">
                    <h2 class="text-white"><?php echo e(__($general->cur_sym)); ?><?php echo e(showAmount($totalInvestAmount)); ?></h2>
                    <p class="text-white"><?php echo app('translator')->get('Total Invest'); ?></p>
                </div>
            </div><!-- widget-two end -->
        </div>
        <div class="col-xxl-3 col-sm-6 mb-30">
            <div class="widget-two box--shadow2 b-radius--5 bg--6 has-link">
                <a href="<?php echo e(route('admin.deposit.pending')); ?>" class="item-link"></a>
                <div class="widget-two__content">
                    <h2 class="text-white"><?php echo e(__($general->cur_sym)); ?><?php echo e(showAmount($totalPaid)); ?></h2>
                    <p class="text-white"><?php echo app('translator')->get('Total Paid'); ?></p>
                </div>
            </div><!-- widget-two end -->
        </div>
        <div class="col-xxl-3 col-sm-6 mb-30">
            <div class="widget-two box--shadow2 has-link b-radius--5 bg--dark">
                <a href="<?php echo e(route('admin.deposit.initiated')); ?>" class="item-link"></a>
                <div class="widget-two__content">
                    <h2 class="text-white"><?php echo e(__($general->cur_sym)); ?><?php echo e(showAmount($shouldPay)); ?></h2>
                    <p class="text-white"><?php echo app('translator')->get('To Pay'); ?> (<small><?php echo app('translator')->get('Without lifetime plan invest'); ?></small>)</p>
                </div>
            </div><!-- widget-two end -->
        </div>

        <div class="col-lg-12">
            <div class="show-filter mb-3 text-end">
                <button type="button" class="btn btn-outline--primary showFilterBtn btn-sm"><i class="las la-filter"></i> <?php echo app('translator')->get('Filter'); ?></button>
            </div>
            <div class="card responsive-filter-card mb-4">
                <div class="card-body">
                    <form action="">
                        <div class="d-flex flex-wrap gap-4">
                            <div class="flex-grow-1">
                                <label><?php echo app('translator')->get('Plan/Username'); ?></label>
                                <input type="text" name="search" value="<?php echo e(request()->search); ?>" class="form-control">
                            </div>
                            <div class="flex-grow-1">
                                <label><?php echo app('translator')->get('Return Type'); ?></label>
                                <select name="type" class="form-control">
                                    <option value=""><?php echo app('translator')->get('All'); ?></option>
                                    <option value="repeat" <?php if(request()->type == 'repeat'): echo 'selected'; endif; ?>><?php echo app('translator')->get('Repeat'); ?></option>
                                    <option value="lifetime" <?php if(request()->type == 'lifetime'): echo 'selected'; endif; ?>><?php echo app('translator')->get('Lifetime'); ?></option>
                                </select>
                            </div>

                            <div class="flex-grow-1">
                                <label><?php echo app('translator')->get('Status'); ?></label>
                                <select name="status" class="form-control">
                                    <option value=""><?php echo app('translator')->get('All'); ?></option>
                                    <option value="1" <?php if(request()->status == '1'): echo 'selected'; endif; ?>><?php echo app('translator')->get('Running'); ?></option>
                                    <option value="0" <?php if(request()->status == '0'): echo 'selected'; endif; ?>><?php echo app('translator')->get('Closed'); ?></option>
                                </select>
                            </div>

                            <div class="flex-grow-1">
                                <label><?php echo app('translator')->get('Date'); ?></label>
                                <input name="date" type="text" data-range="true" data-multiple-dates-separator=" - " data-language="en" class="datepicker-here form-control" data-position='bottom right' placeholder="<?php echo app('translator')->get('Start date - End date'); ?>" autocomplete="off" value="<?php echo e(request()->date); ?>">
                            </div>
                            <div class="flex-grow-1 align-self-end">
                                <button class="btn btn--primary w-100 h-45"><i class="fas fa-filter"></i> <?php echo app('translator')->get('Filter'); ?></button>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
            <div class="card b-radius--10 ">
                <div class="card-body p-0">
                    <div class="table-responsive--sm table-responsive">
                        <table class="table table--light style--two">
                            <thead>
                                <tr>
                                    <th><?php echo app('translator')->get('User'); ?></th>
                                    <th><?php echo app('translator')->get('Plan Name'); ?></th>
                                    <th><?php echo app('translator')->get('Amount'); ?></th>
                                    <th><?php echo app('translator')->get('Interest'); ?></th>
                                    <th><?php echo app('translator')->get('To Pay'); ?></th>
                                    <th><?php echo app('translator')->get('Paid'); ?></th>
                                    <th><?php echo app('translator')->get('Status'); ?></th>
                                    <th><?php echo app('translator')->get('Action'); ?></th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php $__empty_1 = true; $__currentLoopData = $invests; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $invest): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                    <tr>
                                        <td>
                                            <span class="fw-bold"><?php echo e($invest->user->fullname); ?></span>
                                            <br>
                                            <span class="small"> <a href="<?php echo e(appendQuery('search', $invest->user->username)); ?>"><span>@</span><?php echo e($invest->user->username); ?></a> </span>
                                        </td>

                                        <td><?php echo e(__($invest->plan->name)); ?></td>
                                        <td><?php echo e($general->cur_sym); ?><?php echo e(showAmount($invest->amount)); ?></td>
                                        <td><?php echo e($general->cur_sym); ?><?php echo e(showAmount($invest->interest)); ?></td>
                                        <td><?php echo e($invest->should_pay != -1 ? $general->cur_sym . showAmount($invest->should_pay) : '**'); ?></td>
                                        <td><?php echo e($general->cur_sym); ?><?php echo e(showAmount($invest->paid)); ?></td>
                                        <td>
                                            <?php if($invest->status == 1): ?>
                                                <span class="badge badge--success"><?php echo app('translator')->get('Running'); ?></span>
                                            <?php else: ?>
                                                <span class="badge badge--dark"><?php echo app('translator')->get('Closed'); ?></span>
                                            <?php endif; ?>
                                        </td>
                                        <td>
                                            <a href="<?php echo e(route('admin.report.invest.details', $invest->id)); ?>" class="btn btn-outline--primary btn-sm"><i class="las la-desktop"></i><?php echo app('translator')->get('Details'); ?></a>
                                        </td>
                                    </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                    <tr>
                                        <td class="text-muted text-center" colspan="100%"><?php echo e(__($emptyMessage)); ?></td>
                                    </tr>
                                <?php endif; ?>
                            </tbody>
                        </table><!-- table end -->
                    </div>
                </div>
                <?php if($invests->hasPages()): ?>
                    <div class="card-footer py-4">
                        <?php echo e(paginateLinks($invests)); ?>

                    </div>
                <?php endif; ?>
            </div><!-- card end -->
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('style-lib'); ?>
    <link rel="stylesheet" href="<?php echo e(asset('assets/admin/css/vendor/datepicker.min.css')); ?>">
<?php $__env->stopPush(); ?>

<?php $__env->startPush('script-lib'); ?>
    <script src="<?php echo e(asset('assets/admin/js/vendor/datepicker.min.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/admin/js/vendor/datepicker.en.js')); ?>"></script>
<?php $__env->stopPush(); ?>
<?php $__env->startPush('script'); ?>
    <script>
        (function($) {
            "use strict";
            if (!$('.datepicker-here').val()) {
                $('.datepicker-here').datepicker();
            }
        })(jQuery)
    </script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('admin.layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/meghvwkg/public_html/core/resources/views/admin/reports/invest_history.blade.php ENDPATH**/ ?>