<div class="row">
  <div class="col-xxl-12">
    <div class="card bg-white border-0 rounded-3 mb-4">
      <div class="card-body p-4">
        <div class="d-flex justify-content-between align-items-center flex-wrap gap-3 pb-3">
          <h3 class="mb-0">Live MGR Trades</h3>
          <!-- 
          <button id="resetLiveTx" class="btn btn-sm btn-outline-warning">Reset Live Trades Cache</button>
          -->
        </div>

        <div class="default-table-area style-two transaction-table">
          <div class="table-responsive">
            <table class="table align-middle border-0">
              <thead>
                <tr class="border-bottom">
                      <th scope="col" class="text-end bg-transparent ">Token</th>
                    <th scope="col" class="text-end bg-transparent ">Date</th>
                    <th scope="col" class="text-end bg-transparent">Amount</th>
                    <th scope="col" class="text-end bg-transparent">Price (POL/MGR)</th>
                    <th scope="col" class="text-end bg-transparent">Type</th>
                    <th scope="col" class="text-end bg-transparent pe-0">Total (POL)</th>
                </tr>
              </thead>
              <tbody id="liveTxBody"></tbody>
            </table>
          </div>

          <div class="d-flex justify-content-center justify-content-sm-between align-items-center text-center flex-wrap gap-2 showing-wrap mt-4">
            <span class="fs-12 fw-medium" id="liveTxShowing">Showing 0 of 0 Results</span>

            <nav aria-label="Page navigation example">
              <ul class="pagination mb-0 justify-content-center" id="liveTxPager">
                <!-- JS will populate -->
              </ul>
            </nav>
          </div>
        </div>
      </div>
    </div>
  </div>
</div>


<?php $__env->startPush('script'); ?>
<?php ($general = gs()); ?>
<script>
(function () {
  // ====== Endpoints ======
  const MARKET_URL = <?php echo json_encode(route('user.mgr.market'), 15, 512) ?>;
  const RECENT_URL = <?php echo json_encode(route('user.mgr.recent'), 15, 512) ?>; // <-- create this endpoint (see note below)

  // ====== Bootstrap config ======
  let FAKE_TRNS_MODE = <?php echo e((int)($general->fake_trns ?? 1)); ?>;      // 0 both, 1 buy-only, 2 sell-only
  let MGR_PER_POL    = <?php echo e((float)($general->mgr_amount ?? 162)); ?>; // 1 POL = X MGR
  let MIN_POL_TRADE  = <?php echo e((float)($general->min_trade ?? 0.01)); ?>;
  let MAX_POL_TRADE  = <?php echo e((float)($general->max_trade ?? 4188.00)); ?>;

  let POL_PER_MGR    = (MGR_PER_POL > 0) ? (1 / MGR_PER_POL) : 0;

  const COIN_ICON = "<?php echo e(asset($activeTemplateTrue . 'images/icon.png')); ?>";

  // ====== Cache keys (fake only) ======
  const CACHE_KEY_OLD_1 = 'mgr_live_tx_cache_v1';
  const CACHE_KEY_OLD_2 = 'mgr_live_tx_cache_v2';
  const CACHE_KEY       = 'mgr_live_tx_cache_v3';
  const CACHE_META_KEY  = 'mgr_live_tx_meta';

  // ====== Table settings ======
  const MAX_TX         = 30;
  const ROWS_PER_PAGE  = 7;
  const ADD_EVERY_MS   = 7000;
  const STAY_ON_PAGE_1 = true;

  // ====== DOM ======
  const tbody   = document.getElementById('liveTxBody');
  const showing = document.getElementById('liveTxShowing');
  const pager   = document.getElementById('liveTxPager');
  if (!tbody || !showing || !pager) return;

  // ====== Utils ======
  const pad = n => (n < 10 ? '0' : '') + n;
  const fmtDateTime = (d) => {
    const yy = d.getFullYear(), mm = pad(d.getMonth()+1), dd = pad(d.getDate());
    const hh = pad(d.getHours()), mi = pad(d.getMinutes()), ss = pad(d.getSeconds());
    return `${yy}-${mm}-${dd} ${hh}:${mi}:${ss}`;
  };
  const fmtMGR = (v) => Number(v||0).toLocaleString(undefined, { maximumFractionDigits: 2 }) + ' MGR';
  const fmtPOL = (v) => Number(v||0).toLocaleString(undefined, { minimumFractionDigits: 6, maximumFractionDigits: 6 }) + ' POL';
  const typeBadge = (t) =>
    `<span class="d-inline-block py-1 px-2 ${t==='Buy'?'bg-success bg-opacity-10 text-success':'bg-danger bg-opacity-10 text-danger'} rounded-2">${t}</span>`;

  function chooseType() {
    if (FAKE_TRNS_MODE === 1) return 'Buy';
    if (FAKE_TRNS_MODE === 2) return 'Sell';
    return Math.random() < 0.65 ? 'Buy' : 'Sell';
  }
  function clampRange(minVal, maxVal) {
    const min = Math.max(0, +minVal || 0);
    const max = Math.max(min, +maxVal || min);
    return [min, max];
  }

  // ====== Row shape ======
  // { id, ts(iso), pricePolPerMgr, amountMgr, totalPol, type, real:boolean }

  // ====== FAKE stream (cached) ======
  function genFakeTx() {
    const [minPol, maxPol] = clampRange(MIN_POL_TRADE, MAX_POL_TRADE);
    const pol  = minPol + Math.random() * (maxPol - minPol); // POL
    const mgr  = pol * MGR_PER_POL;                          // MGR
    const type = chooseType();
    return {
      id: `f_${Date.now()}_${Math.random().toString(36).slice(2)}`,
      ts: new Date().toISOString(),
      pricePolPerMgr: POL_PER_MGR,
      amountMgr: mgr,
      totalPol: pol,
      type,
      real: false
    };
  }

  function loadCache() {
    try { const raw = localStorage.getItem(CACHE_KEY); const arr = raw ? JSON.parse(raw) : []; return Array.isArray(arr) ? arr : []; }
    catch { return []; }
  }
  function saveCache(list) {
    try { localStorage.setItem(CACHE_KEY, JSON.stringify(list.slice(0, MAX_TX))); } catch {}
  }
  function loadMeta() {
    try { return JSON.parse(localStorage.getItem(CACHE_META_KEY) || '{}'); } catch { return {}; }
  }
  function saveMeta(meta) {
    try { localStorage.setItem(CACHE_META_KEY, JSON.stringify(meta)); } catch {}
  }

  try { localStorage.removeItem(CACHE_KEY_OLD_1); } catch {}
  try { localStorage.removeItem(CACHE_KEY_OLD_2); } catch {}

  // ====== State ======
  let REAL = [];          // <-- real 60s buys (not cached)
  let FAKE = loadCache(); // <-- cached fake stream
  let page = 1;

  // Reset cache if boot settings change
  (function initialResetCheck() {
    const meta = loadMeta();
    const needReset =
      meta.fakeMode !== FAKE_TRNS_MODE ||
      meta.mgrPerPol !== MGR_PER_POL   ||
      meta.unit      !== 'POL';

    if (needReset) {
      FAKE = [];
      saveCache(FAKE);
    } else {
      FAKE = FAKE.filter(t => {
        if (FAKE_TRNS_MODE === 1) return t.type === 'Buy';
        if (FAKE_TRNS_MODE === 2) return t.type === 'Sell';
        return true;
      });
    }
    saveMeta({ fakeMode: FAKE_TRNS_MODE, mgrPerPol: MGR_PER_POL, unit: 'POL' });
  })();

  // Seed fake if empty
  if (FAKE.length === 0) {
    for (let i = 0; i < 12; i++) {
      const tx = genFakeTx();
      tx.ts = new Date(Date.now() - i * 4 * 60 * 1000).toISOString();
      FAKE.unshift(tx);
    }
    FAKE = FAKE.slice(0, MAX_TX);
    saveCache(FAKE);
  }

  // ====== Real recent (last 60s) ======
  const seenReal = new Set(); // id de-dup (tx_hash preferred)

  function mapRealRow(r) {
    const iso = r.created_at || r.ts || r.time || new Date().toISOString();
    const id  = r.tx_hash || r.trx || `${iso}|${r.amount || r.mgr_amount}`;
    const mgr = Number(r.mgr_amount ?? r.amount ?? 0);
    const pol = (r.pol_amount != null) ? Number(r.pol_amount) : (MGR_PER_POL ? mgr / MGR_PER_POL : 0);

    return {
      id,
      ts: iso,
      pricePolPerMgr: POL_PER_MGR, // fake price shown
      amountMgr: mgr,
      totalPol: pol,
      type: 'Buy',                 // real purchases are buys
      real: true
    };
  }

  async function fetchRecentReal() {
    try {
      const res = await fetch(RECENT_URL, { cache: 'no-store' });
      const list = await res.json(); // expect array
      if (!Array.isArray(list)) return;

      const cutoff = Date.now() - 60 * 1000; // 60s
      const fresh  = list
        .map(mapRealRow)
        .filter(x => new Date(x.ts).getTime() >= cutoff);

      // merge (real first), dedupe by id
      let changed = false;
      for (const item of fresh) {
        if (seenReal.has(item.id)) continue;
        seenReal.add(item.id);
        REAL.unshift(item);
        changed = true;
      }

      // trim REAL to reasonable size (not too big)
      if (REAL.length > MAX_TX) REAL.length = MAX_TX;

      if (changed) renderTable();
    } catch (e) {
      // ignore network hiccups
    }
  }

  // ====== Rendering ======
  function renderPager(totalLen) {
    const pages = Math.max(1, Math.ceil(totalLen / ROWS_PER_PAGE));
    page = Math.max(1, Math.min(page, pages));
    const html = [];

    html.push(`
      <li class="page-item ${page===1?'disabled':''}">
        <a class="page-link icon" href="#" data-page="${page-1}" aria-label="Previous">
          <i class="material-symbols-outlined">keyboard_arrow_left</i>
        </a>
      </li>
    `);
    for (let i=1;i<=pages;i++){
      html.push(`<li class="page-item"><a class="page-link ${i===page?'active':''}" href="#" data-page="${i}">${i}</a></li>`);
    }
    html.push(`
      <li class="page-item ${page===pages?'disabled':''}">
        <a class="page-link icon" href="#" data-page="${page+1}" aria-label="Next">
          <i class="material-symbols-outlined">keyboard_arrow_right</i>
        </a>
      </li>
    `);

    pager.innerHTML = html.join('');
    pager.querySelectorAll('a.page-link').forEach(a=>{
      a.addEventListener('click', e=>{
        e.preventDefault();
        const to = Number(a.dataset.page);
        if (!isNaN(to)) { page = to; renderTable(); }
      });
    });
  }

  function renderTable() {
    // combine: REAL first (ts desc), then FAKE (ts desc)
    const realSorted = [...REAL].sort((a,b)=> new Date(b.ts) - new Date(a.ts));
    const fakeSorted = [...FAKE].sort((a,b)=> new Date(b.ts) - new Date(a.ts));
    const ALL = [...realSorted, ...fakeSorted].slice(0, MAX_TX);

    const pages = Math.max(1, Math.ceil(ALL.length / ROWS_PER_PAGE));
    page = Math.max(1, Math.min(page, pages));
    const start = (page-1) * ROWS_PER_PAGE;
    const slice = ALL.slice(start, start + ROWS_PER_PAGE);

    if (!slice.length) {
      tbody.innerHTML = `<tr><td colspan="6" class="text-center py-4">No transactions yet</td></tr>`;
    } else {
      tbody.innerHTML = slice.map(t => `
        <tr>
          <!-- Token -->
          <td class="text-end fw-medium ps-0">
            <div class="d-flex justify-content-end align-items-center gap-2">
              <img src="${COIN_ICON}" class="rounded-circle" style="width:22px;height:22px;" alt="MGR">
              <span>Meghron <span class="text-body">(MGR)</span></span>
            </div>
          </td>

          <!-- Date -->
          <td class="text-end fw-medium">${fmtDateTime(new Date(t.ts))}</td>

          <!-- Amount (MGR) -->
          <td class="text-end fw-medium">${fmtMGR(t.amountMgr)}</td>

          <!-- Price (POL/MGR)  — from config (fake) -->
          <td class="text-end fw-medium">${t.pricePolPerMgr.toFixed(6)} POL/MGR</td>

          <!-- Type -->
          <td class="text-end">${typeBadge(t.type)}</td>

          <!-- Total (POL) -->
          <td class="text-end fw-medium pe-0">${fmtPOL(t.totalPol)}</td>
        </tr>
      `).join('');
    }

    showing.textContent = `Showing ${slice.length} of ${ALL.length} Results`;
    renderPager(ALL.length);
  }

  // First paint
  renderTable();

  // ====== Fake live generator (respects mode) ======
  setInterval(() => {
    const tx = genFakeTx();
    if (FAKE_TRNS_MODE === 1 && tx.type !== 'Buy')  return;
    if (FAKE_TRNS_MODE === 2 && tx.type !== 'Sell') return;

    FAKE.unshift(tx);
    if (FAKE.length > MAX_TX) FAKE.length = MAX_TX;
    saveCache(FAKE);
    if (STAY_ON_PAGE_1) page = 1;
    renderTable();
  }, ADD_EVERY_MS);

  // ====== Pull server settings and recent real buys periodically ======
  async function refreshServerSettings(){
    try{
      const res = await fetch(MARKET_URL, { cache: 'no-store' });
      const j = await res.json();

      const newMode = Number(j.fake_trns ?? FAKE_TRNS_MODE);
      const newMgr  = Number(j.mgr_amount ?? MGR_PER_POL);
      const newMin  = Number(j.min_trade ?? MIN_POL_TRADE);
      const newMax  = Number(j.max_trade ?? MAX_POL_TRADE);

      let changed = false;

      if (!Number.isNaN(newMode) && newMode !== FAKE_TRNS_MODE) { FAKE_TRNS_MODE = newMode; changed = true; }
      if (newMgr && newMgr !== MGR_PER_POL) {
        MGR_PER_POL = newMgr;
        POL_PER_MGR = 1 / MGR_PER_POL;
        changed = true;
      }
      if (!isNaN(newMin)) MIN_POL_TRADE = newMin;
      if (!isNaN(newMax)) MAX_POL_TRADE = newMax;

      if (changed) {
        FAKE = [];
        saveCache(FAKE);
        for (let i = 0; i < 12; i++) {
          const tx = genFakeTx();
          tx.ts = new Date(Date.now() - i * 4 * 60 * 1000).toISOString();
          FAKE.unshift(tx);
        }
        FAKE = FAKE.slice(0, MAX_TX);
        saveCache(FAKE);
        saveMeta({ fakeMode: FAKE_TRNS_MODE, mgrPerPol: MGR_PER_POL, unit: 'POL' });
        renderTable();
      }
    }catch(e){ /* ignore */ }
  }

  // Kick off real-pull + settings pollers
  fetchRecentReal();                    // initial load
  setInterval(fetchRecentReal, 10_000); // refresh real every 10s
  refreshServerSettings();              // initial settings sync
  setInterval(refreshServerSettings, 30_000);

})();
</script>

<?php $__env->stopPush(); ?>



<?php /**PATH /home/meghvwkg/public_html/core/resources/views/templates/meghron/user/partials/fake_transaction.blade.php ENDPATH**/ ?>