<!DOCTYPE html>
<html lang="zxx">
    <head>
		<!-- Required meta tags -->
		<meta charset="utf-8">
		<meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
        <title> <?php echo e($general->siteName(__($pageTitle))); ?></title>
        <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">
         <?php echo $__env->make('partials.seo', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
   
		<!-- Links Of CSS File -->
		<link rel="stylesheet" href="<?php echo e(asset('assets/user/css/sidebar-menu.css')); ?>">
		<link rel="stylesheet" href="<?php echo e(asset('assets/user/css/simplebar.css')); ?>">
		<link rel="stylesheet" href="<?php echo e(asset('assets/user/css/apexcharts.css')); ?>">
		<link rel="stylesheet" href="<?php echo e(asset('assets/user/css/prism.css')); ?>">
		<link rel="stylesheet" href="<?php echo e(asset('assets/user/css/rangeslider.css')); ?>">
        <link rel="stylesheet" href="<?php echo e(asset('assets/user/css/quill.snow.css')); ?>">
        <link rel="stylesheet" href="<?php echo e(asset('assets/user/css/google-icon.css')); ?>">
        <link rel="stylesheet" href="<?php echo e(asset('assets/user/css/remixicon.css')); ?>">
        <link rel="stylesheet" href="<?php echo e(asset('assets/user/css/swiper-bundle.min.css')); ?>">
        <link rel="stylesheet" href="<?php echo e(asset('assets/user/css/fullcalendar.main.css')); ?>">
        <link rel="stylesheet" href="<?php echo e(asset('assets/user/css/jsvectormap.min.css')); ?>">
        <link rel="stylesheet" href="<?php echo e(asset('assets/user/css/lightpick.css')); ?>">
		<link rel="stylesheet" href="<?php echo e(asset('assets/user/css/style.css')); ?>">
		<style>
          /* Container styling (card-like, dark) */
          .cg-ticker{
            background:#0b0e13;
            border:1px solid #1f2937;
            border-radius:12px;
            overflow:hidden;
            padding:6px 0;
            width:100%;
          }
          .cg-ticker coingecko-coin-price-marquee-widget{
            display:block;   /* make the widget fill the container */
            width:100%;
          }
        </style>
         <?php echo $__env->yieldPushContent('style'); ?>
		

	
    </head>
    <body class="boxed-size">
        
          <?php
                 $user = auth()->user();
                
              ?>
              
              
        <!-- Start Preloader Area -->
         
        <!-- End Preloader Area -->

        <!-- Start Sidebar Area -->
        <?php echo $__env->make($activeTemplate . 'user.partials.sidebar', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
        <!-- End Sidebar Area -->

        <!-- Start Main Content Area -->
        <div class="container-fluid">
         
            <div class="main-content d-flex flex-column">
                <!-- Start Header Area -->
                <?php echo $__env->make($activeTemplate . 'user.partials.header', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
              

                <div class="main-content-container overflow-hidden">
                    
                    <?php echo $__env->yieldContent('content'); ?>
                 
                    
                    
                </div>

                <div class="flex-grow-1"></div>

                <!-- Start Footer Area -->
                <footer class="footer-area bg-white text-center rounded-top-7">
                    <p class="fs-14">© <span class="text-primary-div">Copyright © 2025 Meghron (MGR)</span></p>
                    <!-- 
                    <p class="fs-14">© <span class="text-primary-div">Meghron</span> is Develop by <a href="https://softvistait.com/" target="_blank" class="text-decoration-none text-primary">Softvista IT</a></p>
                    -->
                </footer>
                <!-- End Footer Area -->
            </div>
        </div>
        <!-- Start Main Content Area -->

        <!-- Start Create From Area -->
        <div class="offcanvas offcanvas-end" tabindex="-1" id="offcanvasRight" aria-labelledby="offcanvasRightLabel">
            <div class="offcanvas-header border-bottom p-4">
                <h5 class="offcanvas-title fs-18 mb-0" id="offcanvasRightLabel">Create Task</h5>
                <button type="button" class="btn-close" data-bs-dismiss="offcanvas" aria-label="Close"></button>
            </div>
            <div class="offcanvas-body p-4">
                <form>
                    <div class="form-group mb-4">
                        <label class="label">Task ID</label>
                        <input type="text" class="form-control text-dark" placeholder="Task ID">
                    </div>
                    <div class="form-group mb-4">
                        <label class="label">Task Title</label>
                        <input type="text" class="form-control text-dark" placeholder="Task Title">
                    </div>
                    <div class="form-group mb-4">
                        <label class="label">Assigned To</label>
                        <input type="text" class="form-control text-dark" placeholder="Assigned To">
                    </div>
                    <div class="form-group mb-4">
                        <label class="label">Due Date</label>
                        <input type="date" class="form-control text-dark">
                    </div>
                    <div class="form-group mb-4">
                        <label class="label">Priority</label>
                        <select class="form-select form-control text-dark" aria-label="Default select example">
                            <option selected>High</option>
                            <option value="1">Low</option>
                            <option value="2">Medium</option>
                        </select>
                    </div>
                    
                    <div class="form-group mb-4">
                        <label class="label">Status</label>
                        <select class="form-select form-control text-dark" aria-label="Default select example">
                            <option selected>Finished</option>
                            <option value="1">Pending</option>
                            <option value="2">In Progress</option>	 
                            <option value="3">Cancelled</option>
                        </select>
                    </div>

                    <div class="form-group mb-4">
                        <label class="label">Action</label>
                        <select class="form-select form-control text-dark" aria-label="Default select example">
                            <option selected>Yes</option>
                            <option value="1">No</option>
                        </select>
                    </div>
                    
                    <div class="form-group d-flex gap-3">
                        <button class="btn btn-primary text-white fw-semibold py-2 px-2 px-sm-3">
                            <span class="py-sm-1 d-block">
                                <i class="ri-add-line text-white"></i>
                                <span>Create Task</span>
                            </span>
                        </button>
                    </div>
                </form>
            </div>
        </div>
        <!-- End Create From Area -->

        <!-- Start Theme Setting Area -->

        <!-- End Theme Setting Area -->
     
        <script src="<?php echo e(asset('assets/global/js/web3.min.js')); ?>"></script>
        <!-- Link Of JS File -->
        
        <script src="<?php echo e(asset('assets/user/js/bootstrap.bundle.min.js')); ?>"></script>
        <script src="<?php echo e(asset('assets/user/js/sidebar-menu.js')); ?>"></script>
        <script src="<?php echo e(asset('assets/user/js/dragdrop.js')); ?>"></script>
        <script src="<?php echo e(asset('assets/user/js/rangeslider.min.js')); ?>"></script>
        <script src="<?php echo e(asset('assets/user/js/quill.min.js')); ?>"></script>
        <script src="<?php echo e(asset('assets/user/js/data-table.js')); ?>"></script>
        <script src="<?php echo e(asset('assets/user/js/prism.js')); ?>"></script>
        <script src="<?php echo e(asset('assets/user/js/clipboard.min.js')); ?>"></script>
        <script src="<?php echo e(asset('assets/user/js/feather.min.js')); ?>"></script>
        <script src="<?php echo e(asset('assets/user/js/simplebar.min.js')); ?>"></script>
        <script src="<?php echo e(asset('assets/user/js/apexcharts.min.js')); ?>"></script>
        <script src="<?php echo e(asset('assets/user/js/echarts.min.js')); ?>"></script>
        <script src="<?php echo e(asset('assets/user/js/swiper-bundle.min.js')); ?>"></script>
        <script src="<?php echo e(asset('assets/user/js/fullcalendar.main.js')); ?>"></script>
        <script src="<?php echo e(asset('assets/user/js/jsvectormap.min.js')); ?>"></script>
        <script src="<?php echo e(asset('assets/user/js/world-merc.js')); ?>"></script>
        <script src="<?php echo e(asset('assets/user/js/moment.min.js')); ?>"></script>
        <script src="<?php echo e(asset('assets/user/js/lightpick.js')); ?>"></script>
        <script src="<?php echo e(asset('assets/user/js/custom/apexcharts.js')); ?>"></script>
        <script src="<?php echo e(asset('assets/user/js/custom/echarts.js')); ?>"></script>
        <!-- CoinGecko Price Marquee (dark) -->
        <link rel="preconnect" href="https://widgets.coingecko.com">
        <script src="https://widgets.coingecko.com/coingecko-coin-price-marquee-widget.js"></script>
        <script src="<?php echo e(asset('assets/user/js/custom/custom.js')); ?>"></script>
        
        <?php echo $__env->yieldPushContent('script-lib'); ?>
        <?php echo $__env->yieldPushContent('script'); ?>
        <?php echo $__env->make('partials.notify', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    

    
    
        
        
        <script>
        (function(){
          const mcapEls = [document.getElementById('mcapVal'), document.getElementById('mgrMcap')];
          const liqEls  = [document.getElementById('vol24hVal'), document.getElementById('mgrLiq')];
        
          function usdAbbrFromStr(s){
            s = String(s ?? '0').replace(/[,\s]/g,'');
            const neg = s.startsWith('-') ? '-' : '';
            if (neg) s = s.slice(1);
            const [i, f='0'] = s.split('.');
            const i2 = i.replace(/^0+/, '') || '0';
            const len = i2.length;
            const mk = (k, suf) => {
              if (len <= k) return null;
              const head = i2.slice(0, len - k);
              const tail = i2.slice(len - k, len - k + 2);
              return '$' + (neg?'-':'') + head + (tail?'.'+tail:'') + suf;
            };
            return mk(12,'T') || mk(9,'B') || mk(6,'M') || mk(3,'k') || ('$' + Number((neg?'-':'')+i2 + (f?'.'+f:''))?.toFixed?.(2));
          }
        
          async function refreshMarket(){
            try{
              const res = await fetch(`<?php echo e(route('user.mgr.market')); ?>`, { cache: 'no-store' });
              const j = await res.json();
              const mcapTxt = usdAbbrFromStr(j.market_cap);
              const liqTxt  = usdAbbrFromStr(j.liquidity);
        
              mcapEls.forEach(el => el && (el.textContent = mcapTxt));
              liqEls.forEach(el => el && (el.textContent = liqTxt));
        
              // also mirror for anyone else
              window.MGR_MARKET = j;
            }catch(e){
              // silent fail
            }
          }
        
          // initial + periodic (e.g., every 30s)
          refreshMarket();
          setInterval(refreshMarket, 30000);
        })();
        </script>





    </body>
</html><?php /**PATH /home/meghvwkg/public_html/core/resources/views/templates/meghron/layouts/master.blade.php ENDPATH**/ ?>