

<?php $__env->startSection('content'); ?>
  <div class="d-flex justify-content-between align-items-center flex-wrap gap-2 mb-4">
    <h3 class="mb-0">Team Commission</h3>
    <nav style="--bs-breadcrumb-divider: '>';" aria-label="breadcrumb">
      <ol class="breadcrumb align-items-center mb-0 lh-1">
        <li class="breadcrumb-item">
          <a href="<?php echo e(route('user.home')); ?>" class="d-flex align-items-center text-decoration-none">
            <i class="ri-home-4-line fs-18 text-primary me-1"></i>
            <span class="text-secondary fw-medium hover">Dashboard</span>
          </a>
        </li>
        <li class="breadcrumb-item active" aria-current="page">
          <span class="fw-medium">Team Commission</span>
        </li>
      </ol>
    </nav>
  </div>

  
  <div class="row g-3 mb-4">
    <div class="col-md-6 col-lg-4">
      <div class="card bg-white border-0 rounded-3 h-100">
        <div class="card-body p-4">
          <span class="text-secondary">Your Token Balance</span>
          <h3 class="mb-0 fs-20"><?php echo e(number_format($tokenBalance)); ?></h3>
          <div class="mt-2 small text-secondary">
            Requirements —
            <strong>Lv 1–2:</strong> <?php echo e(number_format($requirements['1-2'])); ?>,
            <strong>Lv 3–5:</strong> <?php echo e(number_format($requirements['3-5'])); ?>,
            <strong>Lv 6–8:</strong> <?php echo e(number_format($requirements['6-8'])); ?> tokens
          </div>
        </div>
      </div>
    </div>

    <?php
      $completedLevels = 0;
      foreach ($levels as $lvl => $pct) {
          $need = $lvl <= 2 ? $requirements['1-2'] : ($lvl <= 5 ? $requirements['3-5'] : $requirements['6-8']);
          if ($tokenBalance >= $need) $completedLevels++;
      }
      $overallPct = round($completedLevels * 100 / max(1, count($levels)));
    ?>

    <div class="col-md-6 col-lg-4">
      <div class="card bg-white border-0 rounded-3 h-100">
        <div class="card-body p-4">
          <span class="text-secondary">Levels Unlocked</span>
          <h3 class="mb-0 fs-20"><?php echo e($completedLevels); ?> / <?php echo e(count($levels)); ?></h3>
          <div class="progress mt-2" role="progressbar" aria-valuenow="<?php echo e($overallPct); ?>" aria-valuemin="0" aria-valuemax="100">
            <div class="progress-bar bg-success" style="width: <?php echo e($overallPct); ?>%"></div>
          </div>
        </div>
      </div>
    </div>
  </div>

  
  <div class="row g-3">
    <?php $__currentLoopData = $levels; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $level => $percent): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
      <?php
        // Requirement pack for the level
        $pack = $level <= 2 ? '1-2' : ($level <= 5 ? '3-5' : '6-8');
        $needed = $requirements[$pack];
        $progress = min(100, ($tokenBalance / max(1, $needed)) * 100);
        $progressRounded = round($progress);
        $unlocked = $tokenBalance >= $needed;

        // Colors / labels
        $barClass = $unlocked ? 'bg-success'
                  : ($progress > 0 ? 'bg-warning text-dark' : 'bg-danger');
        $statusText = $unlocked ? 'Completed' : ($progress > 0 ? 'In Progress' : 'Locked');
        $statusBadgeClass = $unlocked ? 'bg-success bg-opacity-10 text-success'
                            : ($progress > 0 ? 'bg-warning bg-opacity-10 text-warning'
                                             : 'bg-danger bg-opacity-10 text-danger');

        // Pack label
        $packLabel = $pack === '1-2' ? 'Unlocks with 6,000 tokens'
                   : ($pack === '3-5' ? 'Unlocks with 14,000 tokens'
                                      : 'Unlocks with 20,000 tokens');
      ?>

      <div class="col-xxl-3 col-lg-4 col-sm-6">
        <div class="card bg-white border-0 rounded-3 h-100">
          <div class="card-body p-4 d-flex flex-column">
            <div class="d-flex justify-content-between align-items-center mb-2">
              <h4 class="fs-16 fw-semibold mb-0">Level <?php echo e($level); ?></h4>
              <span class="badge <?php echo e($statusBadgeClass); ?> p-2 fs-12 fw-normal"><?php echo e($statusText); ?></span>
            </div>

            <div class="mb-1">
              <span class="text-secondary">Commission</span>
              <h5 class="mb-0"><?php echo e($percent); ?>%</h5>
            </div>

            <div class="small text-secondary mb-2"><?php echo e($packLabel); ?></div>

            <div class="progress mb-1" role="progressbar"
                 aria-valuenow="<?php echo e($progressRounded); ?>" aria-valuemin="0" aria-valuemax="100">
              <div class="progress-bar progress-bar-striped progress-bar-animated <?php echo e($barClass); ?>"
                   style="width: <?php echo e($progressRounded); ?>%"><?php echo e($progressRounded); ?>%</div>
            </div>
            <div class="d-flex justify-content-between small text-secondary">
              <span><?php echo e(number_format($tokenBalance)); ?> / <?php echo e(number_format($needed)); ?> tokens</span>
              <?php if($unlocked): ?>
                <span class="text-success fw-semibold">Ready</span>
              <?php endif; ?>
            </div>

            
            <div class="mt-auto"></div>
          </div>
        </div>
      </div>
    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
  </div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make($activeTemplate . 'layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/meghvwkg/public_html/core/resources/views/templates/meghron/user/team_commission.blade.php ENDPATH**/ ?>