

<?php $__env->startSection('content'); ?>
    
    <div class="d-flex justify-content-between align-items-center flex-wrap gap-2 mb-4">
        <h3 class="mb-0"><?php echo app('translator')->get('Transactions'); ?></h3>

        <nav style="--bs-breadcrumb-divider: '>';" aria-label="breadcrumb">
            <ol class="breadcrumb align-items-center mb-0 lh-1">
                <li class="breadcrumb-item">
                    <a href="<?php echo e(route('user.home')); ?>" class="d-flex align-items-center text-decoration-none">
                        <i class="ri-home-4-line fs-18 text-primary me-1"></i>
                        <span class="text-secondary fw-medium hover"><?php echo app('translator')->get('Dashboard'); ?></span>
                    </a>
                </li>
                <li class="breadcrumb-item active" aria-current="page">
                    <span class="fw-medium"><?php echo app('translator')->get('Wallet'); ?></span>
                </li>
                <li class="breadcrumb-item active" aria-current="page">
                    <span class="fw-medium"><?php echo app('translator')->get('Transactions'); ?></span>
                </li>
            </ol>
        </nav>
    </div>

    
    <div class="card bg-white border-0 rounded-3 mb-4">
        <div class="card-body p-4">
            <div class="d-flex justify-content-between align-items-center flex-wrap gap-3 mb-4">
                <h3 class="mb-0"><?php echo app('translator')->get('Transaction List'); ?></h3>

                
                <form method="GET" class="d-flex align-items-center gap-2">
                    <select name="wallet_type" class="form-select form-control p-0 h-auto border-0 w-90"
                            style="background-position: right 0 center;">
                        <option value=""><?php echo app('translator')->get('All Wallets'); ?></option>
                        <option value="token_balance" <?php if(request()->wallet_type == 'token_balance'): echo 'selected'; endif; ?>><?php echo app('translator')->get('Token Wallet'); ?></option>
                        <option value="referral_walltet" <?php if(request()->wallet_type == 'referral_walltet'): echo 'selected'; endif; ?>><?php echo app('translator')->get('ROI Wallet'); ?></option>
                    </select>
                    <select name="trx_type" class="form-select form-control p-0 h-auto border-0 w-90"
                            style="background-position: right 0 center;">
                        <option value=""><?php echo app('translator')->get('All Types'); ?></option>
                        <option value="+" <?php if(request()->trx_type == '+'): echo 'selected'; endif; ?>><?php echo app('translator')->get('Plus'); ?></option>
                        <option value="-" <?php if(request()->trx_type == '-'): echo 'selected'; endif; ?>><?php echo app('translator')->get('Minus'); ?></option>
                    </select>
                    <button class="btn btn-primary btn-sm"><?php echo app('translator')->get('Apply'); ?></button>
                </form>
            </div>

            <div class="default-table-area all-products">
                <div class="table-responsive">
                    <table class="table align-middle" id="transactionsTable">
                        <thead>
                            <tr>
                                <th scope="col"><?php echo app('translator')->get('Trx'); ?></th>
                                <th scope="col"><?php echo app('translator')->get('Transacted'); ?></th>
                                <th scope="col"><?php echo app('translator')->get('Amount'); ?></th>
                                <th scope="col"><?php echo app('translator')->get('Post Balance'); ?></th>
                                <th scope="col"><?php echo app('translator')->get('Wallet Type'); ?></th>
                                <th scope="col"><?php echo app('translator')->get('Detail'); ?></th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php $__empty_1 = true; $__currentLoopData = $transactions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $trx): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                <tr>
                                    
                                    <td class="text-body">
                                        <?php
                                            $tx = $trx->trx ?? null;
                                            $txShort = $tx ? substr($tx, 0, 10) . '…' . substr($tx, -6) : '-';
                                            $isMgrPurchase = isset($trx->remark) && $trx->remark === 'mgr_purchase';
                                        ?>
                                    
                                        <?php if($tx && $isMgrPurchase): ?>
                                            <a href="https://polygonscan.com/tx/<?php echo e($tx); ?>" target="_blank" rel="noopener"
                                               class="fw-semibold text-primary" title="<?php echo e($tx); ?>">
                                                <?php echo e($txShort); ?>

                                                <i class="material-symbols-outlined align-middle ms-1" style="font-size:14px;">open_in_new</i>
                                            </a>
                                        <?php else: ?>
                                            <span class="fw-semibold" title="<?php echo e($tx); ?>"><?php echo e($txShort); ?></span>
                                        <?php endif; ?>
                                    </td>



                                    
                                    <td class="text-secondary">
                                        <?php echo e(showDateTime($trx->created_at)); ?> <br>
                                        <small class="text-muted"><?php echo e(diffForHumans($trx->created_at)); ?></small>
                                    </td>

                                    
                                    <td>
                                        <span class="fw-bold <?php echo e($trx->trx_type == '+' ? 'text-success' : 'text-danger'); ?>">
                                            <?php echo e($trx->trx_type); ?> <?php echo e(showAmount($trx->amount)); ?> <?php echo e(__($general->cur_text)); ?>

                                        </span>
                                    </td>

                                    
                                    <td class="text-secondary">
                                        <?php echo e(showAmount($trx->post_balance)); ?> <?php echo e(__($general->cur_text)); ?>

                                    </td>

                                    
                                    <td>
                                        <?php if($trx->wallet_type == 'referral_walltet'): ?>
                                            <span class="badge bg-info"><?php echo app('translator')->get('ROI Wallet'); ?></span>
                                        <?php else: ?>
                                            <span class="badge bg-primary"><?php echo app('translator')->get('Token Wallet'); ?></span>
                                        <?php endif; ?>
                                    </td>

                                    
                                    <td class="text-secondary">
                                        <?php echo e(__($trx->details)); ?>

                                    </td>
                                </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                <tr>
                                    <td colspan="6" class="text-center text-muted py-4">
                                        <?php echo e(__($emptyMessage ?? 'No transactions found')); ?>

                                    </td>
                                </tr>
                            <?php endif; ?>
                        </tbody>
                    </table>
                </div>

                
                <?php if($transactions->hasPages()): ?>
                    <div class="mt-3">
                        <?php echo e(paginateLinks($transactions)); ?>

                    </div>
                <?php endif; ?>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make($activeTemplate . 'layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/meghvwkg/public_html/core/resources/views/templates/meghron/user/transactions.blade.php ENDPATH**/ ?>