

<?php $__env->startSection('panel'); ?>
    <div class="row gy-3">
        <div class="col-xl-4">
            <div class="card">
                <div class="card-header">
                    <h5 class="card-title mb-0"><?php echo app('translator')->get('Plan & User Information'); ?></h5>
                </div>
                <div class="card-body">
                    <ul class="list-group">
                        <li class="list-group-item d-flex justify-content-between">
                            <?php echo app('translator')->get('Plan Name'); ?>
                            <span><?php echo e(__($invest->plan->name)); ?></span>
                        </li>
                        <li class="list-group-item d-flex justify-content-between">
                            <?php echo app('translator')->get('Investable Amount'); ?>
                            <span>
                                <?php if($invest->plan->fixed_amount > 0): ?>
                                    <?php echo e($general->cur_sym); ?><?php echo e(showAmount($invest->plan->fixed_amount)); ?>

                                <?php else: ?>
                                    <?php echo e($general->cur_sym); ?><?php echo e(showAmount($invest->plan->minimum)); ?> - <?php echo e($general->cur_sym); ?><?php echo e(showAmount($invest->plan->maximum)); ?>

                                <?php endif; ?>
                            </span>
                        </li>

                        <li class="list-group-item d-flex justify-content-between">
                            <?php echo app('translator')->get('Full Name'); ?>
                            <span><?php echo e($invest->user->fullname); ?></span>
                        </li>
                        <li class="list-group-item d-flex justify-content-between">
                            <?php echo app('translator')->get('Username'); ?>
                            <span><?php echo e($invest->user->username); ?></span>
                        </li>
                        <li class="list-group-item d-flex justify-content-between">
                            <?php echo app('translator')->get('Mobile'); ?>
                            <span><?php echo e($invest->user->mobile); ?></span>
                        </li>
                        <li class="list-group-item d-flex justify-content-between">
                            <?php echo app('translator')->get('Email'); ?>
                            <span><?php echo e($invest->user->email); ?></span>
                        </li>
                    </ul>
                </div>
            </div>
        </div>
        <div class="col-xl-4 col-md-6">
            <div class="card">
                <div class="card-header">
                    <h5 class="card-title mb-0"><?php echo app('translator')->get('Basic Information'); ?></h5>
                </div>
                <div class="card-body">
                    <ul class="list-group">
                        <li class="list-group-item d-flex justify-content-between">
                            <?php echo app('translator')->get('Invest Amount'); ?>
                            <span><?php echo e($general->cur_sym); ?><?php echo e(showAmount($invest->amount)); ?></span>
                        </li>
                        <li class="list-group-item d-flex justify-content-between">
                            <?php echo app('translator')->get('Invested'); ?>
                            <span><?php echo e(showDateTime($invest->created_at)); ?></span>
                        </li>
                        <li class="list-group-item d-flex justify-content-between">
                            <?php echo app('translator')->get('Interest Amount'); ?>
                            <span><?php echo e($general->cur_sym); ?><?php echo e(showAmount($invest->interest)); ?></span>
                        </li>
                        <li class="list-group-item d-flex justify-content-between">
                            <?php echo app('translator')->get('Total Payable'); ?>
                            <span>
                                <?php if($invest->period != -1): ?>
                                    <?php echo e($invest->period); ?> <?php echo app('translator')->get(' times'); ?>
                                <?php else: ?>
                                    <?php echo app('translator')->get('Lifetime'); ?>
                                <?php endif; ?>
                            </span>
                        </li>
                        <li class="list-group-item d-flex justify-content-between">
                            <?php echo app('translator')->get('Interest Interval'); ?>
                            <span><?php echo app('translator')->get('Every '); ?> <?php echo e($invest->time_name); ?></span>
                        </li>
                        <li class="list-group-item d-flex justify-content-between">
                            <?php echo app('translator')->get('Status'); ?>
                            <span>
                                <?php if($invest->status): ?>
                                    <span class="badge badge--success"><?php echo app('translator')->get('Running'); ?></span>
                                <?php else: ?>
                                    <span class="badge badge--dark"><?php echo app('translator')->get('Closed'); ?></span>
                                <?php endif; ?>
                            </span>
                        </li>
                    </ul>
                </div>
            </div>
        </div>
        <div class="col-xl-4 col-md-6">
            <div class="card">
                <div class="card-header">
                    <h5 class="card-title mb-0"><?php echo app('translator')->get('Other Information'); ?></h5>
                </div>
                <div class="card-body">
                    <ul class="list-group">
                        <li class="list-group-item d-flex justify-content-between">
                            <?php echo app('translator')->get('Total Paid'); ?>
                            <span><?php echo e($general->cur_sym); ?><?php echo e(showAmount($invest->paid)); ?></span>
                        </li>
                        <li class="list-group-item d-flex justify-content-between">
                            <?php echo app('translator')->get('Total Paid Amount'); ?>
                            <span><?php echo e($invest->return_rec_time); ?> <?php echo app('translator')->get(' times'); ?></span>
                        </li>
                        <li class="list-group-item d-flex justify-content-between">
                            <?php echo app('translator')->get('Should Pay'); ?>
                            <span>
                                <?php if($invest->should_pay != -1): ?>
                                    <?php echo e($general->cur_sym); ?><?php echo e(showAmount($invest->interest)); ?>

                                <?php else: ?>
                                    **
                                <?php endif; ?>
                            </span>
                        </li>
                        <li class="list-group-item d-flex justify-content-between">
                            <?php echo app('translator')->get('Last Paid Time'); ?>
                            <span><?php echo e(showDateTime($invest->last_time)); ?></span>
                        </li>
                        <li class="list-group-item d-flex justify-content-between">
                            <?php echo app('translator')->get('Next Pay Time'); ?>
                            <span><?php echo e(showDateTime($invest->next_time)); ?></span>
                        </li>

                        <li class="list-group-item d-flex justify-content-between">
                            <?php echo app('translator')->get('Capital Back'); ?>
                            <span>
                                <?php if($invest->capital_status): ?>
                                    <?php echo app('translator')->get('Yes'); ?>
                                <?php else: ?>
                                    <?php echo app('translator')->get('No'); ?>
                                <?php endif; ?>
                            </span>
                        </li>
                    </ul>
                </div>
            </div>
        </div>
    </div>

    <div class="row mt-4">
        <div class="col-lg-12">
            <h5 class="my-2"><?php echo app('translator')->get('All Interests'); ?></h5>
            <div class="card b-radius--10 ">
                <div class="card-body p-0">
                    <div class="table-responsive--md  table-responsive">
                        <table class="table table--light style--two">
                            <thead>
                                <tr>
                                    <th><?php echo app('translator')->get('TRX'); ?></th>
                                    <th><?php echo app('translator')->get('Transacted'); ?></th>
                                    <th><?php echo app('translator')->get('Amount'); ?></th>
                                    <th><?php echo app('translator')->get('Post Balance'); ?></th>
                                    <th><?php echo app('translator')->get('Details'); ?></th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php $__empty_1 = true; $__currentLoopData = $transactions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $trx): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                    <tr>
                                        <td><strong><?php echo e($trx->trx); ?></strong></td>
                                        <td><?php echo e(showDateTime($trx->created_at)); ?><br><?php echo e(diffForHumans($trx->created_at)); ?></td>

                                        <td class="budget">
                                            <span class="fw-bold <?php if($trx->trx_type == '+'): ?> text--success <?php else: ?> text--danger <?php endif; ?>">
                                                <?php echo e($trx->trx_type); ?> <?php echo e(showAmount($trx->amount)); ?> <?php echo e($general->cur_text); ?>

                                            </span>
                                        </td>

                                        <td class="budget">
                                            <?php echo e(showAmount($trx->post_balance)); ?> <?php echo e(__($general->cur_text)); ?>

                                        </td>

                                        <td><?php echo e(__($trx->details)); ?></td>
                                    </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                    <tr>
                                        <td class="text-muted text-center" colspan="100%"><?php echo e(__($emptyMessage)); ?></td>
                                    </tr>
                                <?php endif; ?>
                            </tbody>
                        </table><!-- table end -->
                    </div>
                </div>
                <?php if($transactions->hasPages()): ?>
                    <div class="card-footer py-4">
                        <?php echo e(paginateLinks($transactions)); ?>

                    </div>
                <?php endif; ?>
            </div><!-- card end -->
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/meghvwkg/public_html/core/resources/views/admin/reports/invest_details.blade.php ENDPATH**/ ?>