<?php $__env->startSection('panel'); ?>
    <div class="row">
        <div class="col-lg-12">
            <div class="card b-radius--10 ">
                <div class="card-body p-0">
                    <div class="table-responsive--md  table-responsive">
                        <table class="table table--light style--two">
                            <thead>
                                <tr>
                                    <th><?php echo app('translator')->get('User'); ?></th>
                                    <th><?php echo app('translator')->get('Wallet Address'); ?></th>
                              
                                    <th><?php echo app('translator')->get('Joined At'); ?></th>
                                    <th><?php echo app('translator')->get('Balance'); ?></th>
                                    <th><?php echo app('translator')->get('Action'); ?></th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php $__empty_1 = true; $__currentLoopData = $users; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $user): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                    <tr>
                                        <td>
                                            <span class="fw-bold"><?php echo e($user->fullname); ?>

                                            <?php if($user->invests->count() > 0): ?> <span class="badge badge--success">Active</span>    <?php else: ?>
                                                <span class="badge badge--danger">Inactive</span>
                                            <?php endif; ?>
                                            </span>
                                            <br>
                                            <span class="small">
                                                <a href="<?php echo e(route('admin.users.detail', $user->id)); ?>"><span>@</span><?php echo e($user->username); ?></a>
                                            </span>
                                        </td>


                                            <?php
                                                $walletNameRaw = $user->wallet_name ?? '';
                                                $walletKey     = strtolower(trim($walletNameRaw));
                                            
                                                // Map wallet name -> badge class
                                                $badgeMap = [
                                                    'trust wallet'     => 'bg-primary text-white',   // blue
                                                    'metamask'         => 'bg-warning text-dark',    // orange
                                                    'coinbase wallet'  => 'bg-info text-dark',       // light blue
                                                    'okx'              => 'bg-dark text-white',      // black
                                                    'phantom'          => 'bg-purple text-white',    // purple (see tiny CSS below)
                                                    'rainbow'          => 'bg-success text-white',   // green
                                                    'zerion'           => 'bg-secondary text-white', // gray
                                                    'safe'             => 'bg-success text-white',   // green
                                                    'ledger live'      => 'bg-secondary text-white', // gray
                                                ];
                                            
                                                $badgeClass = $badgeMap[$walletKey] ?? 'bg-secondary text-white';
                                            ?>
                                        
                                        <td>
                                            <?php echo e($user->wallet); ?><br>
                                            <span class="badge <?php echo e($badgeClass); ?>">
                                                <?php echo e($walletNameRaw ?: 'Unknown Wallet'); ?>

                                            </span>
                                        </td>
                                     

                                        <td>
                                            <?php echo e(showDateTime($user->created_at)); ?> <br> <?php echo e(diffForHumans($user->created_at)); ?>

                                        </td>


                                        <td>
                                            <span class="fw-bold">
                                                <?php echo app('translator')->get('TOKEN WALLET'); ?> <?php echo e($general->cur_sym); ?> <?php echo e(showAmount($user->token_balance)); ?><br>
                                                <?php echo app('translator')->get('ROI WALLET'); ?> <?php echo e($general->cur_sym); ?> <?php echo e(showAmount($user->referral_walltet)); ?>

                                            </span>
                                        </td>

                                        <td>
                                            <div class="button--group">
                                                <a href="<?php echo e(route('admin.users.detail', $user->id)); ?>" class="btn btn-sm btn-outline--primary">
                                                    <i class="las la-desktop"></i> <?php echo app('translator')->get('Details'); ?>
                                                </a>
                                                <?php if(request()->routeIs('admin.users.kyc.pending')): ?>
                                                    <a href="<?php echo e(route('admin.users.kyc.details', $user->id)); ?>" target="_blank" class="btn btn-sm btn-outline--dark">
                                                        <i class="las la-user-check"></i><?php echo app('translator')->get('KYC Data'); ?>
                                                    </a>
                                                <?php endif; ?>
                                            </div>
                                        </td>

                                    </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                    <tr>
                                        <td class="text-muted text-center" colspan="100%"><?php echo e(__($emptyMessage)); ?></td>
                                    </tr>
                                <?php endif; ?>

                            </tbody>
                        </table><!-- table end -->
                    </div>
                </div>
                <?php if($users->hasPages()): ?>
                    <div class="card-footer py-4">
                        <?php echo e(paginateLinks($users)); ?>

                    </div>
                <?php endif; ?>
            </div>
        </div>


    </div>
<?php $__env->stopSection(); ?>



<?php $__env->startPush('breadcrumb-plugins'); ?>
    <?php if (isset($component)) { $__componentOriginalc254754b9d5db91d5165876f9d051922ca0066f4 = $component; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.search-form','data' => ['placeholder' => 'Username / Email']] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? (array) $attributes->getIterator() : [])); ?>
<?php $component->withName('search-form'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag && $constructor = (new ReflectionClass(Illuminate\View\AnonymousComponent::class))->getConstructor()): ?>
<?php $attributes = $attributes->except(collect($constructor->getParameters())->map->getName()->all()); ?>
<?php endif; ?>
<?php $component->withAttributes(['placeholder' => 'Username / Email']); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__componentOriginalc254754b9d5db91d5165876f9d051922ca0066f4)): ?>
<?php $component = $__componentOriginalc254754b9d5db91d5165876f9d051922ca0066f4; ?>
<?php unset($__componentOriginalc254754b9d5db91d5165876f9d051922ca0066f4); ?>
<?php endif; ?>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('admin.layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/meghvwkg/public_html/core/resources/views/admin/users/list.blade.php ENDPATH**/ ?>