

<?php $__env->startSection('content'); ?>
  
  <div class="d-flex justify-content-between align-items-center flex-wrap gap-2 mb-4">
      <h3 class="mb-0"><?php echo app('translator')->get('News & Update'); ?></h3>
      <nav style="--bs-breadcrumb-divider: '>';" aria-label="breadcrumb">
          <ol class="breadcrumb align-items-center mb-0 lh-1">
              <li class="breadcrumb-item">
                  <a href="<?php echo e(route('user.home')); ?>" class="d-flex align-items-center text-decoration-none">
                      <i class="ri-home-4-line fs-18 text-primary me-1"></i>
                      <span class="text-secondary fw-medium hover"><?php echo app('translator')->get('Dashboard'); ?></span>
                  </a>
              </li>
              <li class="breadcrumb-item active" aria-current="page">
                  <span class="fw-medium"><?php echo app('translator')->get('News'); ?></span>
              </li>
          </ol>
      </nav>
  </div>

  <?php if($news->count() === 0): ?>
    <div class="card bg-white border-0 rounded-3">
      <div class="card-body p-4 text-center text-secondary">
        <?php echo app('translator')->get('No news found yet.'); ?>
      </div>
    </div>
  <?php else: ?>
    <div class="row g-3">
      <?php $__currentLoopData = $news; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
        <?php
          $id    = $item->id;
          $data  = $item->data_values ?? (object)[];
          $title = $data->title ?? __('Untitled');
          $image = $data->image ?? null;
          $desc  = $data->description ?? '';
          // Some themes keep images under "assets/images/frontend/news", adjust if different in your helper set.
          $imgUrl = $image
              ? getImage('assets/images/frontend/news/' . $image, '280x300')
              : asset($activeTemplateTrue.'images/placeholder-920x480.jpg');
          $createdHuman = optional($item->created_at)->diffForHumans();
        ?>

        <div class="col-xxl-4 col-xl-4 col-lg-4 col-md-6">
          <div class="card bg-white border-0 rounded-3 h-100 news-card" data-news-id="<?php echo e($id); ?>">
            <img src="<?php echo e($imgUrl); ?>" style="width:100%; height: 280px;" class="card-img-top rounded-top-3" alt="news">
            <div class="card-body p-4 d-flex flex-column">
              <h5 class="fw-semibold fs-16 mb-2"><?php echo e($title); ?></h5>

              <div class="d-flex align-items-center justify-content-between mb-2">
                <div class="small text-secondary d-flex align-items-center gap-2">
                  <span class="d-inline-flex align-items-center">
                    <i class="ri-eye-line me-1"></i><span class="js-views">0</span> <?php echo app('translator')->get('views'); ?>
                  </span>
                  <span>•</span>
                  <span class="d-inline-flex align-items-center">
                    <i class="ri-time-line me-1"></i><?php echo e($createdHuman); ?>

                  </span>
                </div>
              </div>

              
              <div class="text-body small line-clamp mb-2 js-preview">
                <?php echo \Illuminate\Support\Str::limit(strip_tags($desc), 180); ?>

              </div>

              
              <div class="text-body small d-none js-full">
                <?php echo $desc; ?>

              </div>

              <div class="mt-auto">
                <button class="btn btn-outline-primary py-2 px-3 fw-medium w-100 js-toggle">
                  <?php echo app('translator')->get('See More'); ?>
                </button>
              </div>
            </div>
          </div>
        </div>
      <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
    </div>

    
    <div class="d-flex justify-content-center mt-4">
      <?php echo e($news->links()); ?>

    </div>
  <?php endif; ?>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('style'); ?>
<style>
  .line-clamp {
    display: -webkit-box;
    -webkit-line-clamp: 4; /* show ~4 lines in preview */
    -webkit-box-orient: vertical;
    overflow: hidden;
  }
</style>
<?php $__env->stopPush(); ?>

<?php $__env->startPush('script'); ?>
<script>
(function () {
  const MIN_BASE = 500_000;      // minimum initial views
  const MAX_BASE = 1_200_000;    // maximum initial views
  const TICK_MS  = 5000;         // update every 5 seconds
  const INC_MIN  = 7;            // min increment per tick
  const INC_MAX  = 120;          // max increment per tick

  function clampBase(v) {
    if (!Number.isFinite(v) || v < MIN_BASE) return randInt(MIN_BASE, MAX_BASE);
    return v;
  }
  function randInt(min, max) {
    return Math.floor(min + Math.random() * (max - min + 1));
  }
  function getKey(id) { return 'newsViews_' + id; }
  function getViews(id) {
    const raw = localStorage.getItem(getKey(id));
    return clampBase(parseInt(raw || '0', 10));
  }
  function setViews(id, v) {
    localStorage.setItem(getKey(id), String(v));
  }
  function paint(el, v) {
    el.textContent = Number(v).toLocaleString();
  }

  // initialize cards
  const cards = Array.from(document.querySelectorAll('.news-card')).map(card => {
    const id      = card.getAttribute('data-news-id');
    const viewsEl = card.querySelector('.js-views');
    const btn     = card.querySelector('.js-toggle');
    const preview = card.querySelector('.js-preview');
    const full    = card.querySelector('.js-full');

    if (!id || !viewsEl) return null;

    // seed / normalize base ≥ 500k
    let v = getViews(id);
    setViews(id, v);
    paint(viewsEl, v);

    // toggle preview/full content
    btn?.addEventListener('click', function(){
      const showingFull = !full.classList.contains('d-none');
      if (showingFull) {
        full.classList.add('d-none');
        preview.classList.remove('d-none');
        btn.textContent = '<?php echo e(__("See More")); ?>';
      } else {
        full.classList.remove('d-none');
        preview.classList.add('d-none');
        btn.textContent = '<?php echo e(__("See Less")); ?>';
      }
    });

    return { id, viewsEl };
  }).filter(Boolean);

  // periodic increment for all cards (lightweight single timer)
  setInterval(() => {
    for (const c of cards) {
      let current = getViews(c.id);
      const inc   = randInt(INC_MIN, INC_MAX);
      current += inc;
      setViews(c.id, current);
      paint(c.viewsEl, current);
    }
  }, TICK_MS);
})();
</script>
<?php $__env->stopPush(); ?>


<?php echo $__env->make($activeTemplate . 'layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/meghvwkg/public_html/core/resources/views/templates/meghron/user/news_update.blade.php ENDPATH**/ ?>