<div class="card border bg-white rounded-3 mb-4 p-0">
  <div class="d-flex flex-wrap gap-2 justify-content-between align-items-center mb-4 border-bottom p-3 px-4">
    <div><h3 class="mb-0">Market Price Statistics</h3></div>

    <div class="d-flex flex-wrap gap-2 align-items-center">
      <ul class="analytics-tabs d-flex flex-wrap list-unstyled ps-0 mb-0" id="mgrTfTabs">
        <li><button class="active">1H</button></li>
        <li><button>24H</button></li>
        <li><button>1W</button></li>
        <li><button>1M</button></li>
        <li><button>1Y</button></li>
      </ul>
    </div>
  </div>

  <div class="p-4 pt-0">
    <div class="row align-items-center gy-3">
      <div class="col-xxl-12 col-sm-12">
        <div class="d-flex flex-wrap gap-2 justify-content-between align-items-center">
          <div class="d-flex align-items-center">
            <div class="flex-shrink-0">
              <img src="<?php echo e(asset($activeTemplateTrue . 'images/icon.png')); ?>" class="rounded-circle" style="width: 53px; height: 48px;" alt="mgr">
            </div>
            <div class="flex-grow-1 ms-2">
              <span class="mb-1 d-block fw-medium text-secondary">Meghron <span class="text-body fw-normal">(MGR)</span></span>
              <div class="d-flex">
                <h3 class="mb-0 fs-20 fw-semibold me-1" id="mgrPricee">$0.001452</h3>
                <i class="material-symbols-outlined fs-16 position-relative top-3 text-success" id="mgrTrendIcon">trending_up</i>
                <span class="text-success" id="mgrChange">+0.00%</span>
              </div>
            </div>
          </div>

          <div>
            <span class="fs-14 fw-medium d-block mb-1">Market Cap:</span>
            <h4 class="fs-14 fw-semibold mb-0" id="mgrMcap">0 POL</h4>
          </div>
          <div>
            <span class="fs-14 fw-medium d-block mb-1">Liquidity:</span>
            <h4 class="fs-14 fw-semibold mb-0" id="mgrLiq">0 POL</h4>
          </div>
        </div>
      </div>
    </div>
  </div>

  <div class="p-4 pt-0" style="margin: -9px 0 -20px -18px;">
    <div id="market_price_statistics"></div>
  </div>
</div>

        
        
<?php $__env->startPush('script'); ?>
<script>
(() => {
  // ===== Server endpoint =====
  const MARKET_URL = `<?php echo e(route('user.mgr.market')); ?>`;

  // ===== Runtime server-driven values (mutable) =====
  let FAKE_TRNS_MODE = 1;        // 0=both, 1=buy-only, 2=sell-only (chart: 1=green only)
  let MGR_PER_POL    = 162;      // 1 POL = X MGR
  let POL_PER_MGR    = 1 / MGR_PER_POL;

  // Strings to preserve DECIMAL(28,8) precision for display
  let MARKET_CAP_STR = '0';
  let LIQ_STR        = '0';
  let MIN_TRADE      = null;
  let MAX_TRADE      = null;

  // ===== Chart settings (unchanged) =====
  const POINTS = { '1H': 40, '24H': 144, '1W': 168, '1M': 90, '1Y': 52 };
  const STEPS  = { '1H': 60_000, '24H': 600_000, '1W': 3_600_000, '1M': 43_200_000, '1Y': 604_800_000 };
  const GROW   = {
    '1H':[0.0005,0.0020], '24H':[0.0003,0.0012], '1W':[0.0002,0.0008],
    '1M':[0.00015,0.0006], '1Y':[0.00010,0.0004]
  };

  // ===== DOM/State =====
  const CHART_ID = 'market_price_statistics';
  let activeTF = '1H';
  let seriesData = [];
  let currentCandle = null;
  let candleChart = null;
  let prevCloseRef = POL_PER_MGR;

  // ===== Formatters =====
  const fmtUSDabbrFromStr = (s) => {
    s = String(s ?? '0').replace(/[,\s]/g,'');
    const neg = s.startsWith('-') ? '-' : '';
    if (neg) s = s.slice(1);
    const [iRaw, f='0'] = s.split('.');
    const i = (iRaw || '0').replace(/^0+/, '') || '0';
    const len = i.length;
    const mk = (k, suf) => {
      if (len <= k) return null;
      const head = i.slice(0, len - k);
      const tail = i.slice(len - k, len - k + 2);
      return '$' + (neg?'-':'') + head + (tail?'.'+tail:'') + suf;
    };
    const num = Number((neg?'-':'') + (i || '0') + (f ? '.'+f : '0'));
    return mk(12,'T') || mk(9,'B') || mk(6,'M') || mk(3,'k') || ('$' + (isFinite(num) ? num.toFixed(2) : '0.00'));
  };

  // ===== Emit metrics to other partials (bus + event + global) =====
  function emitMetrics() {
    const pricePol = Number(currentCandle?.y?.[3] ?? POL_PER_MGR); // POL per 1 MGR
    const payload  = { pricePol };
    // Pub/Sub bus (instant for late subscribers)
    window.MGR_BUS?.publish?.(payload);
    // Back-compat fallbacks
    window.MGR_DATA = payload;
    window.dispatchEvent(new CustomEvent('mgr:metrics', { detail: payload }));
  }

  // ===== Candles (respect fake_trns) =====
  function makeCandle(prevClose) {
    const [gMin,gMax] = GROW[activeTF] || [0.0002,0.0008];
    const baseGrow = gMin + Math.random()*(gMax - gMin);
    const targetClose = prevClose * (1 + baseGrow);

    const allowReds = (FAKE_TRNS_MODE !== 1);
    const makeRed = allowReds && Math.random() < 0.25;

    let open, high, low, close;
    if (makeRed) {
      open  = targetClose * (1 + Math.random()*0.0008);
      const belowOpen = open * (1 - (0.0005 + Math.random()*0.0010));
      const floor     = prevClose * (1 + Math.max(0.00005, baseGrow*0.25));
      close = Math.max(floor, Math.min(targetClose, belowOpen));
      high  = Math.max(open, close) * (1 + Math.random()*0.0010);
      low   = Math.min(open, close) * (1 - Math.random()*0.0010);
    } else {
      close = targetClose;
      open  = close * (1 - Math.random()*0.0012);
      high  = Math.max(open, close) * (1 + Math.random()*0.0010);
      low   = Math.min(open, close) * (1 - Math.random()*0.0010);
    }
    low = Math.max(0.0000001, low);
    return { x:new Date(), y:[open, high, low, close], bear:(close < open) };
  }

  function genSeries(n, stepMs, startPrice) {
    const out = [];
    let p = startPrice;
    const startTs = Date.now() - n*stepMs;
    for (let i=0;i<n;i++){
      const c = makeCandle(p);
      c.x = new Date(startTs + i*stepMs);
      out.push(c);
      p = c.y[3];
    }
    prevCloseRef = p;
    return out;
  }

  // ===== Apex options =====
  function buildOptions(series) {
    return {
      series: [{ data: series }],
      chart: { type:'candlestick', height:345, toolbar:{show:false}, zoom:{enabled:false} },
      plotOptions:{ candlestick:{ colors:{ upward:'#16a34a', downward:'#ef4444' }, wick:{useFillColor:true} } },
      xaxis:{ type:'datetime', labels:{ style:{ color:'#64748B', fontSize:'12px' } } },
      yaxis:{ labels:{ formatter:(v)=>Number(v).toFixed(6), style:{ color:'#64748B', fontSize:'12px' } } },
      grid:{ borderColor:'#ECEEF2' },
      tooltip:{ enabled:true }
    };
  }

  // ===== Data load / render =====
  function loadSeries() {
    const n = POINTS[activeTF] || 40;
    const step = STEPS[activeTF] || 60_000;
    seriesData = genSeries(n, step, POL_PER_MGR);
    currentCandle = seriesData[seriesData.length-1];
  }

  function renderChart() {
    const el = document.getElementById(CHART_ID);
    if (!el) return;
    el.innerHTML = '';
    candleChart = new ApexCharts(el, buildOptions(seriesData));
    candleChart.render();
    paintHeader();
    emitMetrics();
  }

  // ===== Live update =====
  function tick() {
    if (!currentCandle || !candleChart) return;
    const o = +currentCandle.y[0], h = +currentCandle.y[1], l = +currentCandle.y[2], c = +currentCandle.y[3];
    const [gMin,gMax] = GROW[activeTF] || [0.0002,0.0008];
    const microGrow = (gMin/20) + Math.random()*((gMax/20)-(gMin/20));
    let nextClose = c * (1 + microGrow);

    if (currentCandle.bear) {
      const maxBelowOpen = o * (1 - 0.0001);
      nextClose = Math.min(nextClose, maxBelowOpen);
      nextClose = Math.max(nextClose, prevCloseRef * (1 + 0.00002));
      if (nextClose >= o) nextClose = o - 1e-8;
    }

    const nextHigh = Math.max(h, nextClose) * (1 + Math.random()*0.0006);
    const nextLow  = Math.min(l, Math.min(o,nextClose)) * (1 - Math.random()*0.0006);

    currentCandle.y = [o, nextHigh, Math.max(0.0000001, nextLow), nextClose];
    candleChart.updateSeries([{ data: seriesData }], false);
    paintHeader();
    emitMetrics();
  }

  function roll() {
    prevCloseRef = Number(currentCandle?.y?.[3] || prevCloseRef);
    currentCandle = makeCandle(prevCloseRef);
    seriesData.push(currentCandle);
    const maxPts = POINTS[activeTF] || 40;
    if (seriesData.length > maxPts) seriesData.shift();
    candleChart.updateSeries([{ data: seriesData }], false);
    paintHeader();
    emitMetrics();
  }

  // ===== Header =====
  function paintHeader() {
    const priceEl = document.getElementById('mgrPrice');
    const chgEl   = document.getElementById('mgrChange');
    const mcapEl  = document.getElementById('mgrMcap');
    const liqEl   = document.getElementById('mgrLiq');

    const last  = Number(currentCandle?.y?.[3] || POL_PER_MGR);
    const first = Number(seriesData?.[0]?.y?.[0] || last);
    const pct   = ((last - first) / (first || 1)) * 100;

    if (priceEl) priceEl.textContent = last.toFixed(6) + ' POL';
    if (chgEl) {
      const pos = Math.max(0, pct);
      chgEl.textContent = `+${pos.toFixed(2)}%`;
      chgEl.classList.add('text-success');
      chgEl.classList.remove('text-danger');
    }
    if (mcapEl) mcapEl.textContent = fmtUSDabbrFromStr(MARKET_CAP_STR);
    if (liqEl)  liqEl.textContent  = fmtUSDabbrFromStr(LIQ_STR);
  }

  // ===== Timeframes =====
  function bindTF() {
    document.querySelectorAll('.analytics-tabs button').forEach(btn=>{
      btn.addEventListener('click', ()=>{
        const tf = btn.textContent.trim();
        if (!POINTS[tf] || tf===activeTF) return;
        document.querySelectorAll('.analytics-tabs button').forEach(b=>b.classList.remove('active'));
        btn.classList.add('active');
        activeTF = tf;
        loadSeries();
        renderChart();
        clearInterval(window.__mgrChartTick);
        clearInterval(window.__mgrChartRoll);
        window.__mgrChartTick = setInterval(tick, 1000);
        window.__mgrChartRoll = setInterval(roll, STEPS[activeTF] || 60_000);
      });
    });
  }

  // ===== Fetch + apply server settings (live) =====
  async function refreshServerSettings(initial = false){
    try{
      const res = await fetch(MARKET_URL, { cache: 'no-store' });
      const j = await res.json();

      // 1) USD strings
      if (typeof j.market_cap === 'string') MARKET_CAP_STR = j.market_cap;
      if (typeof j.liquidity  === 'string') LIQ_STR        = j.liquidity;

      // 2) behavior knobs
      if (j.fake_trns != null) FAKE_TRNS_MODE = Number(j.fake_trns) || 1;
      if (j.min_trade != null) MIN_TRADE      = j.min_trade;  // available if you need for other widgets
      if (j.max_trade != null) MAX_TRADE      = j.max_trade;

      // 3) price base (1 POL = mgr_amount MGR) → POL/MGR
      if (j.mgr_amount != null) {
        const newMgrPerPol = Number(j.mgr_amount) || MGR_PER_POL;
        const newBase = (newMgrPerPol > 0) ? (1 / newMgrPerPol) : POL_PER_MGR;

        // If base changed, rescale entire series to keep shape but match absolute price
        const eps = 1e-12;
        if (Math.abs(newBase - POL_PER_MGR) > eps) {
          const ratio = newBase / POL_PER_MGR;
          seriesData.forEach(c => c.y = c.y.map(v => Number(v) * ratio));
          if (currentCandle) currentCandle.y = currentCandle.y.map(v => Number(v) * ratio);
          prevCloseRef *= ratio;
          POL_PER_MGR  = newBase;
          MGR_PER_POL  = newMgrPerPol;
          candleChart?.updateSeries([{ data: seriesData }], false);
          paintHeader();
          emitMetrics();
        }
      }

      // repaint USD numbers even if price base didn't change
      paintHeader();
    }catch(e){
      // silent fail is fine
    }
  }

  // ===== Init =====
  // Visually make 1H active
  (function enforce1HActive(){
    const tabs = document.querySelectorAll('.analytics-tabs button');
    if (tabs.length) {
      tabs.forEach(b=>b.classList.remove('active'));
      const b1h = Array.from(tabs).find(b => b.textContent.trim()==='1H') || tabs[0];
      b1h.classList.add('active'); activeTF = b1h.textContent.trim();
    }
  })();

  // Start with current base; then live-fetch and rescale if needed
  loadSeries();
  renderChart();
  bindTF();

  window.__mgrChartTick = setInterval(tick, 1000);
  window.__mgrChartRoll = setInterval(roll, STEPS[activeTF] || 60_000);

  // First pull immediately, then poll every 30s
  refreshServerSettings(true);
  setInterval(refreshServerSettings, 30_000);
})();
</script>
<?php $__env->stopPush(); ?>


<?php /**PATH /home/meghvwkg/public_html/core/resources/views/templates/meghron/user/partials/live_chart.blade.php ENDPATH**/ ?>