


<!--==================================================-->
<!-- Start Header Section -->
<!--===================================================-->
<div class="header-area" id="sticky-header">
    <div class="container">
        <div class="row align-items-center d-flex">
            
            <!-- Desktop Header -->
            <div class="col-12 d-none d-lg-flex align-items-center justify-content-between">
                <!-- Logo -->
                <div class="header-logo">
                    <a class="main-logo" href="<?php echo e(route('home')); ?>">
                        <img class="desktop-logo" src="<?php echo e(asset($activeTemplateTrue . 'images/logo-two.png')); ?>" alt="Logo" />
                    </a>
                    <a class="stiky-logo" href="<?php echo e(route('home')); ?>">
                        <img class="desktop-logo" src="<?php echo e(asset($activeTemplateTrue . 'images/logo-dark.png')); ?>" alt="Logo" />
                    </a>
                </div>

                <!-- Nav + Button -->
                <nav class="cryptozen_menu">
                    <div class="header-menu">
                        <ul class="nav_scroll">
                            <li><a href="#home">Home</a></li>
                            <li><a href="#about">About</a></li>
                            <li><a href="#features">Features</a></li>
                            <li><a href="#token">Token sales</a></li>
                            <li><a href="#roadmap">Roadmap</a></li>
                            <li><a href="#contact">Contact</a></li>
                        </ul>
                        <div class="header-btn">
                            <!-- Wallet Control Area (Desktop) -->
                            <?php if(($gs->registration ?? 0) == 0): ?>
                                <a href="javascript:void(0)" class="btn-wallet" id="walletLoginDisabled" data-msg="<?php echo app('translator')->get('Registration not started yet'); ?>">
                                    <?php echo app('translator')->get('Connect Wallet'); ?>
                                </a>
                            <?php else: ?>
                                <div id="wallet-control-area" class="d-flex align-items-center">
                                    
                                    <?php if(auth()->guard()->check()): ?>
                                        <a href="<?php echo e(route('user.home')); ?>" id="walletAddressLink" class="btn-wallet me-2"><?php echo e(Str::limit(auth()->user()->wallet ?? auth()->user()->username, 12, '')); ?></a>
                                        <a href="javascript:void(0)" class="btn-wallet" id="disconnectBtnDesktop"><?php echo app('translator')->get('Disconnect'); ?></a>
                                    <?php else: ?>
                                        <a href="javascript:void(0)" class="btn-wallet" id="connectBtnDesktop"><?php echo app('translator')->get('Connect Wallet'); ?></a>
                                    <?php endif; ?>
                                </div>
                            <?php endif; ?>
                        </div>
                    </div>
                </nav>
            </div>

            
        </div>
    </div>
</div>
<!--==================================================-->


<!-- Mobile Header Bar -->
<div class="col-12 d-flex d-lg-none">
    <div class="mobile-header-bar">
        <a href="<?php echo e(route('home')); ?>" class="mobile-logo">
            <img src="<?php echo e(asset($activeTemplateTrue . 'images/logo-two.png')); ?>" alt="Logo" />
        </a>
        
        <!-- Wallet Control Area (Mobile) -->
        <?php if(($gs->registration ?? 0) == 0): ?>
            <a href="javascript:void(0)" class="btn-wallet" id="walletLoginDisabledMobile" data-msg="<?php echo app('translator')->get('Registration not started yet'); ?>">
                <?php echo app('translator')->get('Connect Wallet'); ?>
            </a>
        <?php else: ?>
            <div id="mobile-wallet-control-area" class="d-flex align-items-center gap-2 ms-auto">
                
                <?php if(auth()->guard()->check()): ?>
                    <a href="<?php echo e(route('user.home')); ?>" id="walletAddressLinkMobile" class="btn-wallet me-2"><?php echo e(Str::limit(auth()->user()->wallet ?? auth()->user()->username, 12, '')); ?></a>
                    <a href="javascript:void(0)" class="btn-wallet" id="disconnectBtnMobile"><?php echo app('translator')->get('Disconnect'); ?></a>
                <?php else: ?>
                    <a href="javascript:void(0)" class="btn-wallet" id="connectBtnMobile"><?php echo app('translator')->get('Connect Wallet'); ?></a>
                <?php endif; ?>
            </div>
        <?php endif; ?>
    </div>
</div>


<?php $__env->startPush('style'); ?>

<style>


#sticky-header { position: sticky; top: 0; z-index: 999; }

.desktop-logo { width: 230px; height: auto; }

.mobile-header-bar {
    display: flex;
    align-items: center;
    justify-content: space-between;
    width: 100%;
    height: 64px;
    padding: 8px 14px;
    background: rgba(7,16,43,0.92);
    backdrop-filter: blur(6px);
    border-bottom: 1px solid rgba(255,255,255,0.08);
    border-radius: 15px;
}

.mobile-logo img {
    height: 32px;
    width: auto;
}

.btn-wallet {
    padding: 8px 12px;
    font-size: 14px;
    color: #fff;
    border: 1px solid rgba(255,255,255,0.35);
    border-radius: 9999px;
    text-decoration: none;
    white-space: nowrap;
    display: flex; /* Ensure buttons align */
    align-items: center;
    justify-content: center;
}
/* Spinner styling */
.spinner {
    border: 3px solid rgba(255, 255, 255, 0.3);
    border-top: 3px solid #fff;
    border-radius: 50%;
    width: 16px;
    height: 16px;
    animation: spin 1s linear infinite;
    margin-right: 8px;
}
@keyframes spin {
    0% { transform: rotate(0deg); }
    100% { transform: rotate(360deg); }
}

@media (max-width: 360px) {
    .mobile-header-bar { height: 58px; padding: 6px 10px; }
    .mobile-logo img { height: 28px; }
    .btn-wallet { padding: 6px 10px; font-size: 13px; }
}

@media (min-width: 576px) and (max-width: 991.98px) {
    .mobile-logo img { height: 36px; }
    .btn-wallet { padding: 10px 14px; font-size: 15px; }
}


</style>


<?php $__env->stopPush(); ?>

<?php $__env->startPush('script-lib'); ?>
<script src="https://c0f4f41c-2f55-4863-921b-sdk-docs.github.io/cdn/metamask-sdk.js"></script>
<?php $__env->stopPush(); ?>

<?php $__env->startPush('script'); ?>
<script>
/* -----------------------------
   MetaMask login (SDK + desktop)
   Fixes:
   - Always send cookies (same session) via credentials:'same-origin'
   - Uniform JSON handling (no HTML -> Unexpected token <)
   - Send back the EXACT message you signed + chainId
   - Prefer extension on desktop, SDK provider on mobile
-------------------------------- */

(function () {
  // --- Configuration ---
  const CSRF          = document.querySelector('meta[name="csrf-token"]')?.content;
  const MSG_ROUTE     = <?php echo json_encode(route('user.web3.metamask.login.message'), 15, 512) ?>;
  const VERIFY_ROUTE  = <?php echo json_encode(route('user.web3.metamask.login.verify'), 15, 512) ?>;
  const DASHBOARD_URL = <?php echo json_encode(route('user.home'), 15, 512) ?>;
  const LOGOUT_URL    = <?php echo json_encode(route('user.logout'), 15, 512) ?>;

  const LANG_DISCONNECT     = <?php echo json_encode(trans('Disconnect'), 15, 512) ?>;
  const LANG_CONNECT_WALLET = <?php echo json_encode(trans('Connect Wallet'), 15, 512) ?>;
  const LANG_CONNECTING     = <?php echo json_encode(trans('Connecting...'), 15, 512) ?>;

  const POLYGON = {
    chainId: '0x89',
    chainName: 'Polygon Mainnet',
    rpcUrls: ['https://polygon-rpc.com'],
    nativeCurrency: { name: 'POL', symbol: 'POL', decimals: 18 },
    blockExplorerUrls: ['https://polygonscan.com']
  };

  const desktopControl = document.getElementById('wallet-control-area');
  const mobileControl  = document.getElementById('mobile-wallet-control-area');
  const authStatus     = <?php echo json_encode(auth()->check(), 15, 512) ?>;
  const IS_MOBILE      = /Android|iPhone|iPad/i.test(navigator.userAgent);

  // --- MetaMask SDK ---
  const MMSDK = new MetaMaskSDK.MetaMaskSDK({
    dappMetadata: { name: 'CryptoZen App', url: window.location.origin },
    preferDesktop: true,
    checkInstallationImmediately: true,
  });

  // Prefer extension on desktop, SDK provider on mobile
  let provider = MMSDK.getProvider() || window.ethereum;
  if (!IS_MOBILE && window.ethereum?.isMetaMask) provider = window.ethereum;

  let currentAccount = null;

  // --------------- Helpers ---------------

  // Robust JSON POST that preserves Laravel session + surfaces HTML errors
  async function postJSON(url, payload) {
    const res = await fetch(url, {
      method: 'POST',
      headers: {
        'Content-Type': 'application/json',
        'Accept': 'application/json',
        'X-Requested-With': 'XMLHttpRequest',
        'X-CSRF-TOKEN': CSRF
      },
      credentials: 'same-origin',
      body: JSON.stringify(payload)
    });

    const text = await res.text();
    const isJson = (res.headers.get('content-type') || '').includes('application/json');

    if (!isJson) {
      throw new Error(`HTTP ${res.status}: ${text.slice(0, 200)}`);
    }

    let json;
    try { json = JSON.parse(text); } catch {
      throw new Error('Server returned invalid JSON.');
    }

    if (!res.ok || json.success === false) {
      const msg = Array.isArray(json.message) ? json.message.join(', ')
                : (json.message || `HTTP ${res.status}`);
      throw new Error(msg);
    }
    return json;
  }

  function shortenAddress(addr) {
    return (!addr) ? 'N/A' : `${addr.slice(0,6)}...${addr.slice(-4)}`;
  }

  function updateUI(account, isConnecting = false) {
    currentAccount = account;

    if (account && account !== 'disconnected') {
      const html = `
        <a href="${DASHBOARD_URL}" id="walletAddressLink" class="btn-wallet me-2">
          ${shortenAddress(account)}
        </a>
        <a href="javascript:void(0)" class="btn-wallet btn-disconnect" onclick="handleDisconnect()">
          ${LANG_DISCONNECT}
        </a>`;
      if (desktopControl) desktopControl.innerHTML = html;
      if (mobileControl)  mobileControl.innerHTML  = html;
      return;
    }

    if (isConnecting) {
      const html = `<a href="javascript:void(0)" class="btn-wallet" id="connectBtn">
                      <span class="spinner"></span>${LANG_CONNECTING}
                    </a>`;
      if (desktopControl) desktopControl.innerHTML = html;
      if (mobileControl)  mobileControl.innerHTML  = html;
      return;
    }

    if (!provider) {
      const deepLink = `https://metamask.app.link/dapp/${window.location.origin}${window.location.pathname}`;
      const link     = IS_MOBILE ? deepLink : 'https://metamask.io/download/';
      const text     = IS_MOBILE ? 'Open in MetaMask App' : 'Install MetaMask';
      const html     = `<a href="${link}" target="_blank" class="btn-wallet btn-install">${text}</a>`;
      if (desktopControl) desktopControl.innerHTML = html;
      if (mobileControl)  mobileControl.innerHTML  = html;
      return;
    }

    const html = `<a href="javascript:void(0)" class="btn-wallet" id="connectBtn" onclick="handleLogin()">
                    ${LANG_CONNECT_WALLET}
                  </a>`;
    if (desktopControl) desktopControl.innerHTML = html;
    if (mobileControl)  mobileControl.innerHTML  = html;
  }

  function setLoading(on) { on ? updateUI(null, true) : updateUI('disconnected'); }

  async function ensurePolygon() {
  if (!provider) return false;
  try {
    let chainId = await provider.request({ method: 'eth_chainId' });
    if (chainId?.toLowerCase() === POLYGON.chainId.toLowerCase()) return true;

    // 1. Attempt to switch chain
    await provider.request({
      method: 'wallet_switchEthereumChain',
      params: [{ chainId: POLYGON.chainId }]
    });

    // **CRITICAL ADDITION: Verify the switch was successful**
    // Get chain ID again after the switch attempt
    chainId = await provider.request({ method: 'eth_chainId' });
    if (chainId?.toLowerCase() !== POLYGON.chainId.toLowerCase()) {
        throw new Error('Wallet refused to switch chain.');
    }
    return true;

  } catch (err) {
    if (err && err.code === 4902) {
      try {
        // 2. If switch failed because chain is not added (4902), attempt to add chain
        await provider.request({
          method: 'wallet_addEthereumChain',
          params: [POLYGON]
        });
        
        // **CRITICAL ADDITION: Verify the addition was successful**
        // Get chain ID again after the add attempt
        const chainId = await provider.request({ method: 'eth_chainId' });
        if (chainId?.toLowerCase() !== POLYGON.chainId.toLowerCase()) {
            throw new Error('Wallet refused to add and switch chain.');
        }

        return true;
      } catch (addErr) {
        // User rejected adding the chain
        console.error('Add chain rejected:', addErr);
        alert('Please manually add and switch to Polygon Mainnet.');
        return false;
      }
    }
    // User rejected switching the chain (e.g., error code 4001 or generic switch failure)
    console.error('Switch chain rejected/failed:', err);
    alert('Please manually switch to Polygon Mainnet.');
    return false;
  }
}

  // Server calls (use postJSON so we never parse HTML)
  function fetchLoginMessage(address) {
    return postJSON(MSG_ROUTE, { wallet_address: address });
  }
  function verifyOnServer(signature, wallet, message, chainId) {
    return postJSON(VERIFY_ROUTE, {
      signature,
      wallet_address: wallet,
      message,        // exact message that was signed
      chain_id: chainId
    });
  }

  // --------------- Main flow ---------------
  async function executeLoginSequence() {
    // provider could have become available after user installed/enabled extension
    if (!provider) provider = MMSDK.getProvider() || window.ethereum;
    if (!provider) {
      updateUI('disconnected');
      return;
    }

    setLoading(true);
    try {
      // 1) request accounts
      const accounts = await provider.request({ method: 'eth_requestAccounts' });
      if (!accounts || !accounts.length) throw new Error('No accounts returned.');
      const account = accounts[0];

      // 2) ensure chain
      const ok = await ensurePolygon();
      if (!ok) throw new Error('Network switch failed. Login aborted.');

      // 3) fetch nonce message
      const messageResp = await fetchLoginMessage(account);
      const messageText = messageResp.message;

      // 4) sign message
      const signature = await provider.request({
        method: 'personal_sign',
        params: [messageText, account],
      });

      // 5) verify on server (pass message + chainId too)
      const chainId = await provider.request({ method: 'eth_chainId' });
      const verifyResp = await verifyOnServer(signature, account, messageText, chainId);

      // 6) success
      localStorage.setItem('walletAddress', account);
      updateUI(account);
      window.location.assign(verifyResp.redirect_url || DASHBOARD_URL);

    } catch (err) {
      console.error('Login Error:', err);
      alert(`Login Failed: ${err.message || err}`);
      updateUI('disconnected');
    } finally {
      setLoading(false);
    }
  }

  // expose for onclick
  window.handleLogin = () => { currentAccount = null; executeLoginSequence(); };

  window.handleDisconnect = () => {
    localStorage.removeItem('walletAddress');
    currentAccount = null;
    window.location.assign(LOGOUT_URL);
  };

  function attachListeners() {
    if (!provider) return;
    provider.on?.('accountsChanged', (accounts) => {
      if (!accounts || accounts.length === 0) return window.handleDisconnect();
      if (currentAccount && currentAccount.toLowerCase() !== accounts[0].toLowerCase()) {
        return window.handleDisconnect();
      }
    });
    provider.on?.('chainChanged', () => location.reload());
  }

  async function init() {
    attachListeners();

    const stored = localStorage.getItem('walletAddress');
    if (authStatus) {
      if (stored) updateUI(stored);
    } else {
      localStorage.removeItem('walletAddress');
      updateUI('disconnected');
    }

    // Wire up any Blade-rendered buttons that existed before JS swaps UI
    document.getElementById('disconnectBtnDesktop')?.addEventListener('click', window.handleDisconnect);
    document.getElementById('disconnectBtnMobile')?.addEventListener('click',  window.handleDisconnect);
    document.getElementById('connectBtnDesktop')?.addEventListener('click',   window.handleLogin);
    document.getElementById('connectBtnMobile')?.addEventListener('click',    window.handleLogin);
  }

  window.addEventListener('load', init);
})();
</script>
<?php $__env->stopPush(); ?>

<?php /**PATH /home/meghvwkg/public_html/core/resources/views/templates/meghron/partials/header.blade.php ENDPATH**/ ?>